/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.fluid.FluidTankCore;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.MathHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiChunkLoader;
import cofh.thermalexpansion.gui.container.device.ContainerChunkLoader;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileChunkLoader
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.CHUNK_LOADER.getMetadata();
    private static final int TIME_CONSTANT = 18000;
    private int inputTracker;
    private FluidTankCore tank = new FluidTankCore(4000);
    private int offset;

    public static void initialize() {
        TileChunkLoader.SIDE_CONFIGS[TileChunkLoader.TYPE] = new SideConfig();
        TileChunkLoader.SIDE_CONFIGS[TileChunkLoader.TYPE].numConfig = 4;
        TileChunkLoader.SIDE_CONFIGS[TileChunkLoader.TYPE].slotGroups = new int[][]{new int[0], {0}, {0}, new int[0], {0}};
        TileChunkLoader.SIDE_CONFIGS[TileChunkLoader.TYPE].sideTypes = new int[]{0, 1, 5, 6};
        TileChunkLoader.SIDE_CONFIGS[TileChunkLoader.TYPE].defaultSides = new byte[]{0, 1, 1, 1, 1, 1};
        TileChunkLoader.SLOT_CONFIGS[TileChunkLoader.TYPE] = new SlotConfig();
        TileChunkLoader.SLOT_CONFIGS[TileChunkLoader.TYPE].allowInsertionSlot = new boolean[]{true};
        TileChunkLoader.SLOT_CONFIGS[TileChunkLoader.TYPE].allowExtractionSlot = new boolean[]{false};
        GameRegistry.registerTileEntity(TileChunkLoader.class, (String)"thermalexpansion:device_chunk_loader");
        TileChunkLoader.config();
    }

    public static void config() {
        String category = "Device.ChunkLoader";
        BlockDevice.enable[TileChunkLoader.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public TileChunkLoader() {
        this.inventory = new ItemStack[1];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.offset = MathHelper.RANDOM.nextInt(18000);
        this.hasAutoInput = true;
        this.enableAutoInput = true;
    }

    public int getType() {
        return TYPE;
    }

    public void func_73660_a() {
        if (!this.timeCheckOffset()) {
            return;
        }
        this.transferInput();
        boolean curActive = this.isActive;
    }

    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    protected boolean timeCheckOffset() {
        return (this.field_145850_b.func_82737_E() + (long)this.offset) % 18000L == 0L;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiChunkLoader(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerChunkLoader(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.tank.readFromNBT(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b().equals(Items.field_151079_bi);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileChunkLoader.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from == null || SideConfig.allowInsertion((int)((TileChunkLoader)TileChunkLoader.this).sideConfig.sideTypes[TileChunkLoader.this.sideCache[from.ordinal()]])) {
                        return TileChunkLoader.this.tank.fill(resource, doFill);
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileChunkLoader)TileChunkLoader.this).sideConfig.sideTypes[TileChunkLoader.this.sideCache[from.ordinal()]])) {
                        return TileChunkLoader.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileChunkLoader)TileChunkLoader.this).sideConfig.sideTypes[TileChunkLoader.this.sideCache[from.ordinal()]])) {
                        return TileChunkLoader.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

