/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.extruder;

import cofh.thermalexpansion.block.machine.TileExtruder;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.JEIPluginTE;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.ExtruderManager;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ExtruderRecipeWrapper
extends BaseRecipeWrapper {
    protected List<FluidStack> inputFluids;
    protected List<ItemStack> outputItems;
    protected IDrawableAnimated fluid;
    protected IDrawableAnimated progress;
    protected IDrawableAnimated speed;

    public ExtruderRecipeWrapper(IGuiHelper guiHelper, ExtruderManager.ExtruderRecipe recipe) {
        this(guiHelper, recipe, "thermalexpansion.extruder");
    }

    public ExtruderRecipeWrapper(IGuiHelper guiHelper, ExtruderManager.ExtruderRecipe recipe, String uIdIn) {
        this.uId = uIdIn;
        ArrayList<FluidStack> recipeInputFluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        recipeInputFluids.add(recipe.getInputHot());
        recipeInputFluids.add(recipe.getInputCold());
        recipeOutputItems.add(recipe.getOutput());
        this.inputFluids = recipeInputFluids;
        this.outputItems = recipeOutputItems;
        this.energy = recipe.getEnergy();
        IDrawableStatic fluidDrawable = Drawables.getDrawables(guiHelper).getProgress(2);
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getProgressFill(2);
        IDrawableStatic speedDrawable = Drawables.getDrawables(guiHelper).getScaleFill(2);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        int basePower = TileExtruder.basePower;
        this.fluid = guiHelper.createAnimatedDrawable(fluidDrawable, Math.max(10, this.energy / basePower), IDrawableAnimated.StartDirection.LEFT, true);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, Math.max(10, this.energy / basePower), IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(speedDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(FluidStack.class, this.inputFluids);
        ingredients.setOutputs(ItemStack.class, this.outputItems);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        JEIPluginTE.drawFluid(69, 23, this.inputFluids.get(0), 24, 8);
        JEIPluginTE.drawFluid(69, 31, this.inputFluids.get(1), 24, 8);
        if (this.inputFluids.get((int)0).amount < 1000) {
            JEIPluginTE.drawFluid(22, 31, this.inputFluids.get(0), 16, 7);
        }
        if (this.inputFluids.get((int)1).amount < 1000) {
            JEIPluginTE.drawFluid(46, 31, this.inputFluids.get(1), 16, 7);
        }
        this.fluid.draw(minecraft, 69, 23);
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 34, 40);
        this.energyMeter.draw(minecraft, 2, 8);
    }
}

