/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import twilightforest.entity.ITFCharger;
import twilightforest.util.EntityUtil;

public class EntityAITFChargeAttack
extends EntityAIBase {
    private static final double MIN_RANGE_SQ = 16.0;
    private static final double MAX_RANGE_SQ = 64.0;
    private static final int FREQ = 1;
    private EntityCreature charger;
    private EntityLivingBase chargeTarget;
    private double chargeX;
    private double chargeY;
    private double chargeZ;
    protected float speed;
    private final boolean canBreak;
    private int windup;
    private boolean hasAttacked;

    public EntityAITFChargeAttack(EntityCreature entityLiving, float f, boolean canBreak) {
        this.charger = entityLiving;
        this.speed = f;
        this.canBreak = canBreak;
        this.windup = 0;
        this.hasAttacked = false;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        this.chargeTarget = this.charger.func_70638_az();
        if (this.chargeTarget == null) {
            return false;
        }
        double distance = this.charger.func_70068_e((Entity)this.chargeTarget);
        if (distance < 16.0 || distance > 64.0) {
            return false;
        }
        if (!this.charger.field_70122_E) {
            return false;
        }
        Vec3d chargePos = this.findChargePoint((Entity)this.charger, (Entity)this.chargeTarget, 2.1);
        boolean canSeeTargetFromDest = this.charger.func_70635_at().func_75522_a((Entity)this.chargeTarget);
        if (!canSeeTargetFromDest) {
            return false;
        }
        this.chargeX = chargePos.field_72450_a;
        this.chargeY = chargePos.field_72448_b;
        this.chargeZ = chargePos.field_72449_c;
        return this.charger.func_70681_au().nextInt(1) == 0;
    }

    public void func_75249_e() {
        this.windup = 15 + this.charger.func_70681_au().nextInt(30);
    }

    public boolean func_75253_b() {
        return this.windup > 0 || !this.charger.func_70661_as().func_75500_f();
    }

    public void func_75246_d() {
        block6: {
            block4: {
                block5: {
                    this.charger.func_70671_ap().func_75650_a(this.chargeX, this.chargeY - 1.0, this.chargeZ, 10.0f, (float)this.charger.func_70646_bf());
                    if (this.windup <= 0) break block4;
                    if (--this.windup != 0) break block5;
                    this.charger.func_70661_as().func_75492_a(this.chargeX, this.chargeY, this.chargeZ, (double)this.speed);
                    break block6;
                }
                this.charger.field_70721_aZ = (float)((double)this.charger.field_70721_aZ + 0.8);
                if (!(this.charger instanceof ITFCharger)) break block6;
                ((ITFCharger)this.charger).setCharging(true);
                break block6;
            }
            if (this.canBreak && !this.charger.field_70170_p.field_72995_K && ForgeEventFactory.getMobGriefingEvent((World)this.charger.field_70170_p, (Entity)this.charger)) {
                int maxz;
                int maxy;
                int maxx;
                BlockPos max;
                int minz;
                int miny;
                AxisAlignedBB bb = this.charger.func_174813_aQ();
                int minx = MathHelper.func_76128_c((double)(bb.field_72340_a - 0.75));
                BlockPos min = new BlockPos(minx, miny = MathHelper.func_76128_c((double)(bb.field_72338_b + 0.0)), minz = MathHelper.func_76128_c((double)(bb.field_72339_c - 0.75)));
                if (this.charger.field_70170_p.func_175707_a(min, max = new BlockPos(maxx = MathHelper.func_76128_c((double)(bb.field_72336_d + 0.75)), maxy = MathHelper.func_76128_c((double)(bb.field_72337_e + 0.15)), maxz = MathHelper.func_76128_c((double)(bb.field_72334_f + 0.75))))) {
                    for (BlockPos pos : BlockPos.func_177980_a((BlockPos)min, (BlockPos)max)) {
                        if (!EntityUtil.canDestroyBlock(this.charger.field_70170_p, pos, (Entity)this.charger) || this.charger.field_70170_p.func_175625_s(pos) != null) continue;
                        this.charger.field_70170_p.func_175655_b(pos, true);
                    }
                }
            }
        }
        double rangeSq = this.charger.field_70130_N * 2.1f * this.charger.field_70130_N * 2.1f;
        if (this.charger.func_70092_e(this.chargeTarget.field_70165_t, this.chargeTarget.func_174813_aQ().field_72338_b, this.chargeTarget.field_70161_v) <= rangeSq && !this.hasAttacked) {
            this.hasAttacked = true;
            this.charger.func_70652_k((Entity)this.chargeTarget);
        }
    }

    public void func_75251_c() {
        this.windup = 0;
        this.chargeTarget = null;
        this.hasAttacked = false;
        if (this.charger instanceof ITFCharger) {
            ((ITFCharger)this.charger).setCharging(false);
        }
    }

    protected Vec3d findChargePoint(Entity attacker, Entity target, double overshoot) {
        double vecx = target.field_70165_t - attacker.field_70165_t;
        double vecz = target.field_70161_v - attacker.field_70161_v;
        float rangle = (float)Math.atan2(vecz, vecx);
        double distance = MathHelper.func_76133_a((double)(vecx * vecx + vecz * vecz));
        double dx = (double)MathHelper.func_76134_b((float)rangle) * (distance + overshoot);
        double dz = (double)MathHelper.func_76126_a((float)rangle) * (distance + overshoot);
        return new Vec3d(attacker.field_70165_t + dx, target.field_70163_u, attacker.field_70161_v + dz);
    }
}

