/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.util.function.DoubleUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityUtil {
    public static boolean canDestroyBlock(World world, BlockPos pos, Entity entity) {
        return EntityUtil.canDestroyBlock(world, pos, world.func_180495_p(pos), entity);
    }

    public static boolean canDestroyBlock(World world, BlockPos pos, IBlockState state, Entity entity) {
        float hardness = state.func_185887_b(world, pos);
        return hardness >= 0.0f && hardness < 50.0f && !state.func_177230_c().isAir(state, (IBlockAccess)world, pos) && state.func_177230_c().canEntityDestroy(state, (IBlockAccess)world, pos, entity) && (!(entity instanceof EntityLivingBase) || ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)((EntityLivingBase)entity), (BlockPos)pos, (IBlockState)state));
    }

    @Nullable
    public static RayTraceResult rayTrace(Entity entity, double range) {
        Vec3d position = entity.func_174824_e(1.0f);
        Vec3d look = entity.func_70676_i(1.0f);
        Vec3d dest = position.func_72441_c(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range);
        return entity.field_70170_p.func_72933_a(position, dest);
    }

    @Nullable
    public static RayTraceResult rayTrace(EntityPlayer player) {
        return EntityUtil.rayTrace(player, null);
    }

    @Nullable
    public static RayTraceResult rayTrace(EntityPlayer player, @Nullable DoubleUnaryOperator modifier) {
        double range = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        return EntityUtil.rayTrace((Entity)player, modifier == null ? range : modifier.applyAsDouble(range));
    }
}

