/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.addons.hatstand.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.ichun.mods.hats.addons.hatstand.client.render.TileRendererHatStand;
import me.ichun.mods.hats.addons.hatstand.common.HatStand;
import me.ichun.mods.hats.addons.hatstand.common.block.BlockHatStand;
import me.ichun.mods.hats.addons.hatstand.common.packet.PacketStandHatInfo;
import me.ichun.mods.hats.addons.hatstand.common.tileentity.TileEntityHatStand;
import me.ichun.mods.hats.client.core.HatInfoClient;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.core.HatHandler;
import me.ichun.mods.ichunutil.client.render.RendererHelper;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.config.GuiSlider;
import org.lwjgl.input.Keyboard;

public class GuiHatSelection
extends GuiScreen
implements GuiSlider.ISlider {
    private final int ID_PAGE_LEFT = 1;
    private final int ID_DONE_SELECT = 2;
    private final int ID_PAGE_RIGHT = 3;
    private final int ID_CLOSE = 4;
    private final int ID_NONE = 8;
    private final int ID_HAT_COLOUR_SWAP = 9;
    private final int ID_RANDOM = 10;
    private final int ID_HEAD = 11;
    private final int ID_BASE = 12;
    private final int ID_STAND = 13;
    private final int ID_HAT_START_ID = 600;
    private final int VIEW_HATS = 0;
    private final int VIEW_COLOURIZER = 1;
    private String currentDisplay;
    private GuiTextField searchBar;
    private String selectedButtonName = "";
    private int favourite;
    private boolean hasClicked = false;
    private boolean confirmed = false;
    private boolean justClickedButton = false;
    private boolean enabledSearchBar = false;
    public TileEntityHatStand stand;
    public List<String> availableHats;
    public List<String> hatsToShow;
    protected int xSize = 176;
    protected int ySize = 170;
    public float mouseX;
    public float mouseY;
    protected int guiLeft;
    protected int guiTop;
    public int pageNumber;
    public int colourR;
    public int colourG;
    public int colourB;
    public int alpha;
    public int head;
    public boolean base;
    public boolean standPost;
    private String prevHatName;
    private int prevColourR;
    private int prevColourG;
    private int prevColourB;
    private int prevAlpha;
    private int prevHead;
    private GameProfile prevGameProfile;
    private boolean prevBase;
    private boolean prevStandPost;
    private HatInfoClient tempInfo;
    public int view;
    public Random rand;

    public GuiHatSelection(TileEntityHatStand hatStand) {
        if (Hats.config.playerHatsMode == 4) {
            if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
                HatHandler.repopulateHatsList();
            } else {
                Hats.eventHandlerClient.availableHats = new HashMap(Hats.eventHandlerClient.serverHats);
            }
        }
        ArrayList list = new ArrayList();
        for (Map.Entry e : Hats.eventHandlerClient.availableHats.entrySet()) {
            list.add(e.getKey());
        }
        Collections.sort(list);
        this.availableHats = ImmutableList.copyOf(list);
        this.hatsToShow = new ArrayList<String>(this.availableHats);
        Collections.sort(this.hatsToShow);
        this.stand = hatStand;
        this.prevHatName = this.stand.hatName;
        this.prevGameProfile = this.stand.gameProfile;
        this.prevColourR = this.colourR = this.stand.colourR;
        this.prevColourG = this.colourG = this.stand.colourG;
        this.prevColourB = this.colourB = this.stand.colourB;
        this.prevAlpha = this.alpha = this.stand.alpha;
        this.prevHead = this.head = this.stand.head;
        this.prevBase = this.base = this.stand.hasBase;
        this.prevStandPost = this.standPost = this.stand.hasStand;
        this.pageNumber = 0;
        this.view = 0;
        this.rand = new Random();
        this.enabledSearchBar = true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.stand == null) {
            this.field_146297_k.func_147108_a(null);
        } else {
            Keyboard.enableRepeatEvents((boolean)true);
            this.field_146292_n.clear();
            this.guiLeft = (this.field_146294_l - this.xSize) / 2;
            this.guiTop = (this.field_146295_m - this.ySize) / 2;
            this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 6, this.field_146295_m / 2 + 54, 20, 20, "<"));
            this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 + 62, this.field_146295_m / 2 + 54, 20, 20, ">"));
            this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 + 16, this.field_146295_m / 2 + 54, 44, 20, I18n.func_74838_a((String)"gui.done")));
            this.addToolButton(8, 0);
            this.addToolButton(9, 1);
            this.addToolButton(10, 2);
            this.field_146292_n.add(new GuiButton(4, this.field_146294_l - 22, 2, 20, 20, "X"));
            this.pageNumber = 0;
            if (!this.stand.hatName.equalsIgnoreCase("")) {
                for (int i = 0; i < this.hatsToShow.size(); ++i) {
                    String hatName = this.hatsToShow.get(i);
                    if (!hatName.equalsIgnoreCase(this.stand.hatName)) continue;
                    i -= i % 6;
                    this.pageNumber = i / 6;
                    break;
                }
            }
            this.updateButtonList();
            this.searchBar = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 65, this.field_146295_m - 24, 150, 20);
            this.searchBar.func_146203_f(255);
            this.searchBar.func_146180_a(I18n.func_74838_a((String)"hats.gui.search"));
            this.searchBar.func_146193_g(0xAAAAAA);
            this.searchBar.func_146189_e(this.enabledSearchBar);
        }
    }

    public void addToolButton(int id, int i) {
        this.field_146292_n.add(new GuiButton(id, this.field_146294_l / 2 + 89, this.field_146295_m / 2 - 85 + i * 21, 20, 20, ""));
    }

    public void func_73876_c() {
        this.searchBar.func_146178_a();
        if (this.searchBar.func_146206_l()) {
            this.searchBar.func_146189_e(true);
        } else {
            this.searchBar.func_146189_e(this.enabledSearchBar);
        }
        if (this.favourite > 0) {
            --this.favourite;
        }
    }

    public void func_146281_b() {
        if (!this.confirmed) {
            this.stand.hatName = this.prevHatName;
            this.stand.colourR = this.prevColourR;
            this.stand.colourG = this.prevColourG;
            this.stand.colourB = this.prevColourB;
            this.stand.alpha = this.prevAlpha;
            this.stand.head = this.prevHead;
            this.stand.gameProfile = this.prevGameProfile;
            this.stand.hasBase = this.prevBase;
            this.stand.hasStand = this.prevStandPost;
            IBlockState state = this.stand.func_145831_w().func_180495_p(this.stand.func_174877_v());
            this.stand.func_145831_w().func_184138_a(this.stand.func_174877_v(), state, state, 3);
        }
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char c, int i) {
        this.searchBar.func_146201_a(c, i);
        if (this.searchBar.func_146206_l()) {
            this.onSearch();
        }
        if (i == 1) {
            if (this.searchBar.func_146206_l()) {
                this.searchBar.func_146180_a("");
                this.searchBar.func_146195_b(false);
                this.onSearchBarInteract();
            } else {
                this.exitWithoutUpdate();
                this.field_146297_k.func_71381_h();
            }
        }
        if (!this.searchBar.func_146206_l()) {
            GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
            if (i == 19) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.randomize();
            } else if (i == 15 || i == gameSettings.field_74310_D.func_151463_i()) {
                this.searchBar.func_146195_b(true);
                this.onSearchBarInteract();
            } else if (!(i != 35 || this.stand.hatName.equalsIgnoreCase("") && this.view == 0)) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.toggleHatsColourizer();
            } else if (i == 49 && !this.stand.hatName.equalsIgnoreCase("")) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.removeHat();
            }
            if (this.view == 0) {
                if ((i == gameSettings.field_74370_x.func_151463_i() || i == 203) && this.pageNumber > 0) {
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    this.switchPage(true);
                } else if ((i == gameSettings.field_74366_z.func_151463_i() || i == 205) && (this.pageNumber + 1) * 6 < this.hatsToShow.size()) {
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    this.switchPage(false);
                }
            }
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        boolean flag;
        super.func_73864_a(par1, par2, par3);
        boolean bl = flag = par1 >= this.field_146294_l / 2 - 65 && par1 < this.field_146294_l / 2 - 65 + this.field_146294_l && par2 >= this.field_146295_m - 24 && par2 < this.field_146295_m - 24 + this.field_146295_m;
        if (this.enabledSearchBar) {
            this.searchBar.func_146192_a(par1, par2, par3);
            if (par3 == 1 && flag) {
                this.searchBar.func_146180_a("");
                this.onSearch();
            }
            this.onSearchBarInteract();
        }
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        super.func_146286_b(par1, par2, par3);
        this.justClickedButton = false;
    }

    public void onSearch() {
        if (this.searchBar.func_146179_b().equalsIgnoreCase("") || !this.hasClicked && this.searchBar.func_146179_b().equalsIgnoreCase("Search")) {
            this.searchBar.func_146193_g(0xE0E0E0);
            this.hatsToShow = new ArrayList<String>(this.availableHats);
            Collections.sort(this.hatsToShow);
        } else {
            String query = this.searchBar.func_146179_b();
            ArrayList<String> matches = new ArrayList<String>();
            block0: for (String s : this.availableHats) {
                String[] split;
                if (s.toLowerCase().startsWith(query.toLowerCase())) {
                    if (matches.contains(s)) continue;
                    matches.add(s);
                    continue;
                }
                for (String s1 : split = s.split(" ")) {
                    if (!s1.toLowerCase().startsWith(query.toLowerCase())) continue;
                    if (matches.contains(s)) continue block0;
                    matches.add(s);
                    continue block0;
                }
            }
            if (matches.size() == 0) {
                this.searchBar.func_146193_g(0xFF5555);
                this.hatsToShow = new ArrayList<String>(this.availableHats);
                Collections.sort(this.hatsToShow);
            } else {
                this.searchBar.func_146193_g(0xE0E0E0);
                this.pageNumber = 0;
                this.hatsToShow = new ArrayList<String>(matches);
                Collections.sort(this.hatsToShow);
            }
        }
        this.updateButtonList();
    }

    public void onSearchBarInteract() {
        if (this.searchBar.func_146206_l()) {
            this.searchBar.func_146193_g(0xE0E0E0);
            if (!this.hasClicked && this.searchBar.func_146179_b().equalsIgnoreCase(I18n.func_74838_a((String)"hats.gui.search"))) {
                this.hasClicked = true;
                this.searchBar.func_146180_a("");
                this.onSearch();
            }
        } else {
            this.searchBar.func_146193_g(0xAAAAAA);
            if (this.searchBar.func_146179_b().equalsIgnoreCase("")) {
                this.hasClicked = false;
                this.searchBar.func_146180_a(I18n.func_74838_a((String)"hats.gui.search"));
            }
        }
    }

    protected void func_146284_a(GuiButton btn) {
        if (!this.justClickedButton) {
            if (btn.field_146127_k == 2) {
                this.exitAndUpdate();
            }
            if (btn.field_146127_k == 1) {
                this.switchPage(true);
            } else if (btn.field_146127_k == 3) {
                this.switchPage(false);
            } else if (btn.field_146127_k == 4) {
                this.exitWithoutUpdate();
            } else if (btn.field_146127_k == 8) {
                this.removeHat();
            } else if (btn.field_146127_k == 9) {
                this.toggleHatsColourizer();
            } else if (btn.field_146127_k == 10) {
                this.randomize();
            } else if (btn.field_146127_k == 11) {
                ++this.stand.head;
                if (this.stand.head == TileEntityHatStand.headNames.length) {
                    this.stand.head = 0;
                }
                if (this.stand.head == 4) {
                    this.stand.gameProfile = Minecraft.func_71410_x().field_71439_g.func_146103_bH();
                }
                this.head = this.stand.head;
                this.justClickedButton = true;
                this.updateButtonList();
            } else if (btn.field_146127_k == 12) {
                this.stand.hasBase = this.base = !this.base;
                this.justClickedButton = true;
                if (!this.base) {
                    this.standPost = false;
                    this.stand.hasStand = false;
                }
                IBlockState state = this.stand.func_145831_w().func_180495_p(this.stand.func_174877_v());
                this.stand.func_145831_w().func_184138_a(this.stand.func_174877_v(), state, state, 3);
                this.updateButtonList();
            } else if (btn.field_146127_k == 13) {
                this.stand.hasStand = this.standPost = !this.standPost;
                this.justClickedButton = true;
                IBlockState state = this.stand.func_145831_w().func_180495_p(this.stand.func_174877_v());
                this.stand.func_145831_w().func_184138_a(this.stand.func_174877_v(), state, state, 3);
                this.updateButtonList();
            } else if (btn.field_146127_k >= 600) {
                this.justClickedButton = true;
                this.stand.hatName = btn.field_146126_j.toLowerCase();
                this.alpha = 255;
                this.colourB = 255;
                this.colourG = 255;
                this.colourR = 255;
                this.stand.colourR = 255;
                this.stand.colourG = 255;
                this.stand.colourB = 255;
                this.stand.alpha = 255;
                this.updateButtonList();
            }
        }
    }

    public void exitAndUpdate() {
        this.confirmed = true;
        this.field_146297_k.func_147108_a(null);
        HatStand.channel.sendToServer((AbstractPacket)new PacketStandHatInfo(this.stand.func_174877_v(), this.stand.hatName, this.colourR, this.colourG, this.colourB, this.alpha, this.head, this.base, this.standPost));
    }

    public void exitWithoutUpdate() {
        this.field_146297_k.func_147108_a(null);
        this.stand.hatName = this.prevHatName;
        this.stand.colourR = this.prevColourR;
        this.stand.colourG = this.prevColourG;
        this.stand.colourB = this.prevColourB;
        this.stand.head = this.prevHead;
        this.stand.gameProfile = this.prevGameProfile;
        this.stand.hasBase = this.prevBase;
        this.stand.hasStand = this.prevStandPost;
        IBlockState state = this.stand.func_145831_w().func_180495_p(this.stand.func_174877_v());
        this.stand.func_145831_w().func_184138_a(this.stand.func_174877_v(), state, state, 3);
    }

    public void updateButtonList() {
        int button;
        for (int k1 = this.field_146292_n.size() - 1; k1 >= 0; --k1) {
            GuiButton btn = (GuiButton)this.field_146292_n.get(k1);
            if (btn.field_146127_k >= 5 && btn.field_146127_k <= 7 || btn.field_146127_k == 15 || btn.field_146127_k >= 11 && btn.field_146127_k <= 13 || btn.field_146127_k >= 600) {
                this.field_146292_n.remove(k1);
                continue;
            }
            if (btn.field_146127_k == 1) {
                if (this.pageNumber == 0 || this.view == 1) {
                    btn.field_146124_l = false;
                    continue;
                }
                btn.field_146124_l = true;
                continue;
            }
            if (btn.field_146127_k == 3) {
                if ((this.pageNumber + 1) * 6 >= this.hatsToShow.size() || this.view == 1) {
                    btn.field_146124_l = false;
                    continue;
                }
                btn.field_146124_l = true;
                continue;
            }
            if (btn.field_146127_k == 8) {
                if (this.stand.hatName.equalsIgnoreCase("")) {
                    btn.field_146124_l = false;
                    continue;
                }
                btn.field_146124_l = true;
                continue;
            }
            if (btn.field_146127_k != 2) continue;
            btn.field_146124_l = this.view != 1;
        }
        if (this.view == 0) {
            int pageCount;
            button = 0;
            for (int i = this.pageNumber * 6; i < this.hatsToShow.size() && i < (this.pageNumber + 1) * 6; ++i) {
                String hatName = this.hatsToShow.get(i);
                GuiButton btn = new GuiButton(600 + i, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 22 * button, 88, 20, hatName);
                if (this.view == 0 && hatName.toLowerCase().equalsIgnoreCase(this.stand.hatName)) {
                    btn.field_146124_l = false;
                }
                this.field_146292_n.add(btn);
                if (++button != 6) continue;
                button = 0;
                break;
            }
            if ((pageCount = (int)Math.ceil((float)this.hatsToShow.size() / 6.0f)) <= 0) {
                pageCount = 1;
            }
            this.currentDisplay = I18n.func_74838_a((String)"hats.gui.allHats") + " (" + (this.pageNumber + 1) + "/" + pageCount + ")";
        } else if (this.view == 1) {
            button = 0;
            for (int i = 0; i < 4; ++i) {
                GuiSlider btn = new GuiSlider(i == 3 ? 15 : 5 + i, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 22 * button, 88, 20, i == 0 ? I18n.func_74838_a((String)"item.fireworksCharge.red") + ": " : (i == 1 ? I18n.func_74838_a((String)"item.fireworksCharge.green") + ": " : (i == 2 ? I18n.func_74838_a((String)"item.fireworksCharge.blue") + ": " : I18n.func_74838_a((String)"hats.gui.alpha") + ": ")), "", 0.0, 255.0, i == 0 ? (double)this.colourR : (i == 1 ? (double)this.colourG : (i == 2 ? (double)this.colourB : (double)this.alpha)), false, true, (GuiSlider.ISlider)this);
                this.field_146292_n.add(btn);
                ++button;
            }
            this.field_146292_n.add(new GuiButton(11, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 22 * button, 88, 20, I18n.func_74838_a((String)"item.skull.char.name") + ": " + TileEntityHatStand.headNames[this.stand.head]));
            this.field_146292_n.add(new GuiButton(12, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 22 * ++button, 88, 20, I18n.func_74838_a((String)"hats.addon.hatstands.gui.base") + ": " + (this.base ? I18n.func_74838_a((String)"gui.yes") : I18n.func_74838_a((String)"gui.no"))));
            GuiButton btn = new GuiButton(13, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 22 * ++button, 88, 20, I18n.func_74838_a((String)"hats.addon.hatstands.gui.stand") + ": " + (this.standPost ? I18n.func_74838_a((String)"gui.yes") : I18n.func_74838_a((String)"gui.no")));
            if (!this.stand.isOnFloor || !this.base) {
                btn.field_146124_l = false;
            }
            this.field_146292_n.add(btn);
            ++button;
            this.currentDisplay = I18n.func_74838_a((String)"hats.gui.personalize");
        }
    }

    public void removeHat() {
        this.stand.hatName = "";
        this.updateButtonList();
    }

    public void switchPage(boolean left) {
        if (left) {
            --this.pageNumber;
            if (this.pageNumber < 0) {
                this.pageNumber = 0;
            }
            this.updateButtonList();
        } else {
            ++this.pageNumber;
            if (this.pageNumber * 6 >= this.hatsToShow.size()) {
                --this.pageNumber;
            }
            this.updateButtonList();
        }
    }

    public void toggleHatsColourizer() {
        this.view = this.view > 0 ? 0 : 1;
        this.hatsToShow = new ArrayList<String>(this.availableHats);
        Collections.sort(this.hatsToShow);
        this.searchBar.func_146180_a("");
        this.onSearchBarInteract();
        this.updateButtonList();
    }

    public void randomize() {
        if (this.view == 0) {
            if (this.hatsToShow.size() > 0) {
                int randVal = this.rand.nextInt(this.hatsToShow.size());
                String hatName = this.hatsToShow.get(randVal);
                this.stand.hatName = hatName.toLowerCase();
                this.alpha = 255;
                this.colourB = 255;
                this.colourG = 255;
                this.colourR = 255;
                this.stand.colourR = 255;
                this.stand.colourG = 255;
                this.stand.colourB = 255;
                this.stand.alpha = 255;
                this.pageNumber = randVal / 6;
                if (GuiHatSelection.func_146272_n()) {
                    this.view = 1;
                    this.updateButtonList();
                    this.randomizeColour();
                    this.view = 0;
                }
                this.updateButtonList();
            }
        } else if (this.view == 1) {
            if (GuiHatSelection.func_146272_n()) {
                this.alpha = 255;
                this.colourB = 255;
                this.colourG = 255;
                this.colourR = 255;
                this.stand.colourR = 255;
                this.stand.colourG = 255;
                this.stand.colourB = 255;
                this.stand.alpha = 255;
                this.updateButtonList();
            } else {
                this.randomizeColour();
            }
        }
    }

    public void randomizeColour() {
        for (int k1 = this.field_146292_n.size() - 1; k1 >= 0; --k1) {
            GuiButton btn1 = (GuiButton)this.field_146292_n.get(k1);
            if (!(btn1 instanceof GuiSlider)) continue;
            GuiSlider slider = (GuiSlider)btn1;
            if (slider.field_146127_k < 5 || slider.field_146127_k > 7) continue;
            slider.sliderValue = this.stand.hatName.equalsIgnoreCase("") ? 0.0 : (double)this.rand.nextFloat();
            slider.updateSlider();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(me.ichun.mods.hats.client.gui.GuiHatSelection.texChooser);
        int k = this.guiLeft;
        int l = this.guiTop;
        this.func_73729_b(k, l, 0, 0, this.xSize, this.ySize);
        this.field_146297_k.func_110434_K().func_110577_a(me.ichun.mods.hats.client.gui.GuiHatSelection.texIcons);
        Iterator iterator = this.field_146292_n.iterator();
        while (iterator.hasNext()) {
            GuiButton aButtonList;
            GuiButton btn = aButtonList = (GuiButton)iterator.next();
            String disp = btn.field_146126_j;
            if (btn.field_146127_k >= 600) {
                int id = btn.field_146127_k - 600;
                if (this.pageNumber * 6 > id || (this.pageNumber + 1) * 6 <= id) continue;
                if (btn.field_146126_j.length() > 16) {
                    btn.field_146126_j = btn.field_146126_j.substring(0, 13) + "...";
                }
            }
            btn.func_191745_a(this.field_146297_k, par1, par2, par3);
            if (!(btn instanceof GuiSlider)) {
                btn.field_146126_j = disp;
            }
            if (btn.field_146127_k != 9 && btn.field_146127_k != 8 && btn.field_146127_k != 10) continue;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.field_146297_k.func_110434_K().func_110577_a(me.ichun.mods.hats.client.gui.GuiHatSelection.texIcons);
            if (btn.field_146125_m) {
                if (btn.field_146127_k == 9) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, this.view == 0 ? 176 : 0, 0, 16, 16);
                } else if (btn.field_146127_k == 8) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 32, 0, 16, 16);
                } else if (btn.field_146127_k == 10) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 80, 0, 16, 16);
                }
            }
            GlStateManager.func_179084_k();
        }
        this.func_73731_b(this.field_146289_q, "Viewing: " + this.currentDisplay, this.guiLeft, this.guiTop - 9, 0xFFFFFF);
        this.mouseX = par1;
        this.mouseY = par2;
        this.drawSearchBar();
        this.drawPlayerOnGui(k + 42, l + 155, 55, (float)(k + 42) - this.mouseX, (float)(l + 155 - 42) - this.mouseY);
        this.drawForeground(par1, par2, par3);
    }

    public void drawForeground(int par1, int par2, float par3) {
        for (GuiButton aButtonList : this.field_146292_n) {
            GuiButton btn = aButtonList;
            if (!btn.func_146115_a()) continue;
            if (btn.field_146127_k >= 600 && btn.field_146126_j.length() > 16) {
                this.drawTooltip(Arrays.asList("\u00a77" + btn.field_146126_j), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 4) {
                this.drawTooltip(Arrays.asList(I18n.func_74838_a((String)"hats.gui.discardChanges")), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 8) {
                this.drawTooltip(Arrays.asList(I18n.func_74838_a((String)"hats.gui.removeHat") + " (N)"), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 9) {
                this.drawTooltip(Arrays.asList((this.view == 0 ? I18n.func_74838_a((String)"hats.gui.personalize") : I18n.func_74838_a((String)"hats.gui.hatsList")) + " (H)"), par1, par2);
                continue;
            }
            if (btn.field_146127_k != 10) continue;
            this.drawTooltip(Arrays.asList((this.view == 0 ? I18n.func_74838_a((String)"hats.gui.randomHat") : (GuiHatSelection.func_146272_n() ? I18n.func_74838_a((String)"hats.gui.resetColor") : I18n.func_74838_a((String)"hats.gui.randomColor"))) + " (R)"), par1, par2);
        }
    }

    protected void drawTooltip(List par1List, int par2, int par3) {
        if (!par1List.isEmpty()) {
            GlStateManager.func_179101_C();
            GlStateManager.func_179097_i();
            int k = 0;
            for (Object aPar1List : par1List) {
                String s = (String)aPar1List;
                int l = this.field_146289_q.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_146294_l) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_146295_m) {
                j1 = this.field_146295_m - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = (String)par1List.get(k2);
                this.field_146289_q.func_175063_a(s1, (float)i1, (float)j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            GlStateManager.func_179126_j();
            GlStateManager.func_179091_B();
        }
    }

    public void drawPlayerOnGui(int par1, int par2, int par3, float par4, float par5) {
        if (this.stand != null) {
            RenderHelper.func_74520_c();
            GlStateManager.func_179142_g();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)par1, (float)par2, (float)50.0f);
            GlStateManager.func_179109_b((float)23.0f, (float)-20.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)(-par3), (float)par3, (float)par3);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)-80.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
            GlStateManager.func_179114_b((float)(-((float)Math.atan(par4 / 40.0f)) * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-((float)Math.atan(par5 / 40.0f)) * 20.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
            if (this.stand.orientation == 0) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (this.stand.orientation == 1) {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (this.stand.orientation == 3) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GlStateManager.func_179108_z();
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            IBlockState state = HatStand.blockHatStand.func_176223_P().func_177226_a((IProperty)BlockHatStand.TYPE, (Comparable)Integer.valueOf(this.stand.hasBase ? (this.stand.hasStand ? (this.stand.hatName.isEmpty() ? 0 : 1) : (this.stand.isOnFloor ? 2 : EnumFacing.func_82600_a((int)this.stand.sideOn).ordinal() + 2)) : 3));
            RendererHelper.renderBakedModel((IBakedModel)this.field_146297_k.func_175602_ab().func_175023_a().func_178125_b(state), (int)-1, (ItemStack)ItemStack.field_190927_a);
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
            HatInfoClient info = this.stand.info;
            if (this.tempInfo == null || info == null || !this.tempInfo.hatName.equalsIgnoreCase(this.stand.hatName) || this.tempInfo.colourR != this.stand.colourR || this.tempInfo.colourG != this.stand.colourG || this.tempInfo.colourB != this.stand.colourB || this.tempInfo.alpha != this.stand.alpha) {
                this.tempInfo = new HatInfoClient(this.stand.hatName, this.stand.colourR, this.stand.colourG, this.stand.colourB, this.stand.alpha);
            }
            this.stand.info = this.tempInfo;
            TileRendererHatStand.renderer.render(this.stand, 0.0, 0.0, 0.0, 1.0f, -1, 1.0f);
            this.stand.info = info;
            GlStateManager.func_179121_F();
            GlStateManager.func_179101_C();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            RenderHelper.func_74518_a();
        }
    }

    public void drawSearchBar() {
        if (this.searchBar.func_146176_q()) {
            this.searchBar.func_146194_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.field_146297_k.func_110434_K().func_110577_a(me.ichun.mods.hats.client.gui.GuiHatSelection.texIcons);
            this.func_73729_b(this.field_146294_l / 2 - 85, this.field_146295_m - 22, 128, 0, 16, 16);
            GlStateManager.func_179084_k();
        }
    }

    public void onChangeSliderValue(GuiSlider slider) {
        if (slider.field_146127_k == 5) {
            this.stand.colourR = this.colourR = (int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue);
        } else if (slider.field_146127_k == 6) {
            this.stand.colourG = this.colourG = (int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue);
        } else if (slider.field_146127_k == 7) {
            this.stand.colourB = this.colourB = (int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue);
        } else if (slider.field_146127_k == 15) {
            this.stand.alpha = this.alpha = (int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue);
        }
    }
}

