/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.widget;

import ht.treechop.client.gui.util.GUIUtil;
import ht.treechop.client.gui.widget.Widget;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class StickyWidget
extends Widget {
    protected static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("textures/gui/widgets.png");
    private final Supplier<State> stateSupplier;
    private final Runnable onPress;
    private final ITextComponent text;

    public StickyWidget(int x, int y, int width, int height, ITextComponent text, Runnable onPress, Supplier<State> stateSupplier) {
        super(x, y, Math.max(width, GUIUtil.getMinimumButtonWidth(text)), Math.max(height, 20));
        this.onPress = onPress;
        this.stateSupplier = stateSupplier;
        this.text = text;
    }

    public StickyWidget(int x, int y, ITextComponent text, Runnable onPress) {
        super(x, y, Math.max(Minecraft.func_71410_x().field_71466_p.func_78256_a(text.func_150260_c()), GUIUtil.getMinimumButtonWidth(text)), 20);
        this.onPress = onPress;
        this.stateSupplier = () -> State.Up;
        this.text = text;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.active = this.stateSupplier.get() == State.Up;
        this.getBox().setHeight(Math.min(this.getHeight(), 20));
        this.renderButton(mouseX, mouseY, partialTicks);
    }

    @Override
    public void onClick(int mouseX, int mouseY, int button) {
        this.onPress.run();
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontrenderer = minecraft.field_71466_p;
        minecraft.func_110434_K().func_110577_a(WIDGETS_LOCATION);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.getBox().getLeft();
        int y = this.getBox().getTop();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.stateSupplier.get() != State.Locked) {
            int i = this.getYImage(this.isHovered());
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179126_j();
            this.blit(x, y, 0, 46 + i * 20, width / 2, height);
            this.blit(x + width / 2, y, 200 - width / 2, 46 + i * 20, width / 2, height);
        }
        StickyWidget.drawString(this.text, x + (width - fontrenderer.func_78256_a(this.text.func_150260_c())) / 2, y + (height - 8) / 2, this.getFGColor());
    }

    private int getFGColor() {
        return this.active ? 0xFFFFFF : 0xA0A0A0;
    }

    public static enum State {
        Up,
        Down,
        Locked;


        public static State of(boolean enabled, boolean canBeEnabled) {
            if (canBeEnabled) {
                return enabled ? Down : Up;
            }
            return Locked;
        }
    }
}

