/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.capabilities;

import ht.treechop.TreeChopMod;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.SneakBehavior;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.FakePlayer;

public class ChopSettingsCapability
extends ChopSettings {
    @CapabilityInject(value=ChopSettingsCapability.class)
    public static final Capability<ChopSettingsCapability> CAPABILITY = null;
    private boolean isSynced = false;

    public boolean isSynced() {
        return this.isSynced;
    }

    public void setSynced() {
        this.isSynced = true;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(ChopSettingsCapability.class, (Capability.IStorage)new Storage(), ChopSettingsCapability::new);
    }

    public static Optional<ChopSettingsCapability> forPlayer(EntityPlayer player) {
        Optional<Object> lazyCapability = Optional.of(player.getCapability(CAPABILITY, null));
        if (!lazyCapability.isPresent() && !(player instanceof FakePlayer)) {
            TreeChopMod.LOGGER.warn("Player " + player + " is missing chop settings");
        }
        return Optional.of(player.getCapability(CAPABILITY, null));
    }

    public static class Storage
    implements Capability.IStorage<ChopSettingsCapability> {
        private static final String CHOPPING_ENABLED_KEY = "choppingEnabled";
        private static final String FELLING_ENABLED_KEY = "fellingEnabled";
        private static final String SNEAK_BEHAVIOR_KEY = "sneakBehavior";
        private static final String TREES_MUST_HAVE_LEAVES_KEY = "treesMustHaveLeaves";
        private static final String CHOP_IN_CREATIVE_MODE_KEY = "chopInCreativeMode";
        private static final String IS_SYNCED_KEY = "isSynced";

        @Nullable
        public NBTBase writeNBT(Capability<ChopSettingsCapability> capability, ChopSettingsCapability instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a(CHOPPING_ENABLED_KEY, instance.getChoppingEnabled());
            nbt.func_74757_a(FELLING_ENABLED_KEY, instance.getFellingEnabled());
            nbt.func_74778_a(SNEAK_BEHAVIOR_KEY, instance.getSneakBehavior().name());
            nbt.func_74757_a(TREES_MUST_HAVE_LEAVES_KEY, instance.getTreesMustHaveLeaves());
            nbt.func_74757_a(CHOP_IN_CREATIVE_MODE_KEY, instance.getChopInCreativeMode());
            nbt.func_74757_a(IS_SYNCED_KEY, instance.isSynced());
            return nbt;
        }

        public void readNBT(Capability<ChopSettingsCapability> capability, ChopSettingsCapability instance, EnumFacing side, NBTBase nbt) {
            if (nbt instanceof NBTTagCompound) {
                SneakBehavior sneakBehavior;
                NBTTagCompound compoundNbt = (NBTTagCompound)nbt;
                Optional<Boolean> choppingEnabled = this.getBoolean(compoundNbt, CHOPPING_ENABLED_KEY);
                Optional<Boolean> fellingEnabled = this.getBoolean(compoundNbt, FELLING_ENABLED_KEY);
                try {
                    sneakBehavior = SneakBehavior.valueOf(compoundNbt.func_74779_i(SNEAK_BEHAVIOR_KEY));
                }
                catch (IllegalArgumentException e) {
                    TreeChopMod.LOGGER.warn(String.format("NBT contains bad sneak behavior value \"%s\"; using default value instead", compoundNbt.func_74779_i(SNEAK_BEHAVIOR_KEY)));
                    sneakBehavior = SneakBehavior.INVERT_CHOPPING;
                }
                Optional<Boolean> onlyChopTreesWithLeaves = this.getBoolean(compoundNbt, TREES_MUST_HAVE_LEAVES_KEY);
                Optional<Boolean> chopInCreativeMode = this.getBoolean(compoundNbt, CHOP_IN_CREATIVE_MODE_KEY);
                Optional<Boolean> isSynced = this.getBoolean(compoundNbt, IS_SYNCED_KEY);
                instance.setChoppingEnabled(choppingEnabled.orElse(instance.getChoppingEnabled()));
                instance.setFellingEnabled(fellingEnabled.orElse(instance.getFellingEnabled()));
                instance.setSneakBehavior(sneakBehavior);
                instance.setTreesMustHaveLeaves(onlyChopTreesWithLeaves.orElse(instance.getTreesMustHaveLeaves()));
                instance.setChopInCreativeMode(chopInCreativeMode.orElse(instance.getChopInCreativeMode()));
                if (isSynced.orElse(false).booleanValue()) {
                    instance.setSynced();
                }
            } else {
                TreeChopMod.LOGGER.warn("Failed to read ChopSettingsCapability NBT");
            }
        }

        private Optional<Boolean> getBoolean(NBTTagCompound compoundNbt, String key) {
            return compoundNbt.func_74764_b(key) ? Optional.of(compoundNbt.func_74767_n(key)) : Optional.empty();
        }
    }
}

