/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.compat;

import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.event.ChopEvent;
import ht.treechop.common.event.CompatRegistrationEvent;
import ht.treechop.common.util.TickUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="treechop")
public class NoChopRecursion {
    private static Map<EntityPlayer, Long> lastChopTickByPlayers = new HashMap<EntityPlayer, Long>();

    @SubscribeEvent
    public static void commonSetup(CompatRegistrationEvent event) {
        if (ConfigHandler.COMMON.preventChopRecursion.get()) {
            MinecraftForge.EVENT_BUS.register(EventHandler.class);
        }
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onChop(ChopEvent.StartChopEvent event) {
            EntityPlayer agent = event.getPlayer();
            long time = event.getWorld().func_82737_E();
            if (lastChopTickByPlayers.getOrDefault(agent, TickUtil.NEVER) == time) {
                event.setCanceled(true);
            } else {
                lastChopTickByPlayers.put(agent, time);
            }
        }
    }
}

