/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.core;

import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.config.RPConfig;
import com.therandomlabs.randompatches.core.Patch;
import com.therandomlabs.randompatches.core.RPClassWriter;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.config.ConfigManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class RPTransformer
implements IClassTransformer {
    private static final Map<String, Patch> PATCHES = new HashMap<String, Patch>();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        Patch patch = PATCHES.get(transformedName);
        if (patch == null) {
            return basicClass;
        }
        RandomPatches.LOGGER.debug("Transforming class: " + transformedName);
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        try {
            if (!patch.apply(node)) {
                RandomPatches.LOGGER.info("Didn't transform class: " + transformedName);
                return basicClass;
            }
            RPClassWriter writer = new RPClassWriter(patch.computeFrames() ? 2 : 1);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        catch (Exception ex) {
            RandomPatches.LOGGER.error("Failed to transform class: " + transformedName, (Throwable)ex);
            return basicClass;
        }
    }

    public static void register(String className, Patch patch) {
        PATCHES.put(className, patch);
    }

    static {
        ConfigManager.register(RPConfig.class);
        RandomPatches.registerPatches();
    }
}

