/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch;

import com.therandomlabs.randompatches.core.Patch;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class EntityPatch
extends Patch {
    public static final String SET_POSITION = EntityPatch.getName("setPosition", "func_70107_b");

    @Override
    public boolean apply(ClassNode node) {
        this.patchWriteToNBT(EntityPatch.findInstructions(node, "writeToNBT", "func_189511_e"));
        this.patchReadFromNBT(EntityPatch.findInstructions(node, "readFromNBT", "func_70020_e"));
        return true;
    }

    @Override
    public boolean computeFrames() {
        return true;
    }

    private void patchWriteToNBT(InsnList instructions) {
        MethodInsnNode setTag = null;
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 182) continue;
            setTag = (MethodInsnNode)instruction;
            if ("net/minecraft/nbt/NBTTagCompound".equals(setTag.owner)) break;
            setTag = null;
        }
        InsnList newInstructions = new InsnList();
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "writeAABBTag", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/nbt/NBTTagCompound;)V", false));
        instructions.insert((AbstractInsnNode)setTag, newInstructions);
    }

    private void patchReadFromNBT(InsnList instructions) {
        LabelNode jumpTo;
        JumpInsnNode jumpIfShouldNotSetPosition = null;
        MethodInsnNode setPosition = null;
        for (int i = instructions.size() - 1; i >= 0; --i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (setPosition == null) {
                if (instruction.getOpcode() != 182) continue;
                setPosition = (MethodInsnNode)instruction;
                if (SET_POSITION.equals(setPosition.name)) continue;
                setPosition = null;
                continue;
            }
            if (instruction.getOpcode() != 153) continue;
            jumpIfShouldNotSetPosition = (JumpInsnNode)instruction;
            break;
        }
        InsnList newInstructions = new InsnList();
        jumpIfShouldNotSetPosition.label = jumpTo = new LabelNode();
        newInstructions.add((AbstractInsnNode)jumpTo);
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "readAABBTag", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/nbt/NBTTagCompound;)V", false));
        instructions.insert((AbstractInsnNode)setPosition, newInstructions);
    }
}

