/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.model;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.proxy.block.BlockConveyor;
import com.buuz135.industrial.proxy.client.model.ConveyorModelData;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;

public class ConveyorBlockModel
implements IBakedModel {
    public static Cache<Pair<Pair<String, Pair<EnumFacing, EnumFacing>>, EnumFacing>, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build();
    private IModelState state;
    private VertexFormat format;
    private IBakedModel previousConveyor;
    private Map<EnumFacing, List<BakedQuad>> prevQuads = new HashMap<EnumFacing, List<BakedQuad>>();

    public ConveyorBlockModel(IBakedModel previousConveyor) {
        this.previousConveyor = previousConveyor;
        this.state = TRSRTransformation.identity();
        this.format = DefaultVertexFormats.field_176600_a;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state == null || !(state instanceof IExtendedBlockState)) {
            if (!this.prevQuads.containsKey(side)) {
                this.prevQuads.put(side, this.previousConveyor.func_188616_a(state, side, rand));
            }
            return this.prevQuads.get(side);
        }
        if (!this.prevQuads.containsKey(side)) {
            this.prevQuads.put(side, this.previousConveyor.func_188616_a(state, side, rand));
        }
        ConveyorModelData data = (ConveyorModelData)((IExtendedBlockState)state).getValue(ConveyorModelData.UPGRADE_PROPERTY);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>((Collection)this.prevQuads.get(side));
        for (ConveyorUpgrade upgrade : data.getUpgrades().values()) {
            if (upgrade == null) continue;
            List upgradeQuads = (List)CACHE.getIfPresent((Object)Pair.of((Object)Pair.of((Object)upgrade.getFactory().getRegistryName().toString(), (Object)Pair.of((Object)upgrade.getSide(), (Object)state.func_177229_b((IProperty)BlockConveyor.FACING))), (Object)side));
            if (upgradeQuads == null) {
                try {
                    IModel model = ModelLoaderRegistry.getModel((ResourceLocation)upgrade.getFactory().getModel(upgrade.getSide(), (EnumFacing)state.func_177229_b((IProperty)BlockConveyor.FACING)));
                    upgradeQuads = model.bake(this.state, this.format, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString())).func_188616_a(state, side, rand);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                CACHE.put((Object)Pair.of((Object)Pair.of((Object)upgrade.getFactory().getRegistryName().toString(), (Object)Pair.of((Object)upgrade.getSide(), (Object)state.func_177229_b((IProperty)BlockConveyor.FACING))), (Object)side), (Object)upgradeQuads);
            }
            if (upgradeQuads.isEmpty()) continue;
            quads.addAll(upgradeQuads);
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.previousConveyor.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.previousConveyor.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.previousConveyor.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.previousConveyor.func_177554_e();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.previousConveyor.func_188617_f();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return this.previousConveyor.handlePerspective(cameraTransformType);
    }

    public ItemCameraTransforms func_177552_f() {
        return this.previousConveyor.func_177552_f();
    }
}

