/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.agriculture;

import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class WaterResourcesCollectorTile
extends WorkingAreaElectricMachine {
    private ItemStackHandler outFish;

    public WaterResourcesCollectorTile() {
        super(WaterResourcesCollectorTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.outFish = new ItemStackHandler(18){

            protected void onContentsChanged(int slot) {
                WaterResourcesCollectorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outFish, EnumDyeColor.GREEN, "Fish output", 54, 25, 6, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outFish, "outFish");
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (this.field_145850_b.field_73012_v.nextBoolean() && this.field_145850_b.field_73012_v.nextBoolean()) {
            return 1.0f;
        }
        List<BlockPos> blockPos = BlockUtils.getBlockPosInAABB(this.getWorkingArea());
        boolean allWaterSources = true;
        for (BlockPos pos : blockPos) {
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            if (state.func_177230_c().equals(FluidRegistry.WATER.getBlock()) && state.func_177230_c().func_176201_c(state) == 0) continue;
            allWaterSources = false;
        }
        if (allWaterSources) {
            LootContext.Builder lootcontext = new LootContext.Builder((WorldServer)this.field_145850_b);
            List items = this.field_145850_b.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(this.field_145850_b.field_73012_v, lootcontext.func_186471_a());
            for (ItemStack stack : items) {
                ItemHandlerHelper.insertItem((IItemHandler)this.outFish, (ItemStack)stack.func_77946_l(), (boolean)false);
            }
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public AxisAlignedBB getWorkingArea() {
        return super.getWorkingArea().func_72317_d(0.0, -2.0, 0.0);
    }
}

