/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack;

import de.eydamos.backpack.Backpack;
import de.eydamos.backpack.init.BackpackItems;
import de.eydamos.backpack.init.Configurations;
import de.eydamos.backpack.item.EBackpack;
import de.eydamos.backpack.item.EFrame;
import de.eydamos.backpack.item.EPiece;
import de.eydamos.backpack.item.EStick;
import de.eydamos.backpack.item.ItemBackpack;
import de.eydamos.backpack.item.ItemFunctionless;
import de.eydamos.backpack.misc.EItemStack;
import de.eydamos.backpack.recipe.AbstractRecipe;
import de.eydamos.backpack.recipe.RecipeBackpackBig;
import de.eydamos.backpack.recipe.RecipeBackpackMedium;
import de.eydamos.backpack.recipe.RecipeBackpackPieceBottom;
import de.eydamos.backpack.recipe.RecipeBackpackPieceMiddle;
import de.eydamos.backpack.recipe.RecipeBackpackPieceTop;
import de.eydamos.backpack.recipe.RecipeBackpackSmall;
import de.eydamos.backpack.recipe.RecipeRecolorBackpack;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public enum Features {
    STICK{

        @Override
        void addItems(IForgeRegistry<Item> registry) {
            stick = new ItemFunctionless("stick", 64, true);
            registry.register((IForgeRegistryEntry)stick);
        }

        @Override
        void addModel() {
            for (Map.Entry<Integer, String> variant : EStick.getVariants().entrySet()) {
                ModelLoader.setCustomModelResourceLocation((Item)BackpackItems.stick, (int)variant.getKey(), (ModelResourceLocation)this.getResource(variant.getValue()));
            }
        }

        @Override
        public String getConfigComment() {
            return "Enable all stick recipes";
        }
    }
    ,
    STICK_STONE(STICK){

        @Override
        void addOreDict() {
            OreDictionary.registerOre((String)"stickStone", (ItemStack)new ItemStack(stick, 1, EStick.STONE.getDamage()));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "stick_stone", EItemStack.STICK_STONE.getItemStack(4), new Object[]{"S", "S", Character.valueOf('S'), "stone"});
        }

        @Override
        public String getConfigComment() {
            return "Enable stone stick recipe";
        }
    }
    ,
    STICK_IRON(STICK){

        @Override
        void addOreDict() {
            OreDictionary.registerOre((String)"stickIron", (ItemStack)new ItemStack(stick, 1, EStick.IRON.getDamage()));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "stick_iron", EItemStack.STICK_IRON.getItemStack(2), new Object[]{"S", "S", Character.valueOf('S'), "ingotIron"});
        }

        @Override
        public String getConfigComment() {
            return "Enable iron stick recipe";
        }
    }
    ,
    LEATHER_BOUND{

        @Override
        void addItems(IForgeRegistry<Item> registry) {
            registry.register((IForgeRegistryEntry)new ItemFunctionless("bound_leather"));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "bound_leather", new ItemStack(BackpackItems.bound_leather), new Object[]{"SSS", "LSL", "SSS", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('L'), Items.field_151116_aA});
        }

        @Override
        void addModel() {
            ModelLoader.setCustomModelResourceLocation((Item)BackpackItems.bound_leather, (int)0, (ModelResourceLocation)this.getResource(""));
        }

        @Override
        public String getConfigComment() {
            return "Enable bound leather recipe";
        }
    }
    ,
    LEATHER_TANNED{

        @Override
        void addItems(IForgeRegistry<Item> registry) {
            registry.register((IForgeRegistryEntry)new ItemFunctionless("tanned_leather"));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(BackpackItems.bound_leather), (ItemStack)new ItemStack(BackpackItems.tanned_leather), (float)0.1f);
        }

        @Override
        void addModel() {
            ModelLoader.setCustomModelResourceLocation((Item)BackpackItems.tanned_leather, (int)0, (ModelResourceLocation)this.getResource(""));
        }

        @Override
        public String getConfigComment() {
            return "Enable tanned leather recipe";
        }
    }
    ,
    BACKPACK_FRAME{

        @Override
        void addItems(IForgeRegistry<Item> registry) {
            registry.register((IForgeRegistryEntry)new ItemFunctionless("backpack_frame", 1, true));
        }

        @Override
        void addModel() {
            for (Map.Entry<Integer, String> variant : EFrame.getVariants().entrySet()) {
                ModelLoader.setCustomModelResourceLocation((Item)BackpackItems.backpack_frame, (int)variant.getKey(), (ModelResourceLocation)this.getResource(variant.getValue()));
            }
        }

        @Override
        public String getConfigComment() {
            return "Enables all frame recipes";
        }
    }
    ,
    BACKPACK_FRAME_WOOD{

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "backpack_frame_wood1", EItemStack.FRAME_WOOD.getItemStack(1), new Object[]{"WSW", "S S", "WSW", Character.valueOf('W'), Items.field_151055_y, Character.valueOf('S'), Items.field_151007_F});
            Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "backpack_frame_wood2", EItemStack.FRAME_WOOD.getItemStack(1), new Object[]{"SWS", "W W", "SWS", Character.valueOf('W'), Items.field_151055_y, Character.valueOf('S'), Items.field_151007_F});
        }

        @Override
        public String getConfigComment() {
            return "Enable wooden frame recipe";
        }
    }
    ,
    BACKPACK_FRAME_STONE(STICK_STONE){

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "backpack_frame_stone1", EItemStack.FRAME_STONE.getItemStack(1), new Object[]{"WSW", "S S", "WSW", Character.valueOf('W'), "stickStone", Character.valueOf('S'), Items.field_151007_F});
            Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "backpack_frame_stone2", EItemStack.FRAME_STONE.getItemStack(1), new Object[]{"SWS", "W W", "SWS", Character.valueOf('W'), "stickStone", Character.valueOf('S'), Items.field_151007_F});
        }

        @Override
        public String getConfigComment() {
            return "Enable stone frame recipe";
        }
    }
    ,
    BACKPACK_FRAME_IRON(STICK_IRON){

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "backpack_frame_iron1", EItemStack.FRAME_IRON.getItemStack(1), new Object[]{"WSW", "S S", "WSW", Character.valueOf('W'), "stickIron", Character.valueOf('S'), Items.field_151007_F});
            Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "backpack_frame_iron2", EItemStack.FRAME_IRON.getItemStack(1), new Object[]{"SWS", "W W", "SWS", Character.valueOf('W'), "stickIron", Character.valueOf('S'), Items.field_151007_F});
        }

        @Override
        public String getConfigComment() {
            return "Enable iron frame recipe";
        }
    }
    ,
    BACKPACK_PIECE(BACKPACK_FRAME){

        @Override
        void addItems(IForgeRegistry<Item> registry) {
            registry.register((IForgeRegistryEntry)new ItemFunctionless("backpack_piece", 1, true));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.addRecipe((IForgeRegistry<IRecipe>)registry, "backpack_piece_top", new RecipeBackpackPieceTop(EItemStack.BACKPACK_PICE_TOP.getItemStack(1)));
            Features.addRecipe((IForgeRegistry<IRecipe>)registry, "backpack_piece_middle", new RecipeBackpackPieceMiddle(EItemStack.BACKPACK_PICE_MIDDLE.getItemStack(1)));
            Features.addRecipe((IForgeRegistry<IRecipe>)registry, "backpack_piece_bottom", new RecipeBackpackPieceBottom(EItemStack.BACKPACK_PICE_BOTTOM.getItemStack(1)));
        }

        @Override
        void addModel() {
            for (Map.Entry<Integer, String> variant : EPiece.getVariants().entrySet()) {
                ModelLoader.setCustomModelResourceLocation((Item)BackpackItems.backpack_piece, (int)variant.getKey(), (ModelResourceLocation)this.getResource(variant.getValue()));
            }
        }

        @Override
        public String getConfigComment() {
            return "Enable backpack piece recipes";
        }
    }
    ,
    BACKPACK(BACKPACK_PIECE){

        @Override
        void addItems(IForgeRegistry<Item> registry) {
            registry.register((IForgeRegistryEntry)new ItemBackpack());
        }

        @Override
        void addModel() {
            for (Map.Entry<Integer, String> variant : EBackpack.getVariants().entrySet()) {
                ModelLoader.setCustomModelResourceLocation((Item)BackpackItems.backpack, (int)variant.getKey(), (ModelResourceLocation)this.getResource(variant.getValue()));
            }
        }

        @Override
        public String getConfigComment() {
            return "Enable backpack recipes";
        }
    }
    ,
    BACKPACK_SMALL(BACKPACK){

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.addRecipe((IForgeRegistry<IRecipe>)registry, "backpack_small", new RecipeBackpackSmall(EBackpack.SMALL.getItemStack()));
        }

        @Override
        public String getConfigComment() {
            return "Enable small backpack recipe";
        }
    }
    ,
    BACKPACK_MEDIUM(BACKPACK){

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.addRecipe((IForgeRegistry<IRecipe>)registry, "backpack_medium", new RecipeBackpackMedium(EBackpack.MEDIUM.getItemStack()));
        }

        @Override
        public String getConfigComment() {
            return "Enable medium backpack recipe";
        }
    }
    ,
    BACKPACK_BIG(BACKPACK){

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.addRecipe((IForgeRegistry<IRecipe>)registry, "backpack_big", new RecipeBackpackBig(EBackpack.BIG.getItemStack()));
        }

        @Override
        public String getConfigComment() {
            return "Enable big backpack recipe";
        }
    }
    ,
    RECOLOR_BACKPACKS(BACKPACK){

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.addRecipe((IForgeRegistry<IRecipe>)registry, "recolor_backpack", new RecipeRecolorBackpack());
        }

        @Override
        public String getConfigComment() {
            return "Enables colored backpack recipes";
        }
    };

    private static final ResourceLocation RECIPE_GROUP;
    private static Item stick;
    private Features parent;

    @SubscribeEvent
    public static void loadItems(RegistryEvent.Register<Item> event) {
        Backpack.logger.info("Loading items...");
        int num = 0;
        for (Features feature : Features.values()) {
            feature.addItems((IForgeRegistry<Item>)event.getRegistry());
            ++num;
            if (feature.isEnabled()) {
                feature.addOreDict();
                continue;
            }
            Features.logDisabled(feature);
        }
        Backpack.logger.info(num + " item features loaded.");
    }

    @SubscribeEvent
    public static void loadRecipes(RegistryEvent.Register<IRecipe> event) {
        Backpack.logger.info("Loading recipes...");
        int num = 0;
        for (Features feature : Features.values()) {
            if (feature.isEnabled()) {
                feature.addRecipes((IForgeRegistry<IRecipe>)event.getRegistry());
                ++num;
                continue;
            }
            Features.logDisabled(feature);
        }
        Backpack.logger.info(num + " recipe features loaded.");
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        Backpack.logger.info("Registering models...");
        int num = 0;
        for (Features feature : Features.values()) {
            feature.addModel();
            ++num;
        }
        Backpack.logger.info(num + " model features loaded.");
    }

    private Features() {
        this((Features)null);
    }

    private Features(Features parent) {
        this.parent = parent;
    }

    void addItems(IForgeRegistry<Item> registry) {
    }

    void addOreDict() {
    }

    void addRecipes(IForgeRegistry<IRecipe> registry) {
    }

    void addModel() {
    }

    public boolean isEnabled() {
        return Configurations.featureEnabled(this) && this.hasParentFeature();
    }

    public String getConfigComment() {
        return "";
    }

    private boolean hasParentFeature() {
        return this.parent == null || this.parent.isEnabled();
    }

    private static void addShapedRecipe(IForgeRegistry<IRecipe> registry, String name, @Nonnull ItemStack result, Object ... ingredients) {
        registry.register(new ShapedOreRecipe(RECIPE_GROUP, result, ingredients).setRegistryName("backpack", name));
    }

    private static void addRecipe(IForgeRegistry<IRecipe> registry, String name, AbstractRecipe recipe) {
        registry.register(recipe.setRegistryName("backpack", name));
    }

    private static void logDisabled(Features feature) {
        if (!feature.hasParentFeature() && feature.parent != null) {
            Backpack.logger.info("Skipping feature {} as its parent feature {} was disabled.", (Object)Configurations.featureName(feature), (Object)Configurations.featureName(feature.parent));
        } else {
            Backpack.logger.info("Skipping feature {} as it was disabled in the config.", (Object)Configurations.featureName(feature));
        }
    }

    protected ModelResourceLocation getResource(String name) {
        String identifier = "backpack:" + this.name().toLowerCase();
        if (name.length() > 0) {
            identifier = identifier + '_' + name;
        }
        return new ModelResourceLocation(identifier, "inventory");
    }

    static {
        RECIPE_GROUP = new ResourceLocation("", "");
    }
}

