/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.item;

import de.eydamos.backpack.Features;
import java.util.Hashtable;

public enum EStick {
    STONE(0, "stone", Features.STICK_STONE),
    IRON(1, "iron", Features.STICK_IRON);

    private static Hashtable<Integer, String> VARIANTS;
    private final int damage;
    private final String identifier;
    private final Features feature;

    private EStick(int damage, String identifier, Features feature) {
        this.damage = damage;
        this.identifier = identifier;
        this.feature = feature;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getDamage() {
        return this.damage;
    }

    public boolean isEnabled() {
        return this.feature.isEnabled();
    }

    public static String getIdentifierByDamage(int damage) {
        for (EStick stick : EStick.values()) {
            if (stick.getDamage() != damage) continue;
            return stick.identifier;
        }
        return "";
    }

    public static Hashtable<Integer, String> getVariants() {
        return VARIANTS;
    }

    static {
        VARIANTS = new Hashtable();
        for (EStick stick : EStick.values()) {
            VARIANTS.put(stick.getDamage(), stick.getIdentifier());
        }
    }
}

