/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.network;

import de.eydamos.backpack.helper.BackpackHelper;
import de.eydamos.backpack.network.message.MessageBackpackData;
import de.eydamos.backpack.network.message.MessageOpenGui;
import de.eydamos.backpack.network.message.MessageRenameBackpack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketHandlerBackpack {
    private final SimpleNetworkWrapper networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("backpack");
    private IMessage message;

    public void initialise() {
        this.networkWrapper.registerMessage(MessageRenameBackpack.class, MessageRenameBackpack.class, 0, Side.SERVER);
        this.networkWrapper.registerMessage(MessageOpenGui.class, MessageOpenGui.class, 1, Side.SERVER);
        this.networkWrapper.registerMessage(MessageBackpackData.class, MessageBackpackData.class, 10, Side.CLIENT);
    }

    @SideOnly(value=Side.CLIENT)
    public void renameBackpack(String name) {
        this.message = new MessageRenameBackpack(name);
        this.networkWrapper.sendToServer(this.message);
        ((MessageRenameBackpack)this.message).setName((EntityPlayer)Minecraft.func_71410_x().field_71439_g, name);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendOpenGui(byte gui) {
        this.message = new MessageOpenGui(gui);
        this.networkWrapper.sendToServer(this.message);
    }

    public void propagateCarriedBackpack(EntityPlayer player) {
        this.message = new MessageBackpackData(player, BackpackHelper.getBackpackFromPlayer(player, false));
        this.networkWrapper.sendToAll(this.message);
    }

    @SideOnly(value=Side.SERVER)
    public void sendCarriedBackpacks(EntityPlayerMP targetPlayer, List<EntityPlayerMP> players) {
        for (EntityPlayer entityPlayer : players) {
            if (entityPlayer.equals((Object)targetPlayer)) continue;
            this.message = new MessageBackpackData(entityPlayer, BackpackHelper.getBackpackFromPlayer(entityPlayer, false));
            this.networkWrapper.sendTo(this.message, targetPlayer);
        }
    }
}

