/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.recipe;

import de.eydamos.backpack.recipe.ECategory;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class AbstractRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    protected final int recipeWidth;
    protected final int recipeHeight;
    protected int colOffset = 0;
    protected int rowOffset = 0;
    protected ItemStack[] recipeItems;
    private final ItemStack recipeOutput;
    private final ECategory type;

    public AbstractRecipe(int width, int height, ItemStack output) {
        this(width, height, output, ECategory.SHAPED);
    }

    public AbstractRecipe(int width, int height, ItemStack output, ECategory type) {
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.recipeOutput = output;
        this.type = type;
        if (type == ECategory.CUSTOM || type == ECategory.FURNACE) {
            throw new IllegalArgumentException("Only shaped and shapeless types are allowed");
        }
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }

    @MethodsReturnNonnullByDefault
    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    @MethodsReturnNonnullByDefault
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting craftingGridInventory) {
        NonNullList remainingItems = NonNullList.func_191196_a();
        for (int i = 0; i < craftingGridInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = craftingGridInventory.func_70301_a(i);
            remainingItems.add(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return remainingItems;
    }

    @ParametersAreNonnullByDefault
    public boolean func_77569_a(InventoryCrafting craftingGridInventory, World world) {
        if (this.type == ECategory.SHAPED || this.type == ECategory.SHAPED_OREDICT) {
            this.colOffset = 0;
            while (this.colOffset <= craftingGridInventory.func_174922_i() - this.recipeWidth) {
                this.rowOffset = 0;
                while (this.rowOffset <= craftingGridInventory.func_174923_h() - this.recipeHeight) {
                    if (this.checkMatch(craftingGridInventory)) {
                        return true;
                    }
                    ++this.rowOffset;
                }
                ++this.colOffset;
            }
        }
        if (this.type == ECategory.SHAPELESS || this.type == ECategory.SHAPELESS_OREDICT) {
            boolean breakLoop = false;
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    if (this.checkItemAtPosition(craftingGridInventory, col, row, 0, 0)) continue;
                    breakLoop = true;
                    break;
                }
                if (breakLoop) break;
            }
            return this.allRecipeItemsFulfilled();
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting craftingGridInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int expectedCol = col - this.colOffset;
                int expectedRow = row - this.rowOffset;
                ItemStack itemStack = craftingGridInventory.func_70463_b(col, row);
                if (expectedCol < 0 || expectedCol >= this.recipeWidth || expectedRow < 0 || expectedRow >= this.recipeHeight) {
                    if (itemStack.func_190926_b()) continue;
                    return false;
                }
                if (this.checkItemAtPosition(craftingGridInventory, col, row, expectedCol, expectedRow)) continue;
                return false;
            }
        }
        return true;
    }

    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }

    protected abstract boolean checkItemAtPosition(InventoryCrafting var1, int var2, int var3, int var4, int var5);

    protected boolean allRecipeItemsFulfilled() {
        return true;
    }
}

