/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.tier;

import com.mojang.realmsclient.gui.ChatFormatting;
import de.eydamos.backpack.init.BackpackItems;
import de.eydamos.backpack.util.NBTItemStackUtil;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum TierLeather {
    I(Items.field_179555_bs, 6, 3),
    II(Items.field_151116_aA, 12, 6),
    III(BackpackItems.tanned_leather, 18, 9);

    private final Item item;
    private final int baseSlots;
    private final int upgradeSlots;

    private TierLeather(Item item, int baseSlots, int upgradeSlots) {
        this.item = item;
        this.baseSlots = baseSlots;
        this.upgradeSlots = upgradeSlots;
    }

    public Item getItem() {
        return this.item;
    }

    public int getBaseSlots() {
        return this.baseSlots;
    }

    public int getUpgradeSlots() {
        return this.upgradeSlots;
    }

    public void setTier(ItemStack itemStack) {
        NBTItemStackUtil.setString(itemStack, "leather_tier", this.name());
    }

    public static TierLeather getTierByItemStack(ItemStack itemStack) {
        String tierName = NBTItemStackUtil.getString(itemStack, "leather_tier");
        if (!tierName.isEmpty()) {
            return TierLeather.valueOf(tierName);
        }
        Item item = itemStack.func_77973_b();
        for (TierLeather tier : TierLeather.values()) {
            if (tier.item != item) continue;
            return tier;
        }
        return null;
    }

    public static void setTier(ItemStack target, ItemStack source) {
        TierLeather tier = TierLeather.getTierByItemStack(source);
        if (tier != null) {
            tier.setTier(target);
        }
    }

    public static boolean itemStackTierEquals(ItemStack itemStackA, ItemStack itemStackB) {
        TierLeather tierA = TierLeather.getTierByItemStack(itemStackA);
        TierLeather tierB = TierLeather.getTierByItemStack(itemStackB);
        return tierA != null && tierA.equals((Object)tierB);
    }

    public static void addTooltip(ItemStack itemStack, List<String> tooltip) {
        TierLeather tier = TierLeather.getTierByItemStack(itemStack);
        if (tier != null) {
            String label = ChatFormatting.BLUE + I18n.func_135052_a((String)"tooltip.tier_leather", (Object[])new Object[0]);
            String tierName = ChatFormatting.YELLOW + tier.name() + ChatFormatting.RESET;
            tooltip.add(label.trim() + ' ' + tierName);
        }
    }
}

