/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.ability;

import java.util.ArrayList;
import me.ichun.mods.morph.api.ability.AbilityApi;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Ability
implements Comparable<Ability> {
    private transient EntityLivingBase parent = null;
    protected transient ResourceLocation iconResource = null;
    public transient float strength = 1.0f;
    public String type = "unknown";
    public Boolean activeType;
    public Float activeCost;
    public Boolean notCharacteristic;

    public Ability parse(String[] args) {
        return this;
    }

    public Ability setNotCharacteristic() {
        this.notCharacteristic = true;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Ability clone() {
        Ability ability = (Ability)AbilityApi.GSON.fromJson(AbilityApi.GSON.toJson((Object)this), this.getClass());
        return ability;
    }

    public void setParent(EntityLivingBase ent) {
        this.parent = ent;
    }

    public EntityLivingBase getParent() {
        return this.parent;
    }

    public void tick() {
    }

    public void init() {
    }

    public void kill(ArrayList<Ability> nextAbilities) {
    }

    public float getStrength() {
        return this.strength;
    }

    public boolean entityHasAbility(EntityLivingBase living) {
        return true;
    }

    public boolean isActiveType() {
        return this.activeType != null && this.activeType != false;
    }

    public float activeCost() {
        return this.activeCost != null ? this.activeCost.floatValue() : 0.0f;
    }

    public boolean isCharacteristic(EntityLivingBase living) {
        return this.notCharacteristic == null || this.notCharacteristic == false;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getIcon() {
        return this.iconResource;
    }

    @SideOnly(value=Side.CLIENT)
    public void postRender() {
    }

    @Override
    public int compareTo(Ability ability) {
        return this.getType().compareTo(ability.getType());
    }
}

