/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.ability.type;

import java.util.ArrayList;
import java.util.List;
import me.ichun.mods.morph.api.ability.Ability;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class AbilityFear
extends Ability {
    public static final ResourceLocation iconResource = new ResourceLocation("morph", "textures/icon/fear.png");
    public ArrayList<Class<?>> classList = new ArrayList();
    public int radius;
    public double runSpeed;

    public AbilityFear() {
    }

    public AbilityFear(int radius, double speed, Class<?> ... entityClass) {
        this.radius = radius;
        this.runSpeed = speed;
        for (Class<?> clazz : entityClass) {
            if (!EntityCreature.class.isAssignableFrom(clazz)) continue;
            this.classList.add(clazz);
        }
    }

    @Override
    public String getType() {
        return "fear";
    }

    @Override
    public Ability parse(String[] args) {
        this.radius = Integer.parseInt(args[0]);
        this.runSpeed = Double.parseDouble(args[1]);
        for (int i = 2; i < args.length; ++i) {
            try {
                Class<?> clz = Class.forName(args[i]);
                if (!EntityCreature.class.isAssignableFrom(clz)) continue;
                this.classList.add(clz);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public void tick() {
        if (this.getParent().func_130014_f_().func_82737_E() % 22L == 0L) {
            List entityList = this.getParent().func_130014_f_().func_72839_b((Entity)this.getParent(), this.getParent().func_174813_aQ().func_72314_b((double)this.radius, (double)this.radius, (double)this.radius));
            if (entityList.isEmpty()) {
                return;
            }
            for (Entity entity : entityList) {
                if (!(entity instanceof EntityCreature)) continue;
                EntityCreature creature = (EntityCreature)entity;
                for (Class<?> clz : this.classList) {
                    if (!clz.isInstance(creature)) continue;
                    boolean canRun = false;
                    Vec3d vec3 = RandomPositionGenerator.func_75461_b((EntityCreature)creature, (int)16, (int)7, (Vec3d)new Vec3d(this.getParent().field_70165_t, this.getParent().field_70163_u, this.getParent().field_70161_v));
                    if (vec3 != null && !(this.getParent().func_70092_e(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c) < this.getParent().func_70068_e((Entity)creature))) {
                        Path newPath = new Path(new PathPoint[]{new PathPoint((int)vec3.field_72450_a, (int)vec3.field_72448_b, (int)vec3.field_72449_c)});
                        creature.func_70661_as().func_75484_a(newPath, 1.0);
                        canRun = true;
                    }
                    if (!canRun) continue;
                    creature.func_70661_as().func_75489_a(this.runSpeed);
                }
            }
        }
    }

    @Override
    public Ability clone() {
        if (this.classList.isEmpty()) {
            return new AbilityFear();
        }
        Class[] classArray = new Class[this.classList.size()];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = this.classList.get(i);
        }
        return new AbilityFear(this.radius, this.runSpeed, classArray);
    }

    @Override
    public ResourceLocation getIcon() {
        return iconResource;
    }
}

