/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.model;

import com.google.common.collect.Lists;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.ichun.mods.ichunutil.client.model.util.ModelHelper;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.core.util.ObfHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.morph.client.model.ModelInfo;
import me.ichun.mods.morph.common.handler.PlayerMorphHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityRabbit;

public class ModelMorph
extends ModelBase {
    public static final long RAND_SEED = "MorphModelRandSeed".hashCode();
    public static final Random RAND = new Random(RAND_SEED);
    public final ModelInfo prevModelInfo;
    public final ModelInfo nextModelInfo;
    public final ArrayList<ModelRenderer> modelList;
    public final HashMap<ModelRenderer, ModelRenderer> prevCloneToOriMap;
    public final HashMap<ModelRenderer, ModelRenderer> nextCloneToOriMap;
    public final ArrayList<ModelRenderer> prevModels;
    public final ArrayList<ModelRenderer> nextModels;

    public ModelMorph() {
        this(null, null, null, null);
    }

    public ModelMorph(ModelInfo prev, ModelInfo next, Entity oldRef, Entity newRef) {
        int i;
        this.prevModelInfo = prev;
        this.nextModelInfo = next;
        this.prevCloneToOriMap = new HashMap();
        this.nextCloneToOriMap = new HashMap();
        if (prev != null) {
            this.prevModels = ModelHelper.getModelCubesCopy(prev.modelList, (ModelBase)this, (Entity)oldRef);
            i = -1;
            for (ModelRenderer model : this.prevModels) {
                while (!prev.modelList.get((int)(++i)).field_78812_q) {
                }
                this.prevCloneToOriMap.put(model, prev.modelList.get(i));
            }
        } else {
            this.prevModels = new ArrayList();
        }
        if (next != null) {
            this.nextModels = ModelHelper.getModelCubesCopy(next.modelList, (ModelBase)this, (Entity)newRef);
            i = -1;
            for (ModelRenderer model : this.nextModels) {
                while (!next.modelList.get((int)(++i)).field_78812_q) {
                }
                this.nextCloneToOriMap.put(model, next.modelList.get(i));
            }
        } else {
            this.nextModels = new ArrayList();
        }
        this.prepareReferences();
        this.modelList = ModelHelper.getModelCubesCopy(this.prevModels, (ModelBase)this, null);
    }

    public void prepareReferences() {
        ModelRenderer anchor;
        ModelRenderer renderer;
        int i;
        int prevAdjust = -1;
        while (this.prevModels.size() < this.nextModels.size()) {
            if (prevAdjust == -1) {
                prevAdjust = this.prevModels.size();
            }
            this.prevModels.add(ModelHelper.buildCopy((ModelRenderer)this.nextModels.get(this.prevModels.size()), (ModelBase)this, (int)0, (boolean)false, (boolean)true));
        }
        int nextAdjust = -1;
        while (this.nextModels.size() < this.prevModels.size()) {
            if (nextAdjust == -1) {
                nextAdjust = this.nextModels.size();
            }
            this.nextModels.add(ModelHelper.buildCopy((ModelRenderer)this.prevModels.get(this.nextModels.size()), (ModelBase)this, (int)0, (boolean)false, (boolean)true));
        }
        RAND.setSeed(RAND_SEED);
        if (prevAdjust > 0) {
            for (i = prevAdjust; i < this.prevModels.size(); ++i) {
                renderer = this.prevModels.get(i);
                anchor = this.prevModels.get(RAND.nextInt(prevAdjust));
                renderer.func_78793_a(anchor.field_78800_c, anchor.field_78797_d, anchor.field_78798_e);
            }
        }
        if (nextAdjust > 0) {
            for (i = nextAdjust; i < this.nextModels.size(); ++i) {
                renderer = this.nextModels.get(i);
                anchor = this.nextModels.get(RAND.nextInt(nextAdjust));
                renderer.func_78793_a(anchor.field_78800_c, anchor.field_78797_d, anchor.field_78798_e);
            }
        }
        this.fillWithChildren(this.prevModels, this.nextModels, 0);
    }

    public void render(float renderTick, float progress, EntityLivingBase prevRef, EntityLivingBase nextRef) {
        GlStateManager.func_179094_E();
        FloatBuffer buffer = GLAllocation.func_74529_h((int)16);
        FloatBuffer buffer1 = GLAllocation.func_74529_h((int)16);
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        float scaleZ = 1.0f;
        if (prevRef != null && nextRef != null) {
            float prevScaleX = 1.0f;
            float prevScaleY = 1.0f;
            float prevScaleZ = 1.0f;
            Render rend = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)prevRef);
            if (rend instanceof RenderLivingBase) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179111_a((int)2982, (FloatBuffer)buffer);
                ObfHelper.invokePreRenderCallback((RenderLivingBase)((RenderLivingBase)rend), rend.getClass(), (EntityLivingBase)prevRef, (float)iChunUtil.eventHandlerClient.renderTick);
                GlStateManager.func_179111_a((int)2982, (FloatBuffer)buffer1);
                GlStateManager.func_179121_F();
                prevScaleX = buffer1.get(0) / buffer.get(0);
                prevScaleY = buffer1.get(5) / buffer.get(5);
                prevScaleZ = buffer1.get(8) / buffer.get(8);
            }
            if (prevRef instanceof EntityRabbit) {
                prevScaleX *= 0.6f;
                prevScaleY *= 0.6f;
                prevScaleZ *= 0.6f;
            }
            float nextScaleX = 1.0f;
            float nextScaleY = 1.0f;
            float nextScaleZ = 1.0f;
            rend = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)nextRef);
            if (rend instanceof RenderLivingBase) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179111_a((int)2982, (FloatBuffer)buffer);
                ObfHelper.invokePreRenderCallback((RenderLivingBase)((RenderLivingBase)rend), rend.getClass(), (EntityLivingBase)nextRef, (float)iChunUtil.eventHandlerClient.renderTick);
                GlStateManager.func_179111_a((int)2982, (FloatBuffer)buffer1);
                GlStateManager.func_179121_F();
                nextScaleX = buffer1.get(0) / buffer.get(0);
                nextScaleY = buffer1.get(5) / buffer.get(5);
                nextScaleZ = buffer1.get(8) / buffer.get(8);
            }
            if (nextRef instanceof EntityRabbit) {
                nextScaleX *= 0.6f;
                nextScaleY *= 0.6f;
                nextScaleZ *= 0.6f;
            }
            scaleX = prevScaleX + (nextScaleX - prevScaleX) * progress;
            scaleY = prevScaleY + (nextScaleY - prevScaleY) * progress;
            scaleZ = prevScaleZ + (nextScaleZ - prevScaleZ) * progress;
            if (this.prevModelInfo != null) {
                this.prevModelInfo.forceRender((Entity)prevRef, 0.0, -500.0, 0.0, EntityHelper.interpolateRotation((float)prevRef.field_70126_B, (float)prevRef.field_70177_z, (float)renderTick), renderTick);
                for (Map.Entry<ModelRenderer, ModelRenderer> e : this.prevCloneToOriMap.entrySet()) {
                    this.matchRotation(e.getKey(), e.getValue(), 0);
                }
            }
            if (this.nextModelInfo != null) {
                this.nextModelInfo.forceRender((Entity)nextRef, 0.0, -500.0, 0.0, EntityHelper.interpolateRotation((float)nextRef.field_70126_B, (float)nextRef.field_70177_z, (float)renderTick), renderTick);
                for (Map.Entry<ModelRenderer, ModelRenderer> e : this.nextCloneToOriMap.entrySet()) {
                    this.matchRotation(e.getKey(), e.getValue(), 0);
                }
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerMorphHandler.getInstance().getMorphSkinTexture());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)scaleX, (float)scaleY, (float)scaleZ);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.5f, (float)0.0f);
        this.updateModelList(progress, this.modelList, this.prevModels, this.nextModels, 0);
        for (ModelRenderer cube : this.modelList) {
            cube.func_78785_a(0.0625f);
        }
        GlStateManager.func_179121_F();
    }

    public void matchRotation(ModelRenderer clone, ModelRenderer ori, int depth) {
        if (depth > 20) {
            return;
        }
        clone.func_78793_a(ori.field_78800_c, ori.field_78797_d, ori.field_78798_e);
        clone.field_78795_f = ori.field_78795_f;
        clone.field_78796_g = ori.field_78796_g;
        clone.field_78808_h = ori.field_78808_h;
        if (ori.field_78805_m != null) {
            for (int i = 0; i < ori.field_78805_m.size(); ++i) {
                ModelRenderer cloneChild = (ModelRenderer)clone.field_78805_m.get(i);
                ModelRenderer child = (ModelRenderer)ori.field_78805_m.get(i);
                this.matchRotation(cloneChild, child, depth + 1);
            }
        }
    }

    public void updateModelList(float progress, List modelList, List prevModelList, List nextModelList, int depth) {
        if (modelList == null || depth > 20) {
            return;
        }
        for (int i = 0; i < modelList.size(); ++i) {
            ModelRenderer renderer = (ModelRenderer)modelList.get(i);
            ModelRenderer prevRend = (ModelRenderer)prevModelList.get(i);
            ModelRenderer nextRend = (ModelRenderer)nextModelList.get(i);
            for (int j = renderer.field_78804_l.size() - 1; j >= 0; --j) {
                ModelBox box = (ModelBox)renderer.field_78804_l.get(j);
                ModelBox prevBox = (ModelBox)prevRend.field_78804_l.get(j);
                ModelBox nextBox = (ModelBox)nextRend.field_78804_l.get(j);
                int x = (int)Math.abs(box.field_78248_d - box.field_78252_a);
                int y = (int)Math.abs(box.field_78249_e - box.field_78250_b);
                int z = (int)Math.abs(box.field_78246_f - box.field_78251_c);
                int px = (int)Math.abs(prevBox.field_78248_d - prevBox.field_78252_a);
                int py = (int)Math.abs(prevBox.field_78249_e - prevBox.field_78250_b);
                int pz = (int)Math.abs(prevBox.field_78246_f - prevBox.field_78251_c);
                int nx = (int)Math.abs(nextBox.field_78248_d - nextBox.field_78252_a);
                int ny = (int)Math.abs(nextBox.field_78249_e - nextBox.field_78250_b);
                int nz = (int)Math.abs(nextBox.field_78246_f - nextBox.field_78251_c);
                int xx = Math.round((float)px + (float)(nx - px) * progress);
                int yy = Math.round((float)py + (float)(ny - py) * progress);
                int zz = Math.round((float)pz + (float)(nz - pz) * progress);
                float offsetX = EntityHelper.interpolateValues((float)prevBox.field_78252_a, (float)nextBox.field_78252_a, (float)progress);
                float offsetY = EntityHelper.interpolateValues((float)prevBox.field_78250_b, (float)nextBox.field_78250_b, (float)progress);
                float offsetZ = EntityHelper.interpolateValues((float)prevBox.field_78251_c, (float)nextBox.field_78251_c, (float)progress);
                if (x == xx && y == yy && z == zz && offsetX == box.field_78252_a && offsetY == box.field_78250_b && offsetZ == box.field_78251_c) continue;
                if (renderer.field_78812_q) {
                    GLAllocation.func_74523_b((int)renderer.field_78811_r);
                    renderer.field_78812_q = false;
                }
                renderer.field_78804_l.remove(j);
                renderer.field_78804_l.add(j, new ModelBox(renderer, renderer.field_78803_o, renderer.field_78813_p, offsetX, offsetY, offsetZ, xx, yy, zz, 0.0625f));
            }
            renderer.func_78793_a(EntityHelper.interpolateValues((float)prevRend.field_78800_c, (float)nextRend.field_78800_c, (float)progress), EntityHelper.interpolateValues((float)prevRend.field_78797_d, (float)nextRend.field_78797_d, (float)progress), EntityHelper.interpolateValues((float)prevRend.field_78798_e, (float)nextRend.field_78798_e, (float)progress));
            renderer.field_78795_f = EntityHelper.interpolateValues((float)prevRend.field_78795_f, (float)nextRend.field_78795_f, (float)progress);
            renderer.field_78796_g = EntityHelper.interpolateValues((float)prevRend.field_78796_g, (float)nextRend.field_78796_g, (float)progress);
            renderer.field_78808_h = EntityHelper.interpolateValues((float)prevRend.field_78808_h, (float)nextRend.field_78808_h, (float)progress);
            this.updateModelList(progress, renderer.field_78805_m, prevRend.field_78805_m, nextRend.field_78805_m, depth + 1);
        }
    }

    public void fillWithChildren(List prevModels, List nextModels, int depth) {
        if (prevModels == null || nextModels == null || depth > 20) {
            return;
        }
        for (int i = 0; i < (prevModels.size() < nextModels.size() ? prevModels.size() : nextModels.size()); ++i) {
            int k;
            ModelRenderer prevModel = (ModelRenderer)prevModels.get(i);
            ModelRenderer nextModel = (ModelRenderer)nextModels.get(i);
            while (prevModel.field_78804_l.size() < nextModel.field_78804_l.size()) {
                prevModel.func_78790_a(0.0f, 0.0f, 0.0f, 0, 0, 0, 0.0625f);
            }
            while (nextModel.field_78804_l.size() < prevModel.field_78804_l.size()) {
                nextModel.func_78790_a(0.0f, 0.0f, 0.0f, 0, 0, 0, 0.0625f);
            }
            if (prevModel.field_78805_m == null && nextModel.field_78805_m == null) continue;
            ModelRenderer prevEmptyCopy = ModelHelper.buildCopy((ModelRenderer)prevModel, (ModelBase)this, (int)0, (boolean)true, (boolean)true);
            ModelRenderer nextEmptyCopy = ModelHelper.buildCopy((ModelRenderer)nextModel, (ModelBase)this, (int)0, (boolean)true, (boolean)true);
            if (prevModel.field_78805_m == null) {
                prevModel.field_78805_m = Lists.newArrayList();
                prevEmptyCopy.field_78805_m = Lists.newArrayList();
            }
            if (nextModel.field_78805_m == null) {
                nextModel.field_78805_m = Lists.newArrayList();
                nextEmptyCopy.field_78805_m = Lists.newArrayList();
            }
            for (k = prevModel.field_78805_m.size(); k < nextEmptyCopy.field_78805_m.size(); ++k) {
                prevModel.func_78792_a((ModelRenderer)nextEmptyCopy.field_78805_m.get(k));
            }
            for (k = nextModel.field_78805_m.size(); k < prevEmptyCopy.field_78805_m.size(); ++k) {
                nextModel.func_78792_a((ModelRenderer)prevEmptyCopy.field_78805_m.get(k));
            }
            this.fillWithChildren(prevModel.field_78805_m, nextModel.field_78805_m, depth + 1);
        }
    }

    public void setRotationPointToZeroWithChildren(List<ModelRenderer> children, int depth) {
        if (children == null || depth > 20) {
            return;
        }
        for (ModelRenderer child : children) {
            child.func_78793_a(0.0f, 0.0f, 0.0f);
            this.setRotationPointToZeroWithChildren(child.field_78805_m, depth + 1);
        }
    }

    public void clean() {
        this.modelList.stream().filter(renderer -> renderer.field_78812_q).forEach(renderer -> {
            GLAllocation.func_74523_b((int)renderer.field_78811_r);
            renderer.field_78812_q = false;
        });
    }
}

