/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.core;

import java.io.File;
import java.lang.reflect.Field;
import me.ichun.mods.ichunutil.client.keybind.KeyBind;
import me.ichun.mods.ichunutil.common.core.config.ConfigBase;
import me.ichun.mods.ichunutil.common.core.config.annotations.ConfigProp;
import me.ichun.mods.ichunutil.common.core.config.annotations.IntBool;
import me.ichun.mods.ichunutil.common.core.config.annotations.IntMinMax;
import me.ichun.mods.morph.common.handler.PlayerMorphHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;

public class Config
extends ConfigBase {
    @ConfigProp(category="gameplay")
    @IntBool
    public int childMorphs = 0;
    @ConfigProp(category="gameplay")
    @IntBool
    public int playerMorphs = 1;
    @ConfigProp(category="gameplay")
    @IntBool
    public int bossMorphs = 0;
    @ConfigProp(category="gameplay")
    @IntBool
    public int classicMode = 0;
    @ConfigProp(category="gameplay", useSession=true)
    @IntMinMax(min=30)
    public int morphTime = 80;
    @ConfigProp(category="gameplay", useSession=true)
    @IntBool
    public int canSleepMorphed = 0;
    @ConfigProp(category="gameplay", useSession=true)
    @IntBool
    public int showPlayerLabel = 0;
    @ConfigProp(category="gameplay")
    @IntMinMax(min=0, max=2)
    public int loseMorphsOnDeath = 0;
    @ConfigProp(category="gameplay")
    @IntBool
    public int instaMorph = 0;
    @ConfigProp(category="gameplay")
    @IntBool
    public int morphHealthBalancing = 1;
    @ConfigProp(category="gameplay")
    @IntMinMax(min=1, max=1000)
    public int maxMorphHealth = 20;
    @ConfigProp(category="gameplay")
    @IntBool
    public int useLocalResources = 0;
    @ConfigProp(category="gameplay")
    public String customPatchLink = "";
    @ConfigProp(category="gameplay")
    public String[] blackwhiteListedMobs = new String[0];
    @ConfigProp(category="gameplay")
    @IntBool
    public int listIsBlacklistMobs = 1;
    @ConfigProp(category="gameplay")
    public String[] blackwhiteListedPlayers = new String[0];
    @ConfigProp(category="gameplay")
    @IntBool
    public int listIsBlacklistPlayers = 1;
    @ConfigProp(category="abilities", useSession=true)
    @IntBool
    public int abilities = 1;
    @ConfigProp(category="abilities", useSession=true)
    @IntBool
    public int showAbilitiesInGui = 1;
    @ConfigProp(category="abilities", useSession=true)
    public String[] disabledAbilities = new String[0];
    @ConfigProp(category="abilities", useSession=true)
    @IntBool
    public int enableFlight = 1;
    @ConfigProp(category="abilities")
    public int hostileAbilityMode = 0;
    @ConfigProp(category="abilities")
    public int hostileAbilityDistanceCheck = 6;
    @ConfigProp(category="clientOnly", side=Side.CLIENT)
    @IntBool
    public int handRenderOverride = 1;
    @ConfigProp(category="clientOnly", side=Side.CLIENT)
    @IntBool
    public int disableMorphAcquisitionAnimation = 0;
    @ConfigProp(category="clientOnly", side=Side.CLIENT)
    public KeyBind keySelectorUp = new KeyBind(26);
    @ConfigProp(category="clientOnly", side=Side.CLIENT)
    public KeyBind keySelectorDown = new KeyBind(27);
    @ConfigProp(category="clientOnly", side=Side.CLIENT)
    public KeyBind keySelectorLeft = new KeyBind(26, true, false, false, false);
    @ConfigProp(category="clientOnly", side=Side.CLIENT)
    public KeyBind keySelectorRight = new KeyBind(27, true, false, false, false);
    @ConfigProp(category="clientOnly", side=Side.CLIENT)
    public KeyBind keySelectorSelect = new KeyBind(28);
    @ConfigProp(category="clientOnly", side=Side.CLIENT)
    public KeyBind keySelectorCancel = new KeyBind(1);
    @ConfigProp(category="clientOnly", side=Side.CLIENT)
    public KeyBind keySelectorRemoveMorph = new KeyBind(14);
    @ConfigProp(category="clientOnly", side=Side.CLIENT)
    public KeyBind keyFavourite = new KeyBind(41);

    public Config(File file) {
        super(file);
    }

    public String getModId() {
        return "Morph".toLowerCase();
    }

    public String getModName() {
        return "Morph";
    }

    public void onConfigChange(Field field, Object original) {
        this.readBlackWhitelists();
    }

    public void setup() {
        super.setup();
        this.readBlackWhitelists();
    }

    public void readBlackWhitelists() {
        PlayerMorphHandler.blackwhiteEntityClasses.clear();
        for (String s : this.blackwhiteListedMobs) {
            try {
                Class<?> clz = Class.forName(s);
                if (!EntityLivingBase.class.isAssignableFrom(clz) || PlayerMorphHandler.blackwhiteEntityClasses.contains(clz)) continue;
                PlayerMorphHandler.blackwhiteEntityClasses.add(clz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

