/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.statues;

import info.jbcs.minecraft.statues.EntityStatuePlayer;
import info.jbcs.minecraft.statues.ImageData;
import info.jbcs.minecraft.statues.Statues;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.init.Blocks;

public class ImageStatueBufferDownload
implements IImageBuffer {
    EntityStatuePlayer player;
    Block block;
    int blockSide;
    int blockMeta;
    private int[] imageData;
    private int imageWidth;
    private int imageHeight;
    String debugName;

    public ImageStatueBufferDownload(EntityStatuePlayer entityFakePlayer, Block b, int side, int meta, String dn) {
        this.player = entityFakePlayer;
        this.block = b;
        this.blockSide = side;
        this.blockMeta = meta;
        this.debugName = dn;
    }

    public BufferedImage func_78432_a(BufferedImage par1BufferedImage) {
        if (par1BufferedImage == null) {
            return null;
        }
        this.imageWidth = 64;
        this.imageHeight = 32;
        BufferedImage bufferedimage1 = new BufferedImage(this.imageWidth, this.imageHeight, 2);
        Graphics graphics = bufferedimage1.getGraphics();
        graphics.drawImage(par1BufferedImage, 0, 0, null);
        graphics.dispose();
        this.imageData = ((DataBufferInt)bufferedimage1.getRaster().getDataBuffer()).getData();
        this.setAreaOpaque(0, 0, 32, 16);
        this.setAreaOpaque(0, 16, 64, 32);
        if (!this.block.equals(Blocks.field_150357_h)) {
            this.blendArea(0, 0, 64, 32, this.block, this.blockSide, this.blockMeta);
        }
        if (Statues.debugImages) {
            try {
                ImageIO.write((RenderedImage)bufferedimage1, "PNG", new File(this.debugName + ".png"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bufferedimage1;
    }

    private void blendArea(int x1, int y1, int x2, int y2, Block block, int side, int meta) {
        ImageData data = ImageData.getBlockTexture(block, side, meta);
        if (data == null) {
            data = ImageData.getBlockTexture(Blocks.field_150348_b, 0, 0);
        }
        if (data == null) {
            return;
        }
        int[] stone = data.pixels;
        int w = data.w;
        int h = data.h;
        for (int x = x1; x < x2; ++x) {
            for (int y = y1; y < y2; ++y) {
                int rgba = this.imageData[x + y * this.imageWidth] & 0xFFFFFFFF;
                double a = (double)(rgba >> 24 & 0xFF) / 255.0;
                double L = 0.2125 * (double)(rgba >> 0 & 0xFF) / 255.0 + 0.7154 * (double)(rgba >> 8 & 0xFF) / 255.0 + 0.0721 * (double)(rgba >> 16 & 0xFF) / 255.0;
                if ((L *= 1.3333333333333333) > 1.0) {
                    L = 1.0;
                }
                int srgba = stone[x % w + y % h * w];
                double R = (double)(srgba >> 0 & 0xFF) / 255.0;
                double G = (double)(srgba >> 8 & 0xFF) / 255.0;
                double B = (double)(srgba >> 16 & 0xFF) / 255.0;
                double A = (double)(srgba >> 24 & 0xFF) / 255.0;
                R = R < 0.5 ? 2.0 * R * L : 1.0 - 2.0 * (1.0 - R) * (1.0 - L);
                G = G < 0.5 ? 2.0 * G * L : 1.0 - 2.0 * (1.0 - G) * (1.0 - L);
                B = B < 0.5 ? 2.0 * B * L : 1.0 - 2.0 * (1.0 - B) * (1.0 - L);
                int sr = (int)(R * 255.0);
                int sg = (int)(G * 255.0);
                int sb = (int)(B * 255.0);
                this.imageData[x + y * this.imageWidth] = sr << 0 | sg << 8 | sb << 16 | (int)(a * A * 255.0) << 24;
            }
        }
    }

    private void setAreaTransparent(int par1, int par2, int par3, int par4) {
        if (!this.hasTransparency(par1, par2, par3, par4)) {
            for (int i1 = par1; i1 < par3; ++i1) {
                for (int j1 = par2; j1 < par4; ++j1) {
                    int n = i1 + j1 * this.imageWidth;
                    this.imageData[n] = this.imageData[n] & 0xFFFFFF;
                }
            }
        }
    }

    private void setAreaOpaque(int par1, int par2, int par3, int par4) {
        for (int i1 = par1; i1 < par3; ++i1) {
            for (int j1 = par2; j1 < par4; ++j1) {
                int n = i1 + j1 * this.imageWidth;
                this.imageData[n] = this.imageData[n] | 0xFF000000;
            }
        }
    }

    private boolean hasTransparency(int par1, int par2, int par3, int par4) {
        for (int i1 = par1; i1 < par3; ++i1) {
            for (int j1 = par2; j1 < par4; ++j1) {
                int k1 = this.imageData[i1 + j1 * this.imageWidth];
                if ((k1 >> 24 & 0xFF) >= 128) continue;
                return true;
            }
        }
        return false;
    }

    public void func_152634_a() {
    }
}

