/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.statues;

import info.jbcs.minecraft.statues.GeneralStatueClient;
import info.jbcs.minecraft.statues.Statues;
import info.jbcs.minecraft.statues.TileEntityStatue;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import pl.asie.lib.network.MessageHandlerBase;
import pl.asie.lib.network.Packet;

public class Packets
extends MessageHandlerBase {
    public static final int SCULPTURE_CREATION = 1;
    public static final int SCULPTURE_ADJUSTMENT = 2;
    public static final int SCULPTED = 3;

    public void onSculptureCreation(Packet packet, EntityPlayer player) throws IOException {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        byte face = packet.readByte();
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        if (!Statues.canSculpt(block, player.field_70170_p, x, y, z)) {
            return;
        }
        int meta = player.field_70170_p.func_72805_g(x, y, z);
        if (!block.equals(player.field_70170_p.func_147439_a(x, y + 1, z)) || meta != player.field_70170_p.func_72805_g(x, y + 1, z)) {
            return;
        }
        player.field_70170_p.func_147465_d(x, y, z, Statues.statue, (int)face, 3);
        TileEntity tileEntity = player.field_70170_p.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityStatue)) {
            return;
        }
        TileEntityStatue entity = (TileEntityStatue)tileEntity;
        entity.skinName = packet.readString();
        entity.pose.read(packet);
        entity.block = block;
        entity.meta = meta;
        entity.facing = 2;
        player.field_70170_p.func_147465_d(x, y + 1, z, Statues.statue, face | 4, 3);
        player.field_70170_p.func_147459_d(x, y, z, Statues.statue);
        player.field_70170_p.func_147471_g(x, y, z);
        Packet sculpted = Statues.packet.create(3).writeInt(x).writeInt(y).writeInt(z).writeShort((short)Block.func_149682_b((Block)block)).writeByte((byte)meta);
        Statues.packet.sendToAllAround(sculpted, (Entity)player, 64.0);
    }

    public void onSculptureAdjustment(Packet packet, EntityPlayer player) throws IOException {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        float itemLeftA = packet.readFloat();
        float itemRightA = packet.readFloat();
        TileEntity tileEntity = player.field_70170_p.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityStatue)) {
            return;
        }
        TileEntityStatue entity = (TileEntityStatue)tileEntity;
        entity.pose.itemLeftA = itemLeftA;
        entity.pose.itemRightA = itemRightA;
        player.field_70170_p.func_147471_g(x, y, z);
    }

    public void onSculpted(Packet packet, EntityPlayer player) throws IOException {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        Block block = Block.func_149729_e((int)packet.readShort());
        byte meta = packet.readByte();
        GeneralStatueClient.spawnSculptEffect(x, y, z, block, meta);
        GeneralStatueClient.spawnSculptEffect(x, y + 1, z, block, meta);
    }

    public void onMessage(Packet packet, INetHandler handler, EntityPlayer player, int command) throws IOException {
        switch (command) {
            case 1: {
                this.onSculptureCreation(packet, player);
                break;
            }
            case 2: {
                this.onSculptureAdjustment(packet, player);
                break;
            }
            case 3: {
                this.onSculpted(packet, player);
            }
        }
    }
}

