/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import toast.lostBooks.BookStats;
import toast.lostBooks.FileHelper;
import toast.lostBooks.TextHelper;
import toast.lostBooks._LostBooks;

public abstract class AdLibHelper {
    public static final HashSet<String> CUSTOM_WORD_CODES = new HashSet<String>(Arrays.asList("adjective", "adverb", "exclaimation", "noun", "noun.plural", "noun.bodypart", "noun.bodypart.plural", "noun.name", "noun.living", "noun.living.plural", "noun.object", "noun.object.plural", "noun.place", "noun.place.plural", "noun.pronoun", "noun.pronoun.possessive", "verb", "verb.past", "verb.present"));
    public static final HashSet<String> SPECIAL_WORD_CODES = new HashSet<String>(Arrays.asList("random.number", "random.digit", "random.letter", "random.color", "random.color.readable", "random.format", "random.format.readable", "entity", "entity.random", "entity.nearest", "entity.nearest.other", "player.random", "player.nearest", "player.nearest.other", "creature.random", "creature.nearest", "creature.nearest.other", "monster.random", "monster.nearest", "monster.nearest.other", "animal.random", "animal.nearest", "animal.nearest.other", "world", "world.dimension"));
    public static final HashSet<String> WORD_CODES = new HashSet<String>(Arrays.asList("random", "verb.infinitive"));
    public static final HashMap<String, String[]> WORDS = new HashMap(CUSTOM_WORD_CODES.size() + 1, 1.0f);

    public static final void init() {
    }

    public static String checkCode(String wordCode) {
        if (wordCode.equals("verb.infinitive")) {
            return "verb";
        }
        return wordCode;
    }

    public static String nextWord(EntityLivingBase entity, String wordCode) {
        boolean cap = false;
        if (wordCode.startsWith("c.")) {
            cap = true;
            wordCode = wordCode.substring(2);
        }
        if (CUSTOM_WORD_CODES.contains(wordCode = AdLibHelper.checkCode(wordCode))) {
            String[] wordArray = WORDS.get(wordCode);
            if (wordArray.length > 0) {
                return AdLibHelper.cap(cap, wordArray[_LostBooks.random.nextInt(wordArray.length)]);
            }
        } else if (SPECIAL_WORD_CODES.contains(wordCode) && entity != null) {
            if (wordCode.equals("entity")) {
                return AdLibHelper.cap(cap, entity.func_70005_c_());
            }
            String[] code = wordCode.split("\\.");
            if (code[0].equals("random")) {
                if (code[1].equals("number")) {
                    return Integer.toString(_LostBooks.random.nextInt(9) + 1);
                }
                if (code[1].equals("digit")) {
                    return Integer.toString(_LostBooks.random.nextInt(10));
                }
                if (code[1].equals("letter")) {
                    return Integer.toString(_LostBooks.random.nextInt(26) + 10, 36);
                }
                if (code[1].equals("color")) {
                    if (code.length > 2) {
                        int color = _LostBooks.random.nextInt(12);
                        return "\u00a7" + Integer.toString(color < 10 ? color : color + 2, 16);
                    }
                    return "\u00a7" + Integer.toString(_LostBooks.random.nextInt(16), 16);
                }
                if (code[1].equals("format")) {
                    if (code.length > 2) {
                        return "\u00a7" + Integer.toString(_LostBooks.random.nextInt(4) + 21, 36);
                    }
                    return "\u00a7" + Integer.toString(_LostBooks.random.nextInt(5) + 20, 36);
                }
            } else {
                if (code[0].equals("world")) {
                    if (code.length > 1 && code[1].equals("dimension")) {
                        return AdLibHelper.cap(cap, entity.field_70170_p.field_73011_w.func_80007_l());
                    }
                    return AdLibHelper.cap(cap, entity.field_70170_p.func_72912_H().func_76065_j());
                }
                try {
                    ArrayList entityList;
                    if (code[0].equals("player")) {
                        entityList = (ArrayList)((ArrayList)entity.field_70170_p.field_73010_i).clone();
                    } else {
                        entityList = (ArrayList)((ArrayList)entity.field_70170_p.field_72996_f).clone();
                        Iterator itr = entityList.iterator();
                        while (itr.hasNext()) {
                            if (AdLibHelper.isAppropriate(code[0], (Entity)itr.next())) continue;
                            itr.remove();
                        }
                    }
                    entityList.remove(entity);
                    if (!entityList.isEmpty()) {
                        Entity target = null;
                        if (code[1].equals("random")) {
                            target = (Entity)entityList.get(_LostBooks.random.nextInt(entityList.size()));
                            if (target != null) {
                                return AdLibHelper.cap(cap, target.func_70005_c_());
                            }
                        } else if (code[1].equals("nearest")) {
                            Entity other = null;
                            double closest = Double.POSITIVE_INFINITY;
                            double nextClosest = Double.POSITIVE_INFINITY;
                            for (Entity testEntity : entityList) {
                                double distance = entity.func_70068_e(testEntity);
                                if (distance < closest) {
                                    nextClosest = closest;
                                    closest = distance;
                                    other = target;
                                    target = testEntity;
                                    continue;
                                }
                                if (!(distance < nextClosest)) continue;
                                nextClosest = distance;
                                other = testEntity;
                            }
                            if (code.length > 2 && code[2].equals("other")) {
                                if (other != null) {
                                    return AdLibHelper.cap(cap, other.func_70005_c_());
                                }
                            } else if (target != null) {
                                return AdLibHelper.cap(cap, target.func_70005_c_());
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return AdLibHelper.nextWord(entity, (cap ? "c." : "") + "noun.name");
            }
        }
        return AdLibHelper.cap(cap, AdLibHelper.mash());
    }

    public static String nextWord(EntityLivingBase entity, String wordCode, HashMap<String, String> variables) {
        boolean cap = false;
        if (wordCode.startsWith("c.")) {
            cap = true;
            wordCode = wordCode.substring(2);
        }
        if (WORD_CODES.contains(wordCode)) {
            return AdLibHelper.nextWord(entity, (cap ? "c." : "") + wordCode);
        }
        if (variables.containsKey(wordCode)) {
            String word = variables.get(wordCode);
            return AdLibHelper.cap(cap, word);
        }
        return AdLibHelper.cap(cap, AdLibHelper.mash());
    }

    private static String cap(boolean cap, String value) {
        return cap ? _LostBooks.cap(value) : value;
    }

    public static boolean isAppropriate(String code, Entity entity) {
        if (code.equals("entity")) {
            return true;
        }
        if (code.equals("creature")) {
            return entity instanceof IAnimals;
        }
        if (code.equals("monster")) {
            return entity instanceof IMob;
        }
        if (code.equals("animal")) {
            return !(entity instanceof IMob) && entity instanceof IAnimals;
        }
        return false;
    }

    public static String mash() {
        String[] parts = new String[]{"cree", "per", "skel", "e", "ton", "zom", "bie", "spi", "der", "bla", "per", "the", "na", "ra", "a", "i", "o", "u", "do", "pa", "queb", "pin", "goo", "ball", "tall", "fu", "crab", "poo", "han", "so", "lo", "star", "me", "yo", "boo", "we", "jam", "ka", "tha", "che", "cha", "vu", "jack", "ed", "va", "ny", "she", "he", "ro", "bri", "ne", "fa", "ther", "to", "ast", "zap", "pick", "ax", "sho", "vel", "swo", "rd", "bow", "ar", "row", "arm", "or", "pump", "kin"};
        String word = "";
        int syl = 2 + (_LostBooks.random.nextInt(3) == 0 ? 0 : _LostBooks.random.nextInt(3));
        while (syl-- > 0) {
            word = word + parts[_LostBooks.random.nextInt(parts.length)];
        }
        return word;
    }

    public static BookStats generate(EntityLivingBase entity, File bookFile) {
        try {
            int dat;
            FileInputStream in = new FileInputStream(bookFile);
            HashMap<String, String> variables = new HashMap<String, String>();
            String[] story = new String[]{"" + AdLibHelper.setVariablesAndGetTitle(entity, in, variables), ""};
            while ((dat = in.read()) >= 0 && dat != 10) {
                if (dat == 13 || dat == 12) continue;
                if (dat == 64) {
                    boolean breakThrough = false;
                    String sub = "@";
                    while ((dat = in.read()) >= 0) {
                        if (dat == 10) {
                            breakThrough = true;
                            break;
                        }
                        if (dat == 13 || dat == 12) continue;
                        if (dat == 59) {
                            sub = AdLibHelper.nextWord(entity, sub.substring(1), variables);
                            break;
                        }
                        sub = sub + FileHelper.toAllowedString((char)dat);
                        if (!Character.isWhitespace(dat)) continue;
                    }
                    story[1] = story[1] + sub;
                    if (!breakThrough) continue;
                    break;
                }
                story[1] = story[1] + FileHelper.toAllowedString((char)dat);
            }
            ArrayList<String> text = new ArrayList<String>(50);
            String color = "";
            String formats = "";
            String page = "";
            while (true) {
                boolean ff = false;
                boolean s = false;
                String nextColor = color;
                String nextFormats = formats;
                String word = "";
                while ((dat = in.read()) >= 0) {
                    block34: {
                        if (dat == 12) {
                            ff = true;
                            break;
                        }
                        if (dat == 13) continue;
                        if (dat == 64) {
                            boolean doubleBreak = false;
                            String sub = "@";
                            while ((dat = in.read()) >= 0) {
                                if (dat == 12) {
                                    ff = true;
                                    doubleBreak = true;
                                    break;
                                }
                                if (dat == 13) continue;
                                if (dat == 59) {
                                    sub = AdLibHelper.nextWord(entity, sub.substring(1), variables);
                                    break;
                                }
                                sub = sub + FileHelper.toAllowedString((char)dat);
                                if (!Character.isWhitespace(dat)) continue;
                                doubleBreak = true;
                                break;
                            }
                            if (sub.startsWith("\u00a7")) {
                                char subDat = sub.charAt(1);
                                try {
                                    if (subDat == '0') {
                                        nextColor = "";
                                    } else {
                                        Integer.parseInt(FileHelper.toAllowedString(subDat), 16);
                                        nextColor = "\u00a7" + FileHelper.toAllowedString(subDat);
                                    }
                                    nextFormats = "";
                                }
                                catch (Exception ex) {
                                    subDat = Character.toLowerCase(subDat);
                                    if (subDat == 'r') {
                                        nextFormats = "";
                                    }
                                    if (subDat == 'k' || subDat == 'l' || subDat == 'm' || subDat == 'n' || subDat == 'o') {
                                        nextFormats = nextFormats + "\u00a7" + FileHelper.toAllowedString(subDat);
                                    }
                                    nextColor = "\u00a7f";
                                    nextFormats = "";
                                }
                            }
                            word = word + sub;
                            if (!doubleBreak) continue;
                            break;
                        }
                        if (s) {
                            s = false;
                            if (dat != 10) {
                                try {
                                    if (dat == 48) {
                                        nextColor = "";
                                    } else {
                                        Integer.parseInt(FileHelper.toAllowedString((char)dat), 16);
                                        nextColor = "\u00a7" + FileHelper.toAllowedString((char)dat);
                                    }
                                    nextFormats = "";
                                }
                                catch (Exception ex) {
                                    char tmp = Character.toLowerCase((char)dat);
                                    if (tmp == 'r') {
                                        nextFormats = "";
                                        break block34;
                                    }
                                    if (tmp == 'k' || tmp == 'l' || tmp == 'm' || tmp == 'n' || tmp == 'o') {
                                        nextFormats = nextFormats + "\u00a7" + FileHelper.toAllowedString(tmp);
                                        break block34;
                                    }
                                    nextColor = "\u00a7f";
                                    nextFormats = "";
                                }
                            }
                        } else if (dat == 167) {
                            s = true;
                        }
                    }
                    word = word + FileHelper.toAllowedString((char)dat);
                    if (!Character.isWhitespace(dat)) continue;
                }
                if (TextHelper.fitsOnPage(page + word)) {
                    page = page + word;
                } else {
                    text.add(page);
                    page = color + formats + word;
                }
                if (dat <= 0) break;
                if (ff) {
                    text.add(page);
                    color = "";
                    formats = "";
                    page = "";
                    continue;
                }
                color = nextColor;
                formats = nextFormats;
            }
            text.add(page);
            text.trimToSize();
            in.close();
            AdLibHelper.finish(story, text);
            return new BookStats(bookFile.getName(), story[0], story[1], text.toArray(new String[0]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new BookStats(bookFile.getName(), null, null, null);
        }
    }

    private static String setVariablesAndGetTitle(EntityLivingBase entity, FileInputStream in, HashMap<String, String> variables) {
        try {
            int dat;
            String title = "";
            boolean canBeVariable = true;
            while ((dat = in.read()) >= 0 && dat != 10) {
                if (dat == 13 || dat == 12) continue;
                if (dat == 64) {
                    boolean breakThrough = false;
                    String sub = "@";
                    while ((dat = in.read()) >= 0) {
                        if (dat == 10) {
                            breakThrough = true;
                            break;
                        }
                        if (dat == 13 || dat == 12) continue;
                        if (dat == 59) {
                            canBeVariable = false;
                            sub = AdLibHelper.nextWord(entity, sub.substring(1), variables);
                            break;
                        }
                        sub = sub + FileHelper.toAllowedString((char)dat);
                        if (!Character.isWhitespace(dat)) continue;
                    }
                    title = title + sub;
                    if (!breakThrough) continue;
                    break;
                }
                title = title + FileHelper.toAllowedString((char)dat);
            }
            if (canBeVariable && AdLibHelper.setVariable(entity, variables, title)) {
                return AdLibHelper.setVariablesAndGetTitle(entity, in, variables);
            }
            return title;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Untitled";
        }
    }

    private static boolean setVariable(EntityLivingBase entity, HashMap<String, String> variables, String line) {
        String variable = "";
        String wordCode = "";
        int state = 0;
        int length = line.length();
        for (int i = 0; i < length; ++i) {
            char dat = line.charAt(i);
            if (state == 0) {
                if (dat == ' ') {
                    if (variables.containsKey(variable)) break;
                    state = 1;
                    continue;
                }
                variable = variable + FileHelper.toAllowedString(dat);
                continue;
            }
            if (state == 3) {
                if (dat == ';') {
                    if (i != length - 1 || !WORD_CODES.contains(wordCode.startsWith("c.") ? wordCode.substring(2) : wordCode)) break;
                    variables.put(variable, AdLibHelper.nextWord(entity, wordCode, variables));
                    return true;
                }
                wordCode = wordCode + FileHelper.toAllowedString(dat);
                continue;
            }
            if (state == 1) {
                if (dat != '=') break;
                state = 2;
                continue;
            }
            if (state != 2) continue;
            if (dat != ' ') break;
            state = 3;
        }
        return false;
    }

    private static void finish(String[] story, ArrayList<String> text) {
        int i = story.length;
        while (i-- > 0) {
            int index = story[i].length();
            while ((index = story[i].lastIndexOf("#a;", index - 1)) >= 0) {
                String part = story[i].substring(index + 3);
                story[i] = story[i].substring(0, index) + (AdLibHelper.isNextVowel(part) == 1 ? "an" : "a") + part;
            }
        }
        ListIterator<String> iterator = text.listIterator(text.size());
        while (iterator.hasPrevious()) {
            String page = iterator.previous();
            int index = page.length();
            boolean update = false;
            while ((index = page.lastIndexOf("#a;", index - 1)) >= 0) {
                String part = page.substring(index + 3);
                byte vowel = AdLibHelper.isNextVowel(part);
                if (vowel < 0 && iterator.nextIndex() + 1 < text.size()) {
                    ListIterator<String> subIterator = text.listIterator(iterator.nextIndex() + 1);
                    while (vowel < 0 && subIterator.hasNext()) {
                        vowel = AdLibHelper.isNextVowel(subIterator.next());
                    }
                }
                page = page.substring(0, index) + (vowel == 1 ? "an" : "a") + part;
                update = true;
            }
            if (!update) continue;
            iterator.set(page);
        }
    }

    private static byte isNextVowel(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char dat = string.charAt(i);
            if (!Character.isLetterOrDigit(dat)) continue;
            return (byte)((dat = Character.toUpperCase(dat)) == 'E' || dat == 'A' || dat == 'I' || dat == 'O' || dat == 'U' ? 1 : 0);
        }
        return -1;
    }

    static {
        WORD_CODES.addAll(CUSTOM_WORD_CODES);
        WORD_CODES.addAll(SPECIAL_WORD_CODES);
        FileHelper.loadWords(WORDS);
    }
}

