/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import toast.lostBooks.AdLibHelper;
import toast.lostBooks.BookCollection;
import toast.lostBooks.BookHelper;
import toast.lostBooks.BookProperties;
import toast.lostBooks.BookStats;
import toast.lostBooks.IBook;

public class AdLibStats
implements IBook {
    public final File bookFile;
    public final int weight;
    public final ArrayList<Class> whitelist;
    public final ArrayList<Class> blacklist;
    public final boolean canBuy;
    public final HashSet<Integer> biomes;

    public AdLibStats(BookCollection parentCollection, File file, BookProperties properties) {
        this.bookFile = file;
        ArrayList<Class> whitelistDefault = parentCollection.whitelist;
        ArrayList<Class> blacklistDefault = parentCollection.blacklist;
        boolean canBuyDefault = parentCollection.canBuy;
        HashSet<Integer> biomesDefault = parentCollection.biomes;
        if (properties != null) {
            this.weight = Math.max(0, properties.getInt("weight", 100));
            this.whitelist = properties.getEntityList("whitelist", whitelistDefault);
            this.blacklist = properties.getEntityList("blacklist", blacklistDefault);
            this.canBuy = properties.getBoolean("can_buy", canBuyDefault);
            this.biomes = properties.getIdSet("biomes", biomesDefault);
        } else {
            this.weight = 100;
            this.whitelist = whitelistDefault;
            this.blacklist = blacklistDefault;
            this.canBuy = canBuyDefault;
            this.biomes = biomesDefault;
        }
    }

    @Override
    public String getName() {
        return this.bookFile.getName();
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public BookStats getBookStats(EntityLivingBase entity) {
        return AdLibHelper.generate(entity, this.bookFile);
    }

    @Override
    public BookStats getBookStatsSpawn(EntityPlayer player) {
        return this.getBookStats((EntityLivingBase)player);
    }

    @Override
    public BookStats getBookStatsTrade(EntityLivingBase entity) {
        return this.getBookStats(entity);
    }

    @Override
    public boolean isValid(EntityLivingBase entity) {
        return this.getWeight() > 0 && BookHelper.canBookDrop(entity, this.whitelist, this.blacklist, this.biomes);
    }

    @Override
    public boolean isValidSpawn(EntityPlayer player) {
        return this.getWeight() > 0;
    }

    @Override
    public boolean isValidTrade(EntityLivingBase entity) {
        return this.canBuy && this.getWeight() > 0;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public int size() {
        return 1;
    }
}

