/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import toast.lostBooks.BookHelper;
import toast.lostBooks.Library;
import toast.lostBooks.Properties;

public class Blackouts {
    public static final boolean DROP_BLACKOUTS = Properties.getBoolean("general", "uniqueBlackouts");
    public static final boolean ADAPTIVE_DROPS = Properties.getBoolean("general", "adaptiveDrops");
    private final HashSet<String> blackouts;

    public Blackouts(World world) {
        if (DROP_BLACKOUTS) {
            this.blackouts = Library.getUniqueIds();
            for (EntityPlayer player : (ArrayList)world.field_73010_i) {
                HashSet<String> foundIds = BookHelper.getBookData(player);
                Iterator<String> iterator = this.blackouts.iterator();
                while (iterator.hasNext()) {
                    if (foundIds.contains(iterator.next())) continue;
                    iterator.remove();
                }
                if (!this.blackouts.isEmpty()) continue;
                break;
            }
        } else {
            this.blackouts = new HashSet(0);
        }
    }

    public boolean isBlackedOut(String id) {
        return DROP_BLACKOUTS && this.blackouts.contains(id);
    }
}

