/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import toast.lostBooks._LostBooks;

public class BookProperties {
    public static final HashSet<String> USED_KEYS = new HashSet<String>(Arrays.asList("weight", "whitelist", "blacklist", "can_buy", "in_order", "biomes"));
    public static final HashMap<String, Class> SPECIAL_IDS = new HashMap();
    public final String fileName;
    private final HashMap<String, String> properties = new HashMap();

    private BookProperties(File file) {
        this.fileName = file.getAbsolutePath();
        try {
            int dat;
            FileInputStream in = new FileInputStream(file);
            String line = "";
            while ((dat = in.read()) >= 0) {
                if (dat == 13) continue;
                if (dat == 10) {
                    this.parseLine(line);
                    line = "";
                    continue;
                }
                line = line + Character.toString((char)dat);
            }
            this.parseLine(line);
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void parseLine(String line) {
        String[] split = line.split("=", 2);
        if (split.length == 2 && USED_KEYS.contains(split[0])) {
            this.properties.put(split[0], split[1]);
        }
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        String value = this.properties.get(key.toLowerCase());
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getString(key, null);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
        }
        return defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(key, -1);
    }

    public int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getString(key, ""));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public double getDouble(String key) {
        return this.getInt(key, -1);
    }

    public double getDouble(String key, double defaultValue) {
        try {
            return Double.parseDouble(this.getString(key, ""));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public int size() {
        return this.properties.size();
    }

    public HashSet<Integer> getIdSet(String key, HashSet<Integer> defaultValue) {
        String idList = this.getString(key);
        if (idList != null) {
            return BookProperties.getIdSet(this.fileName, idList);
        }
        return defaultValue;
    }

    public static HashSet<Integer> getIdSet(String location, String idList) {
        if (idList.equals("")) {
            return null;
        }
        String[] idArray = idList.split(",");
        HashSet<Integer> ids = new HashSet<Integer>();
        for (String entry : idArray) {
            try {
                ids.add(Integer.parseInt(entry));
            }
            catch (Exception ex) {
                _LostBooks.console("[WARNING] \"" + entry + "\" is an invalid biome id. Location: " + location);
            }
        }
        if (ids.size() > 0) {
            return ids;
        }
        return null;
    }

    public ArrayList<Class> getEntityList(String key, ArrayList<Class> defaultValue) {
        String classList = this.getString(key);
        if (classList != null) {
            return BookProperties.getEntityList(this.fileName, classList);
        }
        return defaultValue;
    }

    public static ArrayList<Class> getEntityList(String location, String classList) {
        if (classList.equals("")) {
            return null;
        }
        String[] classArray = classList.split(",");
        ArrayList<Class> classes = new ArrayList<Class>();
        for (String entry : classArray) {
            Class entityClass;
            if (entry.equals("Default")) {
                if (!classes.contains(IMerchant.class)) {
                    classes.add(IMerchant.class);
                }
                if (!classes.contains(INpc.class)) {
                    classes.add(INpc.class);
                }
                if (classes.contains(IMob.class)) continue;
                classes.add(IMob.class);
                continue;
            }
            if (SPECIAL_IDS.containsKey(entry)) {
                entityClass = SPECIAL_IDS.get(entry);
                if (classes.contains(entityClass)) continue;
                classes.add(entityClass);
                continue;
            }
            if (EntityList.field_75625_b.containsKey(entry)) {
                try {
                    entityClass = (Class)EntityList.field_75625_b.get(entry);
                    if (classes.contains(entityClass)) continue;
                    classes.add(entityClass);
                }
                catch (Exception ex) {
                    _LostBooks.console("[ERROR] \"" + entry + "\" is not registered properly (EntityList). Location: " + location);
                }
                continue;
            }
            try {
                entityClass = Class.forName(entry);
                if (classes.contains(entityClass)) continue;
                classes.add(entityClass);
            }
            catch (Exception ex) {
                _LostBooks.console("[WARNING] \"" + entry + "\" is invalid. Location: " + location);
            }
        }
        if (classes.size() > 0) {
            return classes;
        }
        return null;
    }

    public byte getBookUtilsCode() {
        return this.getBookUtilsCode((byte)0);
    }

    public byte getBookUtilsCode(byte defaultValue) {
        byte bitcode = 0;
        if (!this.getBoolean("edit", (1 & defaultValue) == 0)) {
            bitcode = (byte)(bitcode | 1);
        }
        if (!this.getBoolean("copy", (2 & defaultValue) == 0)) {
            bitcode = (byte)(bitcode | 2);
        }
        if (!this.getBoolean("copy_edit", (4 & defaultValue) == 0)) {
            bitcode = (byte)(bitcode | 4);
        }
        if (!this.getBoolean("copy_copy", (8 & defaultValue) == 0)) {
            bitcode = (byte)(bitcode | 8);
        }
        return bitcode;
    }

    public static BookProperties loadBookProperties(File folder, File file) {
        try {
            BookProperties props;
            File propFile;
            String fileName = file.getName();
            if (fileName.endsWith(".book")) {
                fileName = fileName.substring(0, fileName.length() - 5);
            }
            if ((propFile = new File(folder, fileName + ".txt")).exists() && (props = new BookProperties(propFile)).size() > 0) {
                return props;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    static {
        SPECIAL_IDS.put("Merchant", IMerchant.class);
        SPECIAL_IDS.put("Npc", INpc.class);
        SPECIAL_IDS.put("Hostile", IMob.class);
        SPECIAL_IDS.put("Player", EntityPlayer.class);
    }
}

