/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.WorldEvent;
import toast.lostBooks.Blackouts;
import toast.lostBooks.BookHelper;
import toast.lostBooks.Library;
import toast.lostBooks.Properties;
import toast.lostBooks.TickHandler;

public class EventHandler {
    public EventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDrops(LivingDropsEvent event) {
        ItemStack book;
        if (event.entityLiving == null || event.entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        if (event.recentlyHit && Properties.getBoolean("general", "dropRate", event.entityLiving.func_70681_au()) && (book = Library.nextBook(event.entityLiving)) != null) {
            EntityItem drop = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, book);
            drop.field_145804_b = 10;
            event.drops.add(drop);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityItemPickup(EntityItemPickupEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack book = event.item.func_92059_d();
        String id = BookHelper.getBookId(book);
        if (id != null && id != "") {
            if (BookHelper.isBookFound(event.entityPlayer, id)) {
                if (Properties.getBoolean("general", "hardUniqueBlackouts")) {
                    event.setCanceled(true);
                    return;
                }
            } else if (Blackouts.DROP_BLACKOUTS) {
                BookHelper.markBookAsFound(event.entityPlayer, id);
                TickHandler.unloadBlackouts(event.entityPlayer.field_70170_p);
            }
        }
        if (!event.item.field_70170_p.field_72995_K && BookHelper.removeBookId(book)) {
            event.item.func_92058_a(book);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemExpire(ItemExpireEvent event) {
        ItemStack book;
        if (Properties.getBoolean("general", "lostBookCaptureRate") && !event.isCanceled() && (book = event.entityItem.func_92059_d()).func_77973_b().func_77667_c(book).equals("item.writtenBook") && !BookHelper.hasBookId(book)) {
            Library.LOST_BOOKS.capture(book);
            if (!event.entityItem.field_70170_p.field_72995_K) {
                event.entityItem.func_92058_a(book);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world != null && !event.world.field_72995_K) {
            TickHandler.unloadBlackouts(event.world);
        }
    }
}

