/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import toast.lostBooks.BookHelper;
import toast.lostBooks.BookProperties;
import toast.lostBooks.BookStats;
import toast.lostBooks.FileHelper;
import toast.lostBooks.IBook;
import toast.lostBooks.LostBookStats;
import toast.lostBooks.Properties;
import toast.lostBooks.RandomHelper;
import toast.lostBooks._LostBooks;

public class LostBookCollection
implements IBook {
    public static final String F = "\f";
    public static File BOOK_DIRECTORY;

    public LostBookCollection(String category) {
    }

    public void capture(ItemStack book) {
        if (book == null || book.field_77990_d == null) {
            return;
        }
        try {
            String fileName = "";
            for (char letter : book.field_77990_d.func_74779_i("title").toCharArray()) {
                if (!Character.isLetterOrDigit(letter)) continue;
                fileName = fileName + Character.toString(letter);
            }
            File save = new File(BOOK_DIRECTORY, fileName + ".dat");
            if (save.exists()) {
                int attempt;
                for (attempt = 0; attempt < 100 && (save = new File(BOOK_DIRECTORY, fileName + attempt + ".dat")).exists(); ++attempt) {
                }
                if (attempt > 99) {
                    return;
                }
                fileName = fileName + attempt;
            }
            CompressedStreamTools.func_74799_a((NBTTagCompound)book.func_77955_b(new NBTTagCompound()), (OutputStream)new FileOutputStream(save));
            book.field_77994_a = 0;
        }
        catch (Exception ex) {
            _LostBooks.console("Failed to capture lost book!");
            ex.printStackTrace();
        }
    }

    private IBook[] loadBooks() {
        try {
            File[] bookFiles = BOOK_DIRECTORY.listFiles(new FileHelper.ExtensionFilter(".dat"));
            ArrayList<LostBookStats> books = new ArrayList<LostBookStats>(bookFiles.length);
            for (File file : bookFiles) {
                try {
                    new FileInputStream(file).close();
                    books.add(new LostBookStats(file));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return books.toArray(new IBook[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new IBook[0];
        }
    }

    @Override
    public String getName() {
        return BOOK_DIRECTORY.getName();
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public BookStats getBookStats(EntityLivingBase entity) {
        IBook book = RandomHelper.choose(entity, this.loadBooks());
        return book == null ? null : book.getBookStats(entity);
    }

    @Override
    public BookStats getBookStatsSpawn(EntityPlayer player) {
        IBook book = RandomHelper.chooseSpawn(player, this.loadBooks());
        return book == null ? null : book.getBookStatsSpawn(player);
    }

    @Override
    public BookStats getBookStatsTrade(EntityLivingBase entity) {
        IBook book = RandomHelper.chooseTrade(entity, this.loadBooks());
        return book == null ? null : book.getBookStatsTrade(entity);
    }

    @Override
    public boolean isValid(EntityLivingBase entity) {
        return this.getWeight() > 0 && this.size() > 0 && BookHelper.canBookDrop(entity, BookProperties.getEntityList("LostBooks.cfg", Properties.getString("lostBookProperties", "whitelist")), BookProperties.getEntityList("LostBooks.cfg", Properties.getString("lostBookProperties", "blacklist")), BookProperties.getIdSet("LostBooks.cfg", Properties.getString("lostBookProperties", "biomes")));
    }

    @Override
    public boolean isValidSpawn(EntityPlayer player) {
        return this.getWeight() > 0 && this.size() > 0;
    }

    @Override
    public boolean isValidTrade(EntityLivingBase entity) {
        return this.getWeight() > 0 && this.size() > 0;
    }

    @Override
    public int getWeight() {
        return Properties.getInt("general", "lostBookWeight");
    }

    @Override
    public int size() {
        try {
            return BOOK_DIRECTORY.listFiles(new FileHelper.ExtensionFilter(".dat")).length;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }
}

