/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import toast.lostBooks.IBook;
import toast.lostBooks._LostBooks;

public abstract class RandomHelper {
    public static IBook choose(EntityLivingBase entity, IBook ... items) {
        int i;
        int length = items.length;
        boolean[] valid = new boolean[length];
        for (int i2 = 0; i2 < length; ++i2) {
            valid[i2] = items[i2].isValid(entity);
        }
        int totalWeight = 0;
        for (i = 0; i < length; ++i) {
            if (!valid[i]) continue;
            totalWeight += items[i].getWeight();
        }
        if (totalWeight > 0) {
            totalWeight = _LostBooks.random.nextInt(totalWeight);
            for (i = 0; i < length; ++i) {
                if (!valid[i] || (totalWeight -= items[i].getWeight()) >= 0) continue;
                return items[i];
            }
        }
        return null;
    }

    public static IBook chooseSpawn(EntityPlayer player, IBook ... items) {
        int i;
        int length = items.length;
        boolean[] valid = new boolean[length];
        for (int i2 = 0; i2 < length; ++i2) {
            valid[i2] = items[i2].isValidSpawn(player);
        }
        int totalWeight = 0;
        for (i = 0; i < length; ++i) {
            if (!valid[i]) continue;
            totalWeight += items[i].getWeight();
        }
        if (totalWeight > 0) {
            totalWeight = _LostBooks.random.nextInt(totalWeight);
            for (i = 0; i < length; ++i) {
                if (!valid[i] || (totalWeight -= items[i].getWeight()) >= 0) continue;
                return items[i];
            }
        }
        return null;
    }

    public static IBook chooseTrade(EntityLivingBase entity, IBook ... items) {
        int i;
        int length = items.length;
        boolean[] valid = new boolean[length];
        for (int i2 = 0; i2 < length; ++i2) {
            valid[i2] = items[i2].isValidTrade(entity);
        }
        int totalWeight = 0;
        for (i = 0; i < length; ++i) {
            if (!valid[i]) continue;
            totalWeight += items[i].getWeight();
        }
        if (totalWeight > 0) {
            totalWeight = _LostBooks.random.nextInt(totalWeight);
            for (i = 0; i < length; ++i) {
                if (!valid[i] || (totalWeight -= items[i].getWeight()) >= 0) continue;
                return items[i];
            }
        }
        return null;
    }
}

