/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import net.minecraft.world.World;
import toast.lostBooks.Blackouts;

public class TickHandler {
    private static final HashMap<World, Blackouts> blackoutCache = new HashMap();
    private static byte updateTicks = (byte)-128;

    public static Blackouts getOrCreateBlackouts(World world) {
        Blackouts blackouts = blackoutCache.get(world);
        if (blackouts == null) {
            blackouts = new Blackouts(world);
            blackoutCache.put(world, blackouts);
        }
        return blackouts;
    }

    public static void unloadBlackouts() {
        blackoutCache.clear();
    }

    public static void unloadBlackouts(World world) {
        blackoutCache.remove(world);
    }

    public TickHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID == "LostBooks") {
            // empty if block
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && (updateTicks = (byte)(updateTicks + 1)) == 127) {
            updateTicks = (byte)-128;
            TickHandler.unloadBlackouts();
        }
    }
}

