/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLModDisabledEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.Random;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.Configuration;
import toast.lostBooks.AdLibHelper;
import toast.lostBooks.CommandBlackouts;
import toast.lostBooks.CommandTest;
import toast.lostBooks.EventHandler;
import toast.lostBooks.FileHelper;
import toast.lostBooks.ItemRandomBook;
import toast.lostBooks.Library;
import toast.lostBooks.MessageCurrPage;
import toast.lostBooks.Properties;
import toast.lostBooks.TickHandler;
import toast.lostBooks.TradeHandler;
import toast.lostBooks.client.ClientEventHandler;

@Mod(modid="LostBooks", name="Lost Books", version="1.2.2")
public class _LostBooks {
    public static final String MODID = "LostBooks";
    public static final String VERSION = "1.2.2";
    public static final boolean debug = false;
    public static final Random random = new Random();
    public static SimpleNetworkWrapper CHANNEL;
    public static boolean DISABLED;
    public static File CONFIG_DIRECTORY;
    public static Configuration CONFIG;
    public static Item randomBook;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        _LostBooks.debugConsole("Loading in debug mode!");
        CONFIG_DIRECTORY = event.getModConfigurationDirectory();
        CONFIG = new Configuration(event.getSuggestedConfigurationFile());
        Properties.init(CONFIG);
        CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("LB|CP");
        CHANNEL.registerMessage(MessageCurrPage.Handler.class, MessageCurrPage.class, 0, Side.SERVER);
        randomBook = new ItemRandomBook().func_77655_b("randomBook").func_77637_a(CreativeTabs.field_78026_f).func_111206_d("book_written").func_77625_d(16);
        GameRegistry.registerItem((Item)randomBook, (String)randomBook.func_77658_a().substring(5));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        new EventHandler();
        if (event.getSide() == Side.CLIENT) {
            new ClientEventHandler();
        }
        new TickHandler();
        new TradeHandler();
        if (Properties.getBoolean("general", "addChestLoot")) {
            ItemStack book = new ItemStack(randomBook, 1, 0);
            WeightedRandomChestContent tmp = new WeightedRandomChestContent(book, 1, 1, 2);
            ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(tmp);
            ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(tmp);
            ChestGenHooks.getInfo((String)"pyramidJungleChest").addItem(tmp);
            ChestGenHooks.getInfo((String)"strongholdCorridor").addItem(tmp);
            ChestGenHooks.getInfo((String)"strongholdLibrary").addItem(new WeightedRandomChestContent(book, 1, 5, 4));
            ChestGenHooks.getInfo((String)"strongholdCrossing").addItem(tmp);
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(tmp);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        _LostBooks.console("Loading books...");
        _LostBooks.console("Loaded " + Library.UNIQUE_BOOK_COUNT + " unique books, " + Library.COMMON_BOOKS.size() + " common books, and " + Library.AD_LIB_BOOKS.size() + " adlib books!");
        _LostBooks.console("Loading words...");
        AdLibHelper.init();
    }

    @Mod.EventHandler
    public void disable(FMLModDisabledEvent event) {
        DISABLED = true;
        _LostBooks.debugConsole("DISABLED!");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerAboutToStartEvent event) {
        FileHelper.init(event.getServer());
        ServerCommandManager commandManager = (ServerCommandManager)event.getServer().func_71187_D();
        commandManager.func_71560_a((ICommand)new CommandTest());
        commandManager.func_71560_a((ICommand)new CommandBlackouts());
    }

    public static String cap(String string) {
        char[] chars = string.toCharArray();
        if (chars.length <= 0) {
            return "";
        }
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String decap(String string) {
        char[] chars = string.toCharArray();
        if (chars.length <= 0) {
            return "";
        }
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static void console(String message) {
        System.out.println("[LostBooks] " + message);
    }

    public static void debugConsole(String message) {
    }

    public static void exception(String message) {
        throw new RuntimeException("[LostBooks] " + message);
    }

    public static void debugException(String message) {
    }

    static {
        DISABLED = false;
    }
}

