/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks.client;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import toast.lostBooks.BookHelper;
import toast.lostBooks.MessageCurrPage;
import toast.lostBooks._LostBooks;

@SideOnly(value=Side.CLIENT)
public class GuiScreenBookUtil
extends GuiScreen {
    private static final Logger logger = LogManager.getLogger();
    public static final ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    public final boolean pauseGame;
    public final EntityPlayer editingPlayer;
    public final ItemStack bookObj;
    public final boolean bookIsUnsigned;
    public boolean hasUpdated;
    public boolean settingTitle;
    public int updateCount;
    public final int bookImageWidth = 192;
    public final int bookImageHeight = 192;
    public int bookTotalPages = 1;
    public int currPage;
    public int lastCurrPage;
    public NBTTagList bookPages;
    public String bookTitle = "";
    public NextPageButton buttonNextPage;
    public NextPageButton buttonPreviousPage;
    public GuiButton buttonDone;
    public GuiButton buttonSign;
    public GuiButton buttonFinalize;
    public GuiButton buttonCancel;

    public GuiScreenBookUtil(GuiScreenBook parentScreen, boolean bookmark, boolean pauseGame) {
        this.editingPlayer = (EntityPlayer)ObfuscationReflectionHelper.getPrivateValue(GuiScreenBook.class, (Object)parentScreen, (String[])new String[]{"field_146468_g", "editingPlayer"});
        this.bookObj = (ItemStack)ObfuscationReflectionHelper.getPrivateValue(GuiScreenBook.class, (Object)parentScreen, (String[])new String[]{"field_146474_h", "bookObj"});
        this.bookIsUnsigned = (Boolean)ObfuscationReflectionHelper.getPrivateValue(GuiScreenBook.class, (Object)parentScreen, (String[])new String[]{"field_146475_i", "bookIsUnsigned"});
        this.pauseGame = pauseGame;
        if (this.bookObj.func_77942_o()) {
            NBTTagCompound nbttagcompound = this.bookObj.func_77978_p();
            this.bookPages = nbttagcompound.func_150295_c("pages", 8);
            if (this.bookPages != null) {
                this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                this.bookTotalPages = this.bookPages.func_74745_c();
                if (this.bookTotalPages < 1) {
                    this.bookTotalPages = 1;
                }
            }
            if (bookmark) {
                this.currPage = BookHelper.getCurrentPage(this.bookObj);
                if (this.currPage < 0 || this.currPage >= this.bookTotalPages) {
                    this.currPage = 0;
                }
                this.lastCurrPage = this.currPage;
            }
        }
        if (this.bookPages == null && this.bookIsUnsigned) {
            this.bookPages = new NBTTagList();
            this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
            this.bookTotalPages = 1;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.bookIsUnsigned) {
            int n = this.field_146294_l / 2 - 100;
            ((Object)((Object)this)).getClass();
            this.buttonSign = new GuiButton(3, n, 4 + 192, 98, 20, I18n.func_135052_a((String)"book.signButton", (Object[])new Object[0]));
            this.field_146292_n.add(this.buttonSign);
            int n2 = this.field_146294_l / 2 + 2;
            ((Object)((Object)this)).getClass();
            this.buttonDone = new GuiButton(0, n2, 4 + 192, 98, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
            this.field_146292_n.add(this.buttonDone);
            int n3 = this.field_146294_l / 2 - 100;
            ((Object)((Object)this)).getClass();
            this.buttonFinalize = new GuiButton(5, n3, 4 + 192, 98, 20, I18n.func_135052_a((String)"book.finalizeButton", (Object[])new Object[0]));
            this.field_146292_n.add(this.buttonFinalize);
            int n4 = this.field_146294_l / 2 + 2;
            ((Object)((Object)this)).getClass();
            this.buttonCancel = new GuiButton(4, n4, 4 + 192, 98, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
            this.field_146292_n.add(this.buttonCancel);
        } else {
            int n = this.field_146294_l / 2 - 100;
            ((Object)((Object)this)).getClass();
            this.buttonDone = new GuiButton(0, n, 4 + 192, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
            this.field_146292_n.add(this.buttonDone);
        }
        ((Object)((Object)this)).getClass();
        int i = (this.field_146294_l - 192) / 2;
        int b0 = 2;
        this.buttonNextPage = new NextPageButton(1, i + 120, b0 + 154, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(2, i + 38, b0 + 154, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.updateButtons();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = !this.settingTitle && (this.currPage < this.bookTotalPages - 1 || this.bookIsUnsigned);
        this.buttonPreviousPage.field_146125_m = !this.settingTitle && this.currPage > 0;
        boolean bl = this.buttonDone.field_146125_m = !this.bookIsUnsigned || !this.settingTitle;
        if (this.bookIsUnsigned) {
            this.buttonSign.field_146125_m = !this.settingTitle;
            this.buttonCancel.field_146125_m = this.settingTitle;
            this.buttonFinalize.field_146125_m = this.settingTitle;
            this.buttonFinalize.field_146124_l = this.bookTitle.trim().length() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBookToServer(boolean signing) {
        if (this.bookIsUnsigned && this.hasUpdated && this.bookPages != null) {
            String s;
            while (this.bookPages.func_74745_c() > 1 && (s = this.bookPages.func_150307_f(this.bookPages.func_74745_c() - 1)).length() == 0) {
                this.bookPages.func_74744_a(this.bookPages.func_74745_c() - 1);
            }
            if (this.bookObj.func_77942_o()) {
                NBTTagCompound nbttagcompound = this.bookObj.func_77978_p();
                nbttagcompound.func_74782_a("pages", (NBTBase)this.bookPages);
            } else {
                this.bookObj.func_77983_a("pages", (NBTBase)this.bookPages);
            }
            s = "MC|BEdit";
            if (signing) {
                s = "MC|BSign";
                this.bookObj.func_77983_a("author", (NBTBase)new NBTTagString(this.editingPlayer.func_70005_c_()));
                this.bookObj.func_77983_a("title", (NBTBase)new NBTTagString(this.bookTitle.trim()));
                this.bookObj.func_150996_a(Items.field_151164_bB);
            }
            ByteBuf bytebuf = Unpooled.buffer();
            try {
                new PacketBuffer(bytebuf).func_150788_a(this.bookObj);
                this.field_146297_k.func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload(s, bytebuf));
            }
            catch (Exception exception) {
                logger.error("Couldn't send book info", (Throwable)exception);
            }
            finally {
                bytebuf.release();
            }
        }
    }

    protected void func_146284_a(GuiButton p_146284_1_) {
        if (p_146284_1_.field_146124_l) {
            if (p_146284_1_.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
                this.sendBookToServer(false);
            } else if (p_146284_1_.field_146127_k == 3 && this.bookIsUnsigned) {
                this.settingTitle = true;
            } else if (p_146284_1_.field_146127_k == 1) {
                if (this.currPage < this.bookTotalPages - 1) {
                    ++this.currPage;
                } else if (this.bookIsUnsigned) {
                    this.addNewPage();
                    if (this.currPage < this.bookTotalPages - 1) {
                        ++this.currPage;
                    }
                }
                this.updateAndSendCurrPage();
            } else if (p_146284_1_.field_146127_k == 2) {
                if (this.currPage > 0) {
                    --this.currPage;
                    this.updateAndSendCurrPage();
                }
            } else if (p_146284_1_.field_146127_k == 5 && this.settingTitle) {
                this.sendBookToServer(true);
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (p_146284_1_.field_146127_k == 4 && this.settingTitle) {
                this.settingTitle = false;
            }
            this.updateButtons();
        }
    }

    private void updateAndSendCurrPage() {
        if (this.lastCurrPage != this.currPage) {
            this.lastCurrPage = this.currPage;
            BookHelper.setCurrentPage(this.bookObj, this.currPage);
            _LostBooks.CHANNEL.sendToServer((IMessage)new MessageCurrPage(this.currPage));
        }
    }

    private void addNewPage() {
        if (this.bookPages != null && this.bookPages.func_74745_c() < 50) {
            this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
            ++this.bookTotalPages;
            this.hasUpdated = true;
        }
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        super.func_73869_a(p_73869_1_, p_73869_2_);
        if (this.bookIsUnsigned) {
            if (this.settingTitle) {
                this.func_146460_c(p_73869_1_, p_73869_2_);
            } else {
                this.keyTypedInBook(p_73869_1_, p_73869_2_);
            }
        }
    }

    private void keyTypedInBook(char p_146463_1_, int p_146463_2_) {
        switch (p_146463_1_) {
            case '\u0016': {
                this.func_146459_b(GuiScreen.func_146277_j());
                return;
            }
        }
        switch (p_146463_2_) {
            case 14: {
                String s = this.func_146456_p();
                if (s.length() > 0) {
                    this.func_146457_a(s.substring(0, s.length() - 1));
                }
                return;
            }
            case 28: 
            case 156: {
                this.func_146459_b("\n");
                return;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)p_146463_1_)) {
            this.func_146459_b(Character.toString(p_146463_1_));
        }
    }

    private void func_146460_c(char p_146460_1_, int p_146460_2_) {
        switch (p_146460_2_) {
            case 14: {
                if (!this.bookTitle.isEmpty()) {
                    this.bookTitle = this.bookTitle.substring(0, this.bookTitle.length() - 1);
                    this.updateButtons();
                }
                return;
            }
            case 28: 
            case 156: {
                if (!this.bookTitle.isEmpty()) {
                    this.sendBookToServer(true);
                    this.field_146297_k.func_147108_a((GuiScreen)null);
                }
                return;
            }
        }
        if (this.bookTitle.length() < 16 && ChatAllowedCharacters.func_71566_a((char)p_146460_1_)) {
            this.bookTitle = this.bookTitle + Character.toString(p_146460_1_);
            this.updateButtons();
            this.hasUpdated = true;
        }
    }

    private String func_146456_p() {
        return this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c() ? this.bookPages.func_150307_f(this.currPage) : "";
    }

    private void func_146457_a(String p_146457_1_) {
        if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c()) {
            this.bookPages.func_150304_a(this.currPage, (NBTBase)new NBTTagString(p_146457_1_));
            this.hasUpdated = true;
        }
    }

    private void func_146459_b(String p_146459_1_) {
        String s1 = this.func_146456_p();
        String s2 = s1 + p_146459_1_;
        int i = this.field_146289_q.func_78267_b(s2 + "" + EnumChatFormatting.BLACK + "_", 118);
        if (i <= 118 && s2.length() < 256) {
            this.func_146457_a(s2);
        }
    }

    public void func_73863_a(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
        ((Object)((Object)this)).getClass();
        int k = (this.field_146294_l - 192) / 2;
        int b0 = 2;
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.func_73729_b(k, b0, 0, 0, 192, 192);
        if (this.settingTitle) {
            String s = this.bookTitle;
            if (this.bookIsUnsigned) {
                s = this.updateCount / 6 % 2 == 0 ? s + "" + EnumChatFormatting.BLACK + "_" : s + "" + EnumChatFormatting.GRAY + "_";
            }
            String s1 = I18n.func_135052_a((String)"book.editTitle", (Object[])new Object[0]);
            int l = this.field_146289_q.func_78256_a(s1);
            this.field_146289_q.func_78276_b(s1, k + 36 + (116 - l) / 2, b0 + 16 + 16, 0);
            int i1 = this.field_146289_q.func_78256_a(s);
            this.field_146289_q.func_78276_b(s, k + 36 + (116 - i1) / 2, b0 + 48, 0);
            String s2 = I18n.func_135052_a((String)"book.byAuthor", (Object[])new Object[]{this.editingPlayer.func_70005_c_()});
            int j1 = this.field_146289_q.func_78256_a(s2);
            this.field_146289_q.func_78276_b(EnumChatFormatting.DARK_GRAY + s2, k + 36 + (116 - j1) / 2, b0 + 48 + 10, 0);
            String s3 = I18n.func_135052_a((String)"book.finalizeWarning", (Object[])new Object[0]);
            this.field_146289_q.func_78279_b(s3, k + 36, b0 + 80, 116, 0);
        } else {
            String s = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.currPage + 1, this.bookTotalPages});
            String s1 = "";
            if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c()) {
                s1 = this.bookPages.func_150307_f(this.currPage);
            }
            if (this.bookIsUnsigned) {
                s1 = this.field_146289_q.func_78260_a() ? s1 + "_" : (this.updateCount / 6 % 2 == 0 ? s1 + "" + EnumChatFormatting.BLACK + "_" : s1 + "" + EnumChatFormatting.GRAY + "_");
            }
            int l = this.field_146289_q.func_78256_a(s);
            ((Object)((Object)this)).getClass();
            this.field_146289_q.func_78276_b(s, k - l + 192 - 44, b0 + 16, 0);
            this.field_146289_q.func_78279_b(s1, k + 36, b0 + 16 + 16, 116, 0);
        }
        super.func_73863_a(p_73863_1_, p_73863_2_, p_73863_3_);
    }

    public boolean func_73868_f() {
        return this.pauseGame;
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean field_146151_o;

        public NextPageButton(int p_i1079_1_, int p_i1079_2_, int p_i1079_3_, boolean p_i1079_4_) {
            super(p_i1079_1_, p_i1079_2_, p_i1079_3_, 23, 13, "");
            this.field_146151_o = p_i1079_4_;
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146125_m) {
                boolean flag = p_146112_2_ >= this.field_146128_h && p_146112_3_ >= this.field_146129_i && p_146112_2_ < this.field_146128_h + this.field_146120_f && p_146112_3_ < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                p_146112_1_.func_110434_K().func_110577_a(bookGuiTextures);
                int k = 0;
                int l = 192;
                if (flag) {
                    k += 23;
                }
                if (!this.field_146151_o) {
                    l += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, 23, 13);
            }
        }
    }
}

