/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.asm.util;

import com.mitchej123.hodgepodge.asm.util.AbstractResolvable;
import com.mitchej123.hodgepodge.asm.util.MethodRef;
import com.mitchej123.hodgepodge.asm.util.Namespace;
import java.util.HashMap;

public class ClassRef
extends AbstractResolvable<Class<?>> {
    public static final ClassRef INT = ClassRef.primitive("I", Integer.TYPE);
    public static final ClassRef FLOAT = ClassRef.primitive("F", Float.TYPE);
    public static final ClassRef BOOLEAN = ClassRef.primitive("Z", Boolean.TYPE);
    public static final ClassRef VOID = ClassRef.primitive("V", Void.class);
    public HashMap<String, MethodRef> methods;
    public boolean isPrimitive = false;
    public String mcpName;
    public String obfName;

    public ClassRef(String mcpName, String obfName) {
        this.mcpName = mcpName;
        this.obfName = obfName;
    }

    public ClassRef(String mcpName) {
        this(mcpName, mcpName);
    }

    protected static ClassRef primitive(String name, Class<?> classObj) {
        ClassRef result = new ClassRef(name);
        result.isPrimitive = true;
        result.resolvedObj = classObj;
        result.isResolved = true;
        return result;
    }

    public void addMethod(String mcpName, String srgName, String obfName, ClassRef returnType, ClassRef ... argTypes) {
        if (this.methods == null) {
            this.methods = new HashMap<String, MethodRef>(){};
        }
        MethodRef method = new MethodRef(this, mcpName, srgName, obfName, returnType, argTypes);
        this.methods.put(this.mcpName + "_" + mcpName, method);
    }

    public void addMethod(String mcpName, ClassRef returnType, ClassRef ... argTypes) {
        this.addMethod(mcpName, mcpName, mcpName, returnType, argTypes);
    }

    public MethodRef getMethod(String mcpName) {
        return this.methods.get(this.mcpName + "_" + mcpName);
    }

    public String getName(Namespace ns) {
        return ns == Namespace.OBF ? this.obfName : this.mcpName;
    }

    public String getAsmDescriptor(Namespace ns) {
        return this.isPrimitive ? this.mcpName : "L" + this.getName(ns).replace(".", "/") + ";";
    }

    @Override
    protected Class<?> resolveInternal() {
        try {
            return Class.forName(this.mcpName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(this.obfName);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
    }
}

