/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.coremods.keysoverhaul.core;

import code.elix_x.coremods.keysoverhaul.core.KeysOverhaulTranslator;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class Transformer
implements IClassTransformer {
    public byte[] transform(String className, String transformedName, byte[] bytes) {
        if (className.equals(KeysOverhaulTranslator.getMapedClassName("client.Minecraft"))) {
            System.out.println("*************** Patching Minecraft ***************");
            byte[] b = this.patchMinecraft(className, bytes);
            System.out.println("*************** Patching Minecraft Completed***************");
            return b;
        }
        return bytes;
    }

    private byte[] patchMinecraft(String className, byte[] bytes) {
        String runTick = KeysOverhaulTranslator.getMapedMethodName("Minecraft", "func_71407_l", "runTick");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(runTick) || !method.desc.equals("()V")) continue;
            System.out.println("*************** Patching runTick ***************");
            AbstractInsnNode currentNode = null;
            AbstractInsnNode targetNode = null;
            int place = -1;
            int index = -1;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                MethodInsnNode currentMethod;
                ++index;
                currentNode = (AbstractInsnNode)iter.next();
                if (currentNode.getOpcode() != 184 || !this.doesMethodEqual(currentMethod = (MethodInsnNode)currentNode, "net/minecraft/client/settings/KeyBinding", ".onTick", "(I)V")) continue;
                targetNode = currentNode;
                place = index;
                break;
            }
            boolean finish = false;
            while (!finish) {
                MethodInsnNode m;
                AbstractInsnNode remNode = method.instructions.get(place);
                if (remNode instanceof MethodInsnNode && (m = (MethodInsnNode)remNode).getOpcode() == 184 && this.doesMethodEqual(m, "org/lwjgl/input/Keyboard", ".getEventKey", "()I")) {
                    method.instructions.remove(remNode);
                    finish = true;
                    break;
                }
                method.instructions.remove(remNode);
                --place;
            }
            System.out.println("*************** Patching runTick complete ***************");
        }
        return null;
    }

    private AbstractInsnNode findNode(InsnList list, AbstractInsnNode node) {
        AbstractInsnNode currentNode = null;
        AbstractInsnNode targetNode = null;
        int place = -1;
        int index = -1;
        ListIterator iter = list.iterator();
        while (iter.hasNext()) {
            ++index;
            currentNode = (AbstractInsnNode)iter.next();
            if (!this.areNodesEqual(node, currentNode)) continue;
            targetNode = currentNode;
            place = index;
            break;
        }
        return targetNode;
    }

    private int findNodePos(InsnList list, AbstractInsnNode node) {
        AbstractInsnNode currentNode = null;
        AbstractInsnNode targetNode = null;
        int place = -1;
        int index = -1;
        ListIterator iter = list.iterator();
        while (iter.hasNext()) {
            ++index;
            currentNode = (AbstractInsnNode)iter.next();
            if (!this.areNodesEqual(node, currentNode)) continue;
            targetNode = currentNode;
            place = index;
            break;
        }
        return place;
    }

    private boolean areNodesEqual(AbstractInsnNode node, AbstractInsnNode node1) {
        return node.getOpcode() == node1.getOpcode() && node.getType() == node1.getType();
    }

    private InsnList createNewListAndFillWith(Object ... nodes) {
        InsnList list = new InsnList();
        for (Object node : nodes) {
            if (node instanceof AbstractInsnNode) {
                list.add((AbstractInsnNode)node);
            }
            if (!(node instanceof InsnList)) continue;
            list.add(list);
        }
        return list;
    }

    private void replace(InsnList instructions, int index, AbstractInsnNode node) {
        instructions.insert(instructions.get(index), node);
    }

    private void replace(InsnList instructions, int index, InsnList node) {
        instructions.insert(instructions.get(index), node);
    }

    private MethodInsnNode createMethodNode(int opcode, String owner, String name, String desc) {
        return new MethodInsnNode(opcode, owner, name, desc);
    }

    private boolean doesMethodEqual(MethodInsnNode method, String owner, String name, String desc) {
        return method.owner == owner && method.name == name && method.desc == desc;
    }
}

