/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.microblock;

import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import mcmultipart.microblock.IMicroMaterial;
import mcmultipart.microblock.IMicroblock;
import mcmultipart.microblock.MicroblockClass;
import mcmultipart.microblock.MicroblockDelegate;
import mcmultipart.microblock.MicroblockRegistry;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IRedstonePart;
import mcmultipart.multipart.Multipart;
import mcmultipart.multipart.PartSlot;
import mcmultipart.property.PropertyBlockState;
import mcmultipart.property.PropertyMicroMaterial;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class Microblock
extends Multipart
implements IMicroblock,
IRedstonePart,
IRedstonePart.ISlottedRedstonePart {
    public static final IUnlistedProperty<?>[] PROPERTIES = new IUnlistedProperty[4];
    public static final IUnlistedProperty<IMicroMaterial> PROPERTY_MATERIAL;
    public static final IUnlistedProperty<IBlockState> PROPERTY_MATERIAL_STATE;
    public static final IUnlistedProperty<Integer> PROPERTY_SIZE;
    public static final IUnlistedProperty<PartSlot> PROPERTY_SLOT;
    protected IMicroMaterial material;
    protected PartSlot slot;
    protected int size;
    protected MicroblockDelegate delegate;

    public Microblock(IMicroMaterial material, PartSlot slot, int size, boolean isRemote) {
        this.material = material;
        this.slot = slot;
        this.size = size;
        this.delegate = material instanceof IMicroMaterial.IDelegatedMicroMaterial ? ((IMicroMaterial.IDelegatedMicroMaterial)material).provideDelegate(this, isRemote) : null;
    }

    @Override
    public abstract MicroblockClass getMicroClass();

    @Override
    public IMicroMaterial getMicroMaterial() {
        return this.material;
    }

    @Override
    public EnumSet<PartSlot> getSlotMask() {
        return this.slot == null ? EnumSet.noneOf(PartSlot.class) : EnumSet.of(this.slot);
    }

    @Override
    public PartSlot getSlot() {
        return this.slot;
    }

    @Override
    public void setSlot(PartSlot slot) {
        this.slot = slot;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public ResourceLocation getType() {
        return this.getMicroClass().getFullQualifiedType();
    }

    @Override
    public int getLightValue() {
        return this.getMicroMaterial().getLightValue();
    }

    @Override
    public float getHardness(PartMOP hit) {
        return this.getMicroMaterial().getHardness();
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        int size = this.getSize();
        int picked = 1;
        for (int i = 2; i >= 0; --i) {
            if (size - (1 << i) < 0) continue;
            picked = 1 << i;
            size -= picked;
        }
        return this.getMicroClass().createStack(this.getMicroMaterial(), picked, 1);
    }

    @Override
    public List<ItemStack> getDrops() {
        MicroblockClass microclass = this.getMicroClass();
        IMicroMaterial material = this.getMicroMaterial();
        int size = this.getSize();
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 2; i >= 0; --i) {
            if (size - (1 << i) < 0) continue;
            size -= 1 << i;
            drops.add(microclass.createStack(material, 1 << i, 1));
        }
        return drops;
    }

    @Override
    public boolean occlusionTest(IMultipart part) {
        if (part instanceof IMicroblock) {
            return true;
        }
        return super.occlusionTest(part);
    }

    public IExtendedBlockState getExtendedState(IBlockState state) {
        return ((IExtendedBlockState)state).withProperty(PROPERTY_MATERIAL, (Object)this.getMicroMaterial()).withProperty(PROPERTY_MATERIAL_STATE, (Object)this.getMicroMaterial().getMaterialState((IBlockAccess)this.getWorld(), this.getPos(), this)).withProperty(PROPERTY_SIZE, (Object)this.getSize()).withProperty(PROPERTY_SLOT, (Object)this.slot);
    }

    public ExtendedBlockState createBlockState() {
        return new ExtendedBlockState(null, new IProperty[0], PROPERTIES);
    }

    @Override
    public void writeUpdatePacket(PacketBuffer buf) {
        super.writeUpdatePacket(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getMicroMaterial().getName());
        buf.writeInt(this.slot != null ? this.slot.ordinal() : -1);
        buf.writeInt(this.getSize());
        if (this.delegate != null) {
            this.delegate.writeUpdatePacket(buf);
        }
    }

    @Override
    public void readUpdatePacket(PacketBuffer buf) {
        super.readUpdatePacket(buf);
        IMicroMaterial oldMat = this.material;
        this.material = MicroblockRegistry.getMaterial(ByteBufUtils.readUTF8String((ByteBuf)buf));
        int iSlot = buf.readInt();
        this.slot = iSlot == -1 ? null : PartSlot.VALUES[iSlot];
        this.size = buf.readInt();
        if (oldMat != this.material) {
            MicroblockDelegate microblockDelegate = this.delegate = this.material instanceof IMicroMaterial.IDelegatedMicroMaterial ? ((IMicroMaterial.IDelegatedMicroMaterial)this.material).provideDelegate(this, true) : null;
        }
        if (this.delegate != null) {
            this.delegate.readUpdatePacket(buf);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = super.writeToNBT(tag);
        tag.func_74778_a("material", this.getMicroMaterial().getName());
        tag.func_74768_a("slot", this.slot != null ? this.slot.ordinal() : -1);
        tag.func_74768_a("size", this.getSize());
        if (this.delegate != null) {
            tag = this.delegate.writeToNBT(tag);
        }
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.material = MicroblockRegistry.getMaterial(tag.func_74779_i("material"));
        int iSlot = tag.func_74762_e("slot");
        this.slot = iSlot == -1 ? null : PartSlot.VALUES[iSlot];
        this.size = tag.func_74762_e("size");
        MicroblockDelegate microblockDelegate = this.delegate = this.material instanceof IMicroMaterial.IDelegatedMicroMaterial ? ((IMicroMaterial.IDelegatedMicroMaterial)this.material).provideDelegate(this, false) : null;
        if (this.delegate != null) {
            this.delegate.readFromNBT(tag);
        }
    }

    @Override
    public void harvest(EntityPlayer player, PartMOP hit) {
        if (this.delegate == null || !this.delegate.harvest(player, hit)) {
            super.harvest(player, hit);
        }
    }

    @Override
    public float getStrength(EntityPlayer player, PartMOP hit) {
        Optional<Float> strength;
        if (this.delegate != null && (strength = this.delegate.getStrength(player, hit)).isPresent()) {
            return ((Float)strength.get()).floatValue();
        }
        return super.getStrength(player, hit);
    }

    @Override
    public void onPartChanged(IMultipart part) {
        super.onPartChanged(part);
        if (this.delegate != null) {
            this.delegate.onPartChanged(part);
        }
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        if (this.delegate != null) {
            this.delegate.onNeighborBlockChange(block);
        }
    }

    @Override
    public void onNeighborTileChange(EnumFacing facing) {
        super.onNeighborTileChange(facing);
        if (this.delegate != null) {
            this.delegate.onNeighborTileChange(facing);
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (this.delegate != null) {
            this.delegate.onAdded();
        }
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (this.delegate != null) {
            this.delegate.onRemoved();
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.delegate != null) {
            this.delegate.onLoaded();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.delegate != null) {
            this.delegate.onUnloaded();
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, PartMOP hit) {
        Optional<Boolean> activated;
        if (this.delegate != null && (activated = this.delegate.onActivated(player, hand, heldItem, hit)).isPresent()) {
            return (Boolean)activated.get();
        }
        return super.onActivated(player, hand, heldItem, hit);
    }

    @Override
    public void onClicked(EntityPlayer player, PartMOP hit) {
        if (this.delegate != null && this.delegate.onClicked(player, hit)) {
            return;
        }
        super.onClicked(player, hit);
    }

    @Override
    public boolean canConnectRedstone(EnumFacing side) {
        Optional<Boolean> can;
        if (this.delegate != null && (can = this.delegate.canConnectRedstone(side)).isPresent()) {
            return (Boolean)can.get();
        }
        return false;
    }

    @Override
    public int getWeakSignal(EnumFacing side) {
        Optional<Integer> signal;
        if (this.delegate != null && (signal = this.delegate.getWeakSignal(side)).isPresent()) {
            return (Integer)signal.get();
        }
        return 0;
    }

    @Override
    public int getStrongSignal(EnumFacing side) {
        Optional<Integer> signal;
        if (this.delegate != null && (signal = this.delegate.getStrongSignal(side)).isPresent()) {
            return (Integer)signal.get();
        }
        return 0;
    }

    static {
        Microblock.PROPERTIES[0] = PROPERTY_MATERIAL = new PropertyMicroMaterial("material");
        Microblock.PROPERTIES[1] = PROPERTY_MATERIAL_STATE = new PropertyBlockState("material_state");
        Microblock.PROPERTIES[2] = PROPERTY_SIZE = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"size", (int)0, (int)7));
        Microblock.PROPERTIES[3] = PROPERTY_SLOT = new Properties.PropertyAdapter((IProperty)PropertyEnum.func_177709_a((String)"slot", PartSlot.class));
    }

    public static class PropertyEnumSet<T extends Enum<T>>
    implements IUnlistedProperty<EnumSet<T>> {
        private final String name;

        public PropertyEnumSet(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isValid(EnumSet<T> value) {
            return value != null;
        }

        public Class<EnumSet<T>> getType() {
            return EnumSet.class;
        }

        public String valueToString(EnumSet<T> value) {
            return value.toString();
        }
    }

    public static class PropertyAABB
    implements IUnlistedProperty<AxisAlignedBB> {
        private final String name;

        public PropertyAABB(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isValid(AxisAlignedBB value) {
            return value != null;
        }

        public Class<AxisAlignedBB> getType() {
            return AxisAlignedBB.class;
        }

        public String valueToString(AxisAlignedBB value) {
            return value.toString();
        }
    }
}

