/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.jan.moddirector.core.configuration.ConfigurationController;
import net.jan.moddirector.core.configuration.ModDirectorRemoteMod;
import net.jan.moddirector.core.configuration.modpack.ModpackConfiguration;
import net.jan.moddirector.core.logging.ModDirectorLogger;
import net.jan.moddirector.core.logging.ModDirectorSeverityLevel;
import net.jan.moddirector.core.manage.InstallController;
import net.jan.moddirector.core.manage.ModDirectorError;
import net.jan.moddirector.core.manage.NullProgressCallback;
import net.jan.moddirector.core.manage.ProgressCallback;
import net.jan.moddirector.core.manage.install.InstallableMod;
import net.jan.moddirector.core.manage.install.InstalledMod;
import net.jan.moddirector.core.manage.select.InstallSelector;
import net.jan.moddirector.core.platform.ModDirectorPlatform;
import net.jan.moddirector.core.ui.SetupDialog;
import net.jan.moddirector.core.ui.page.ProgressPage;

public class ModDirector {
    private static ModDirector instance;
    private final ModDirectorPlatform platform;
    private final ModDirectorLogger logger;
    private final ConfigurationController configurationController;
    private final InstallController installController;
    private final InstallSelector installSelector;
    private final List<ModDirectorError> errors;
    private final List<InstalledMod> installedMods;
    private final ExecutorService executorService;
    private final NullProgressCallback nullProgressCallback;

    public static ModDirector bootstrap(ModDirectorPlatform platform) {
        if (instance != null) {
            throw new IllegalStateException("ModDirector has already been bootstrapped using platform " + platform.name());
        }
        instance = new ModDirector(platform);
        instance.bootstrap();
        return instance;
    }

    public static ModDirector getInstance() {
        if (instance == null) {
            throw new IllegalStateException("ModDirector has not been bootstrapped yet");
        }
        return instance;
    }

    private ModDirector(ModDirectorPlatform platform) {
        this.platform = platform;
        this.logger = platform.logger();
        this.configurationController = new ConfigurationController(this, platform.configurationDirectory());
        this.installController = new InstallController(this);
        this.installSelector = new InstallSelector();
        this.errors = new LinkedList<ModDirectorError>();
        this.installedMods = new LinkedList<InstalledMod>();
        this.executorService = Executors.newFixedThreadPool(4);
        this.nullProgressCallback = new NullProgressCallback();
        this.logger.log(ModDirectorSeverityLevel.INFO, "ModDirector", "CORE", "Mod director loaded!", new Object[0]);
    }

    private void bootstrap() {
        this.platform.bootstrap();
    }

    private ProgressCallback createNullProgressCallback(String title, String info) {
        return this.nullProgressCallback;
    }

    public boolean activate(long timeout, TimeUnit timeUnit) throws InterruptedException {
        ProgressPage installProgressPage;
        this.configurationController.load();
        List<ModDirectorRemoteMod> mods = this.configurationController.getConfigurations();
        ModpackConfiguration modpackConfiguration = this.configurationController.getModpackConfiguration();
        if (modpackConfiguration == null) {
            this.logger.log(ModDirectorSeverityLevel.WARN, "ModDirector", "CORE", "This modpack does not contain a modpack.json, if you are the author, consider adding one!", new Object[0]);
            modpackConfiguration = ModpackConfiguration.createDefault();
        }
        if (this.hasFatalError()) {
            return false;
        }
        SetupDialog setupDialog = null;
        if (!this.platform.headless()) {
            setupDialog = new SetupDialog(modpackConfiguration);
            setupDialog.setLocationRelativeTo(null);
            setupDialog.setVisible(true);
        }
        ProgressPage preInstallationPage = setupDialog == null ? null : setupDialog.navigateToProgressPage("Checking installation...");
        ArrayList<ModDirectorRemoteMod> excludedMods = new ArrayList<ModDirectorRemoteMod>();
        ArrayList<InstallableMod> reInstalls = new ArrayList<InstallableMod>();
        ArrayList<InstallableMod> freshInstalls = new ArrayList<InstallableMod>();
        List<Callable<Void>> preInstallTasks = this.installController.createPreInstallTasks(mods, excludedMods, freshInstalls, reInstalls, preInstallationPage != null ? preInstallationPage::createProgressCallback : this::createNullProgressCallback);
        this.awaitAll(this.executorService.invokeAll(preInstallTasks));
        this.installSelector.accept(excludedMods, freshInstalls, reInstalls);
        if (this.hasFatalError()) {
            this.errorExit();
        }
        if (setupDialog != null && this.installSelector.hasSelectableOptions()) {
            setupDialog.navigateToSelectionPage(this.installSelector);
            setupDialog.waitForNext();
        }
        List<InstallableMod> toInstall = this.installSelector.computeModsToInstall();
        ProgressPage progressPage = installProgressPage = setupDialog == null ? null : setupDialog.navigateToProgressPage("Installing " + modpackConfiguration.packName());
        List<Callable<Void>> installTasks = this.installController.createInstallTasks(toInstall, installProgressPage != null ? installProgressPage::createProgressCallback : this::createNullProgressCallback);
        installTasks.add(() -> {
            this.installController.markDisabledMods(this.installSelector.computeDisabledMods());
            return null;
        });
        this.awaitAll(this.executorService.invokeAll(installTasks));
        if (this.hasFatalError()) {
            this.errorExit();
        }
        this.executorService.shutdown();
        this.executorService.awaitTermination(timeout, timeUnit);
        if (setupDialog != null) {
            setupDialog.dispose();
        }
        return !this.hasFatalError();
    }

    public ModDirectorLogger getLogger() {
        return this.logger;
    }

    public ModDirectorPlatform getPlatform() {
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(ModDirectorError error) {
        List<ModDirectorError> list = this.errors;
        synchronized (list) {
            this.errors.add(error);
        }
    }

    public boolean hasFatalError() {
        return this.errors.stream().anyMatch(e -> e.getLevel() == ModDirectorSeverityLevel.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installSuccess(InstalledMod mod) {
        List<InstalledMod> list = this.installedMods;
        synchronized (list) {
            this.installedMods.add(mod);
        }
    }

    public List<InstalledMod> getInstalledMods() {
        return Collections.unmodifiableList(this.installedMods);
    }

    public void errorExit() {
        this.logger.log(ModDirectorSeverityLevel.ERROR, "ModDirector", "CORE", "============================================================", new Object[0]);
        this.logger.log(ModDirectorSeverityLevel.ERROR, "ModDirector", "CORE", "Summary of %d encountered errors:", this.errors.size());
        this.errors.forEach(e -> {
            if (e.getException() != null) {
                this.logger.logThrowable(e.getLevel(), "ModDirector", "CORE", e.getException(), e.getMessage(), new Object[0]);
            } else {
                this.logger.log(e.getLevel(), "ModDirector", "CORE", e.getMessage(), new Object[0]);
            }
        });
        this.logger.log(ModDirectorSeverityLevel.ERROR, "ModDirector", "CORE", "============================================================", new Object[0]);
        System.exit(1);
    }

    private void awaitAll(List<Future<Void>> futures) throws InterruptedException {
        for (Future<Void> future : futures) {
            try {
                future.get();
            }
            catch (CancellationException e) {
                this.logger.logThrowable(ModDirectorSeverityLevel.ERROR, "ModDirector", "CORE", e, "A future task was cancelled unexpectedly", new Object[0]);
                this.addError(new ModDirectorError(ModDirectorSeverityLevel.ERROR, "A future task was cancelled unexpectedly", e));
            }
            catch (ExecutionException e) {
                this.logger.logThrowable(ModDirectorSeverityLevel.ERROR, "ModDirector", "CORE", e, "An exception occurred while performing asynchronous work", new Object[0]);
                this.addError(new ModDirectorError(ModDirectorSeverityLevel.ERROR, "An exception occurred while performing asynchronous work", e));
            }
        }
    }
}

