/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.configuration;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.jan.moddirector.core.ModDirector;
import net.jan.moddirector.core.configuration.ModDirectorRemoteMod;
import net.jan.moddirector.core.configuration.modpack.ModpackConfiguration;
import net.jan.moddirector.core.configuration.type.CurseRemoteMod;
import net.jan.moddirector.core.configuration.type.UrlRemoteMod;
import net.jan.moddirector.core.logging.ModDirectorSeverityLevel;
import net.jan.moddirector.core.manage.ModDirectorError;

public class ConfigurationController {
    public static final ObjectMapper OBJECT_MAPPER = ConfigurationController.createObjectMapper();
    private final ModDirector director;
    private final Path configurationDirectory;
    private final List<ModDirectorRemoteMod> configurations;
    private ModpackConfiguration modpackConfiguration;

    private static ObjectMapper createObjectMapper() {
        ObjectMapper instance = new ObjectMapper();
        instance.setDefaultLeniency(false);
        instance.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        return instance;
    }

    public ConfigurationController(ModDirector director, Path configurationDirectory) {
        this.director = director;
        this.configurationDirectory = configurationDirectory;
        this.configurations = new ArrayList<ModDirectorRemoteMod>();
    }

    public void load() {
        Path modpackConfigPath = this.configurationDirectory.resolve("modpack.json");
        if (Files.exists(modpackConfigPath, new LinkOption[0]) && !this.loadModpackConfiguration(modpackConfigPath)) {
            return;
        }
        try (Stream<Path> paths = Files.walk(this.configurationDirectory, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json")).filter(p -> !p.getFileName().toString().equals("modpack.json")).forEach(this::addConfig);
        }
        catch (IOException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, "ModDirector/ConfigurationController", "CORE", e, "Failed to iterate configuration directory!", new Object[0]);
            this.director.addError(new ModDirectorError(ModDirectorSeverityLevel.ERROR, "Failed to iterate configuration directory", e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadModpackConfiguration(Path configurationPath) {
        try (InputStream stream = Files.newInputStream(configurationPath, new OpenOption[0]);){
            this.modpackConfiguration = OBJECT_MAPPER.readValue(stream, ModpackConfiguration.class);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, "ModDirector/ConfigurationController", "CORE", e, "Failed to read modpack configuration!", new Object[0]);
            this.director.addError(new ModDirectorError(ModDirectorSeverityLevel.ERROR, "Failed to read modpack configuration!"));
            return false;
        }
    }

    private void addConfig(Path configurationPath) {
        this.director.getLogger().log(ModDirectorSeverityLevel.INFO, "ModDirector/ConfigurationController", "CORE", "Loading config %s", configurationPath.toString());
        Class<? extends ModDirectorRemoteMod> targetType = this.getTypeForFile(configurationPath);
        if (targetType == null) {
            return;
        }
        try (InputStream stream = Files.newInputStream(configurationPath, new OpenOption[0]);){
            this.configurations.add(OBJECT_MAPPER.readValue(stream, targetType));
        }
        catch (JsonParseException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, "ModDirector/ConfigurationController", "CORE", e, "Failed to parse a configuration!", new Object[0]);
            this.director.addError(new ModDirectorError(ModDirectorSeverityLevel.ERROR, "Failed to parse a configuration", e));
        }
        catch (IOException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, "ModDirector/ConfigurationController", "CORE", e, "Failed to open a configuration for reading!", new Object[0]);
            this.director.addError(new ModDirectorError(ModDirectorSeverityLevel.ERROR, "Failed to open a configuration for reading", e));
        }
    }

    private Class<? extends ModDirectorRemoteMod> getTypeForFile(Path file) {
        String name = file.toString();
        if (name.endsWith(".curse.json")) {
            return CurseRemoteMod.class;
        }
        if (name.endsWith(".url.json")) {
            return UrlRemoteMod.class;
        }
        this.director.getLogger().log(ModDirectorSeverityLevel.WARN, "ModDirector/ConfigurationController", "CORE", "Ignoring unknown json file %s", name);
        return null;
    }

    public ModpackConfiguration getModpackConfiguration() {
        return this.modpackConfiguration;
    }

    public List<ModDirectorRemoteMod> getConfigurations() {
        return this.configurations;
    }
}

