/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.configuration.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import net.jan.moddirector.core.ModDirector;
import net.jan.moddirector.core.configuration.ConfigurationController;
import net.jan.moddirector.core.configuration.InstallationPolicy;
import net.jan.moddirector.core.configuration.ModDirectorRemoteMod;
import net.jan.moddirector.core.configuration.RemoteModInformation;
import net.jan.moddirector.core.configuration.RemoteModMetadata;
import net.jan.moddirector.core.exception.ModDirectorException;
import net.jan.moddirector.core.manage.ProgressCallback;
import net.jan.moddirector.core.util.IOOperation;
import net.jan.moddirector.core.util.WebClient;
import net.jan.moddirector.core.util.WebGetResponse;

public class CurseRemoteMod
extends ModDirectorRemoteMod {
    private final int addonId;
    private final int fileId;
    private CurseAddonFileInformation information;

    @JsonCreator
    public CurseRemoteMod(@JsonProperty(value="addonId", required=true) int addonId, @JsonProperty(value="fileId", required=true) int fileId, @JsonProperty(value="metadata") RemoteModMetadata metadata, @JsonProperty(value="installationPolicy") InstallationPolicy installationPolicy, @JsonProperty(value="options") Map<String, Object> options, @JsonProperty(value="folder") String folder, @JsonProperty(value="inject") Boolean inject) {
        super(metadata, installationPolicy, options, folder, inject);
        this.addonId = addonId;
        this.fileId = fileId;
    }

    @Override
    public String remoteType() {
        return "Curse";
    }

    @Override
    public String offlineName() {
        return this.addonId + ":" + this.fileId;
    }

    @Override
    public void performInstall(Path targetFile, ProgressCallback progressCallback, ModDirector director, RemoteModInformation information) throws ModDirectorException {
        try (WebGetResponse response = WebClient.get(this.information.downloadUrl);){
            progressCallback.setSteps(1);
            IOOperation.copy(response.getInputStream(), Files.newOutputStream(targetFile, new OpenOption[0]), progressCallback, response.getStreamSize());
        }
        catch (IOException e) {
            throw new ModDirectorException("Failed to download file", e);
        }
    }

    @Override
    public RemoteModInformation queryInformation() throws ModDirectorException {
        try {
            URL apiUrl = new URL(String.format("https://addons-ecs.forgesvc.net/api/v2/addon/%d/file/%d", this.addonId, this.fileId));
            this.information = ConfigurationController.OBJECT_MAPPER.readValue(apiUrl, CurseAddonFileInformation.class);
        }
        catch (MalformedURLException e) {
            throw new ModDirectorException("Failed to create ForgeSVC api url", e);
        }
        catch (JsonParseException e) {
            throw new ModDirectorException("Failed to parse Json response from curse", e);
        }
        catch (JsonMappingException e) {
            throw new ModDirectorException("Failed to map Json response from curse, did they change their api?", e);
        }
        catch (IOException e) {
            throw new ModDirectorException("Failed to open connection to curse", e);
        }
        return new RemoteModInformation(this.information.name, this.information.fileName);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class CurseAddonFileInformation {
        @JsonProperty
        private String name;
        @JsonProperty
        private String fileName;
        @JsonProperty
        private URL downloadUrl;
        @JsonProperty
        private String[] gameVersion;

        private CurseAddonFileInformation() {
        }
    }
}

