/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.jan.moddirector.core.configuration.modpack.ModpackConfiguration;
import net.jan.moddirector.core.manage.select.InstallSelector;
import net.jan.moddirector.core.ui.page.ModSelectionPage;
import net.jan.moddirector.core.ui.page.ProgressPage;

public class SetupDialog
extends JDialog {
    private static final int HEIGHT = 400;
    private static final int WIDTH = 647;
    private final ModpackConfiguration configuration;
    private final JButton nextButton;
    private CountDownLatch nextLatch;

    public SetupDialog(ModpackConfiguration configuration) {
        this.configuration = configuration;
        this.nextButton = new JButton("Next");
        this.nextButton.addActionListener(e -> this.nextLatch.countDown());
        this.setTitle(configuration.packName());
        this.setSize(647, 400);
    }

    public ProgressPage navigateToProgressPage(String title) {
        ProgressPage page = new ProgressPage(this.configuration, title);
        return this.updateContent(page, false);
    }

    public ModSelectionPage navigateToSelectionPage(InstallSelector installSelector) {
        ModSelectionPage page = new ModSelectionPage(installSelector);
        return this.updateContent(page, true);
    }

    private <T extends JPanel> T updateContent(T newContent, boolean hasNextButton) {
        newContent.setPreferredSize(new Dimension(617, 0));
        newContent.setMaximumSize(new Dimension(617, Integer.MAX_VALUE));
        JPanel wrapperPanel = new JPanel();
        wrapperPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        wrapperPanel.setLayout(new BoxLayout(wrapperPanel, 3));
        JScrollPane scrollPane = new JScrollPane(newContent);
        scrollPane.setSize(647, 370);
        scrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, 345));
        wrapperPanel.add(scrollPane);
        JPanel creditsPanel = new JPanel();
        creditsPanel.setMaximumSize(new Dimension(647, 30));
        creditsPanel.setLayout(new BorderLayout());
        wrapperPanel.add(Box.createVerticalStrut(5));
        creditsPanel.add((Component)new JLabel("Powered by ModDirector"), "West");
        wrapperPanel.add(creditsPanel);
        if (hasNextButton) {
            creditsPanel.add((Component)this.nextButton, "East");
            this.nextButton.setAlignmentX(1.0f);
            this.nextLatch = new CountDownLatch(1);
        } else {
            this.nextLatch = null;
        }
        wrapperPanel.setSize(647, 400);
        this.setContentPane(wrapperPanel);
        this.revalidate();
        return newContent;
    }

    public void waitForNext() throws InterruptedException {
        if (this.nextLatch == null) {
            throw new IllegalStateException("Can't wait for a next press on a page which has no next button");
        }
        this.nextLatch.await();
    }
}

