/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.launchwrapper.forge;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.jan.moddirector.core.ModDirector;
import net.jan.moddirector.core.logging.ModDirectorSeverityLevel;
import net.jan.moddirector.core.manage.ModDirectorError;
import net.jan.moddirector.core.manage.install.InstalledMod;
import net.jan.moddirector.launchwrapper.ModDirectorTweaker;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class ForgeLateLoader {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private final ModDirectorTweaker directorTweaker;
    private final ModDirector director;
    private final LaunchClassLoader classLoader;
    private final List<String> loadedCoremods;
    private final List<ITweaker> modTweakers;
    private List<String> reflectiveIgnoredMods;
    private List<String> reflectiveReparsedCoremods;
    private MethodHandle handleCascadingTweakMethodHandle;
    private MethodHandle loadCoreModMethodHandle;
    private MethodHandle addUrlMethodHandle;
    private MethodHandle sortTweakListMethodHandle;
    private MethodHandle addJarMethodHandle;
    private boolean addJarRequiresAtList;

    public ForgeLateLoader(ModDirectorTweaker directorTweaker, ModDirector director, LaunchClassLoader classLoader) {
        this.directorTweaker = directorTweaker;
        this.director = director;
        this.classLoader = classLoader;
        this.loadedCoremods = new ArrayList<String>();
        this.modTweakers = new ArrayList<ITweaker>();
    }

    public void execute() {
        for (String commandlineCoreMod : System.getProperty("fml.coreMods.load", "").split(",")) {
            if (commandlineCoreMod.isEmpty()) continue;
            this.director.getLogger().log(ModDirectorSeverityLevel.DEBUG, "ModDirector/ForgeLaterLoader", "Launchwrapper", "Ignoring coremod %s which has been loaded on the commandline", commandlineCoreMod);
            this.loadedCoremods.add(commandlineCoreMod);
        }
        if (!this.reflectiveSetup()) {
            return;
        }
        this.director.getLogger().log(ModDirectorSeverityLevel.INFO, "ModDirector/ForgeLateLoader", "Launchwrapper", "Trying to late load %d mods", this.director.getInstalledMods().size());
        this.director.getInstalledMods().forEach(this::handle);
        boolean sortSucceeded = false;
        if (this.sortTweakListMethodHandle != null) {
            List realTweakers = (List)Launch.blackboard.get("Tweaks");
            Launch.blackboard.put("Tweaks", this.modTweakers);
            try {
                this.sortTweakListMethodHandle.invoke();
                sortSucceeded = true;
            }
            catch (Throwable t) {
                this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, "ModDirector/ForgeLateLoader", "Launchwrapper", t, "Error while invoking sortTweakList method", new Object[0]);
            }
            Launch.blackboard.put("Tweaks", realTweakers);
        }
        if (!sortSucceeded) {
            this.director.getLogger().log(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", "Mod tweak list could not be sorted, hoping the best...", new Object[0]);
        }
        Launch.blackboard.put("LateTweakers", this.modTweakers);
        List tweakClasses = (List)Launch.blackboard.get("TweakClasses");
        boolean deobfFound = false;
        for (int i = 0; i < tweakClasses.size(); ++i) {
            if (!((String)tweakClasses.get(i)).endsWith(".FMLDeobfTweaker")) continue;
            this.director.getLogger().log(ModDirectorSeverityLevel.DEBUG, "ModDirector/ForgeLateLoader", "Launchwrapper", "Found deobf tweaker at index %d,adding after deobf tweaker after it", i);
            tweakClasses.add(i + 1, "net.jan.moddirector.launchwrapper.forge.AfterDeobfTweaker");
            deobfFound = true;
        }
        if (!deobfFound) {
            this.director.getLogger().log(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", "Failed to find deobf tweaker, injecting after deobf tweaker at first place", new Object[0]);
            tweakClasses.add(0, "net.jan.moddirector.launchwrapper.forge.AfterDeobfTweaker");
        }
    }

    private boolean reflectiveSetup() {
        Class<?> coreModManagerClass;
        try {
            coreModManagerClass = Class.forName("net.minecraftforge.fml.relauncher.CoreModManager", false, this.getClass().getClassLoader());
            this.director.getLogger().log(ModDirectorSeverityLevel.INFO, "ModDirector/ForgeLateLoader", "Launchwrapper", "Found new CoreModManager at %s!", "net.minecraftforge.fml.relauncher.CoreModManager");
        }
        catch (ClassNotFoundException e) {
            this.director.getLogger().log(ModDirectorSeverityLevel.DEBUG, "ModDirector/ForgeLateLoader", "Launchwrapper", "Unable to find new CoreModManager class, trying old...", new Object[0]);
            try {
                coreModManagerClass = Class.forName("cpw.mods.fml.relauncher.CoreModManager");
            }
            catch (ClassNotFoundException ex) {
                this.director.getLogger().log(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", "Unable to find old CoreModManager class, Forge support disabled!", new Object[0]);
                return false;
            }
            this.director.getLogger().log(ModDirectorSeverityLevel.INFO, "ModDirector/ForgeLateLoader", "Launchwrapper", "Found old CoreModManager at %s!", "net.minecraftforge.fml.relauncher.CoreModManager");
        }
        try {
            Method sortTweakListMethod = this.getMethod(new String[]{"sortTweakList"}, coreModManagerClass, new Class[0]);
            this.sortTweakListMethodHandle = LOOKUP.unreflect(sortTweakListMethod);
        }
        catch (NoSuchMethodException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to find method for sorting tweaks, loading might fail!", new Object[0]);
        }
        catch (IllegalAccessException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to access method for sorting tweaks, loading might fail!", new Object[0]);
        }
        try {
            Method getIgnoredModsMethod = this.getMethod(new String[]{"getIgnoredMods", "getLoadedCoremods"}, coreModManagerClass, new Class[0]);
            this.reflectiveIgnoredMods = (List)getIgnoredModsMethod.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to find method for retrieving ignored mods, loading might fail!", new Object[0]);
            this.reflectiveIgnoredMods = new ArrayList<String>();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to invoke method for retrieving ignored mods, loading might fal!", new Object[0]);
            this.reflectiveIgnoredMods = new ArrayList<String>();
        }
        try {
            Method getReparseableCoremodsMethod = this.getMethod(new String[]{"getReparseableCoremods"}, coreModManagerClass, new Class[0]);
            this.reflectiveReparsedCoremods = (List)getReparseableCoremodsMethod.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to find method for retrieving reparseable coremods, loading might fail!", new Object[0]);
            this.reflectiveReparsedCoremods = new ArrayList<String>();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to invoke method for retrieving reparseable coremods, loading might fal!", new Object[0]);
            this.reflectiveReparsedCoremods = new ArrayList<String>();
        }
        try {
            Method handleCascadingTweakMethod = this.getMethod(new String[]{"handleCascadingTweak"}, coreModManagerClass, File.class, JarFile.class, String.class, LaunchClassLoader.class, Integer.class);
            this.handleCascadingTweakMethodHandle = LOOKUP.unreflect(handleCascadingTweakMethod);
        }
        catch (NoSuchMethodException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to find method for adding tweakers via FML, loading might fail, but trying to fall back to Launchwrapper directly!", new Object[0]);
        }
        catch (IllegalAccessException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to access method for adding tweakers via FML, loading might fail, but trying to fall back to Launchwrapper directly!", new Object[0]);
        }
        try {
            Method loadCoreModMethod = this.getMethod(new String[]{"loadCoreMod"}, coreModManagerClass, LaunchClassLoader.class, String.class, File.class);
            this.loadCoreModMethodHandle = LOOKUP.unreflect(loadCoreModMethod);
        }
        catch (NoSuchMethodException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to find method for loading core mods via FML, loading might fail!", new Object[0]);
        }
        catch (IllegalAccessException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to access method for loading core mods via FML, loading might fail!", new Object[0]);
        }
        Class<?> modAccessTransformerClass = null;
        try {
            modAccessTransformerClass = Class.forName("net.minecraftforge.fml.common.asm.transformers.ModAccessTransformer", false, this.getClass().getClassLoader());
            this.director.getLogger().log(ModDirectorSeverityLevel.INFO, "ModDirector/ForgeLateLoader", "Launchwrapper", "Found new ModAccessTransformer at %s!", modAccessTransformerClass.getName());
        }
        catch (ClassNotFoundException e) {
            this.director.getLogger().log(ModDirectorSeverityLevel.DEBUG, "ModDirector/ForgeLateLoader", "Launchwrapper", "Unable to find new ModAccessTransformer class, trying old...", new Object[0]);
            try {
                modAccessTransformerClass = Class.forName("cpw.mods.fml.common.asm.transformers.ModAccessTransformer", false, this.getClass().getClassLoader());
                this.director.getLogger().log(ModDirectorSeverityLevel.INFO, "ModDirector/ForgeLateLoader", "Launchwrapper", "Found old ModAccessTransformer at %s!", modAccessTransformerClass.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to find ModAccessTransformer class even after trying legacy name. Access transformers for downloaded mods disabled, loading might fail!", new Object[0]);
            }
        }
        if (modAccessTransformerClass != null) {
            try {
                Method addJarMethod = this.getMethod(new String[]{"addJar"}, modAccessTransformerClass, JarFile.class);
                this.addJarMethodHandle = LOOKUP.unreflect(addJarMethod);
                this.addJarRequiresAtList = false;
            }
            catch (NoSuchMethodException e) {
                ReflectiveOperationException secondException = null;
                try {
                    Method addJarMethod = this.getMethod(new String[]{"addJar"}, modAccessTransformerClass, JarFile.class, String.class);
                    this.addJarMethodHandle = LOOKUP.unreflect(addJarMethod);
                    this.addJarRequiresAtList = true;
                }
                catch (IllegalAccessException | NoSuchMethodException second) {
                    secondException = second;
                }
                if (this.addJarMethodHandle == null) {
                    this.director.getLogger().log(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLaterLoader", "Launchwrapper", "Failed to find method for injecting access transformers, loading might fail if they are required!", new Object[0]);
                    this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLaterLoader", "Launchwrapper", e, "\tFailure 1:", new Object[0]);
                    if (secondException != null) {
                        this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLaterLoader", "Launchwrapper", secondException, "\tFailure 2:", new Object[0]);
                    }
                }
            }
            catch (IllegalAccessException e) {
                this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLaterLoader", "Launchwrapper", e, "Failed to access method for injecting access transformers, loading might fail if they are required!", new Object[0]);
            }
        }
        try {
            Method addUrlMethod = this.getMethod(new String[]{"addURL"}, URLClassLoader.class, URL.class);
            this.addUrlMethodHandle = LOOKUP.unreflect(addUrlMethod);
        }
        catch (NoSuchMethodException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to find addUrl method for URLClassLoader (wtf?), loading might fail!", new Object[0]);
        }
        catch (IllegalAccessException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to access addUrl method for URLClassLoader (wtf?), loading might fail!", new Object[0]);
        }
        return true;
    }

    private Method getMethod(String[] possibleNames, Class<?> targetClass, Class<?> ... args) throws NoSuchMethodException {
        Method method = null;
        for (String possibleName : possibleNames) {
            try {
                method = targetClass.getDeclaredMethod(possibleName, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (method == null) {
            throw new NoSuchMethodException("Failed to find method using names [" + String.join((CharSequence)", ", possibleNames) + "] on class " + targetClass.getName());
        }
        method.setAccessible(true);
        return method;
    }

    private void handle(InstalledMod mod) {
        block26: {
            Path injectedFile = mod.getFile();
            if (!mod.shouldInject()) {
                return;
            }
            this.reflectiveIgnoredMods.remove(injectedFile.toFile().getName());
            try (JarFile jar = new JarFile(injectedFile.toFile());){
                Manifest manifest = jar.getManifest();
                if (manifest != null) {
                    Attributes attributes = manifest.getMainAttributes();
                    this.injectAccessTransformers(jar, manifest);
                    String tweakClass = attributes.getValue("TweakClass");
                    if (tweakClass != null) {
                        int tweakOrder = 0;
                        String tweakOrderString = attributes.getValue("TweakOrder");
                        if (tweakOrderString != null) {
                            try {
                                tweakOrder = Integer.parseInt(tweakOrderString);
                            }
                            catch (NumberFormatException e) {
                                this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to parse tweak order for %s", injectedFile.toString());
                            }
                        }
                        this.injectTweaker(injectedFile, jar, tweakClass, tweakOrder, mod.getOptionBoolean("launchwrapperTweakerForceNext", false));
                        return;
                    }
                    String corePlugin = attributes.getValue("FMLCorePlugin");
                    if (corePlugin != null) {
                        this.injectCorePlugin(injectedFile, corePlugin);
                        if (attributes.getValue("FMLCorePluginContainsFMLMod") != null) {
                            this.addReparseableJar(injectedFile);
                        } else {
                            this.addLoadedCoreMod(injectedFile);
                        }
                    }
                    break block26;
                }
                this.director.getLogger().log(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", "Downloaded file %s has no manifest!", injectedFile.toString());
            }
            catch (IOException e) {
                this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to open indexed file %s as jar, ignoring", injectedFile.toString());
            }
        }
    }

    private void addReparseableJar(Path injectedFile) {
        String fileName = injectedFile.toFile().getName();
        if (!this.reflectiveReparsedCoremods.contains(fileName)) {
            this.reflectiveReparsedCoremods.add(fileName);
            this.director.getLogger().log(ModDirectorSeverityLevel.DEBUG, "ModDirector/ForgeLateLoader", "Launchwrapper", "Marked %s as reparseable coremod", injectedFile.toString());
        }
    }

    private void addLoadedCoreMod(Path injectedFile) {
        String filename = injectedFile.toFile().getName();
        if (!this.reflectiveIgnoredMods.contains(filename)) {
            this.reflectiveIgnoredMods.add(filename);
            this.director.getLogger().log(ModDirectorSeverityLevel.DEBUG, "ModDirector/ForgeLateLoader", "Launchwrapper", "Marked %s as loaded coremod", injectedFile.toString());
        }
    }

    private void injectTweaker(Path injectedFile, JarFile jar, String tweakerClass, Integer sortingOrder, boolean forceNext) {
        URL fileUrl = null;
        try {
            fileUrl = injectedFile.toUri().toURL();
        }
        catch (MalformedURLException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to convert path to url, loading might fail!", new Object[0]);
        }
        if (fileUrl != null) {
            try {
                this.addUrlMethodHandle.invoke(this.classLoader.getClass().getClassLoader(), fileUrl);
                this.classLoader.addURL(fileUrl);
            }
            catch (Throwable e) {
                this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to inject tweaker url into ClassLoader, loading might fail!", new Object[0]);
            }
        }
        if (forceNext) {
            this.director.getLogger().log(ModDirectorSeverityLevel.INFO, "ModDirector/ForgeLateLoader", "Launchwrapper", "Late injecting tweaker %s from %s, forcing it to be called next!", tweakerClass, injectedFile.toString());
            try {
                ITweaker tweaker = (ITweaker)Class.forName(tweakerClass, true, (ClassLoader)this.classLoader).newInstance();
                this.classLoader.addClassLoaderExclusion(tweakerClass.substring(0, tweakerClass.lastIndexOf(46)));
                this.directorTweaker.callInjectedTweaker(tweaker);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to manually load tweaker so it can be injected next, falling back to Forge!", new Object[0]);
                forceNext = false;
            }
        }
        if (forceNext) {
            return;
        }
        boolean injectionSucceeded = false;
        if (this.handleCascadingTweakMethodHandle != null) {
            this.director.getLogger().log(ModDirectorSeverityLevel.INFO, "ModDirector/ForgeLateLoader", "Launchwrapper", "Late injecting tweaker %s from %s using FML", tweakerClass, injectedFile.toString());
            try {
                this.handleCascadingTweakMethodHandle.invoke(injectedFile.toFile(), jar, tweakerClass, this.classLoader, sortingOrder);
                injectionSucceeded = true;
            }
            catch (Throwable e) {
                this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Error while injecting tweaker via FML, falling back to Launchwrapper's own mechanism!", new Object[0]);
            }
        }
        if (!injectionSucceeded) {
            this.director.getLogger().log(ModDirectorSeverityLevel.INFO, "ModDirector/ForgeLateLoader", "Launchwrapper", "Late injecting tweaker %s from %s using Launchwrapper", tweakerClass, injectedFile.toString());
            ((List)Launch.blackboard.get("TweakClasses")).add(tweakerClass);
        }
    }

    private void injectCorePlugin(Path injectedFile, String coreModClass) {
        if (this.loadedCoremods.contains(coreModClass)) {
            this.director.getLogger().log(ModDirectorSeverityLevel.DEBUG, "ModDirector/ForgeLateLoader", "Launchwrapper", "Not injecting core plugin %s from %s because it has already been!", coreModClass, injectedFile.toString());
            return;
        }
        this.director.getLogger().log(ModDirectorSeverityLevel.INFO, "ModDirector/ForgeLateLoader", "Launchwrapper", "Now injecting core plugin %s from %s", coreModClass, injectedFile.toString());
        try {
            this.classLoader.addURL(injectedFile.toUri().toURL());
            Object ret = this.loadCoreModMethodHandle.invoke(this.classLoader, coreModClass, injectedFile.toFile());
            if (ret instanceof ITweaker) {
                this.modTweakers.add((ITweaker)ret);
            }
        }
        catch (Throwable e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, "ModDirector/ForgeLateLoader", "Launchwrapper", e, "Failed to inject core plugin!", new Object[0]);
            this.director.addError(new ModDirectorError(ModDirectorSeverityLevel.ERROR, "Failed to inject core plugin!", e));
        }
    }

    private void injectAccessTransformers(JarFile jar, Manifest manifest) {
        if (this.addJarMethodHandle != null) {
            try {
                this.director.getLogger().log(ModDirectorSeverityLevel.DEBUG, "ModDirector/ForgeLateLoader", "Launchwrapper", "Added %s to possible access transformers", jar.getName());
                if (this.addJarRequiresAtList) {
                    String ats = manifest.getMainAttributes().getValue("FMLAT");
                    if (ats != null && !ats.isEmpty()) {
                        this.addJarMethodHandle.invoke(jar, ats);
                    }
                } else {
                    this.addJarMethodHandle.invoke(jar);
                }
            }
            catch (Throwable t) {
                this.director.getLogger().logThrowable(ModDirectorSeverityLevel.WARN, "ModDirector/ForgeLateLoader", "Launchwrapper", t, "Failed to add jar to access transformers", new Object[0]);
            }
        }
    }
}

