/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts.components;

import com.draco18s.artifacts.DragonArtifacts;
import com.draco18s.artifacts.components.BaseComponent;
import com.draco18s.artifacts.network.CToSMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ComponentMusicPlayer
extends BaseComponent {
    @Override
    public String getRandomTrigger(Random rand, boolean isArmor) {
        if (!isArmor) {
            return "onItemRightClick";
        }
        return "";
    }

    @Override
    public ItemStack attached(ItemStack i, Random rand, int[] eff) {
        ArrayList<ItemRecord> recordList = new ArrayList<ItemRecord>();
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof ItemRecord)) continue;
            recordList.add((ItemRecord)item);
        }
        if (recordList.size() > 0) {
            String record = ((ItemRecord)recordList.get((int)rand.nextInt((int)recordList.size()))).field_150929_a;
            i.func_77978_p().func_74778_a("record", record);
        } else {
            System.out.println("No records?!?");
        }
        return i;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player) {
        NBTTagCompound tag = itemStack.func_77978_p();
        String record = tag.func_74779_i("record");
        boolean shouldPlay = !tag.func_74767_n("playing");
        int x = tag.func_74762_e("playingX");
        int y = tag.func_74762_e("playingY");
        int z = tag.func_74762_e("playingZ");
        if (shouldPlay) {
            x = MathHelper.func_76128_c((double)player.field_70165_t);
            y = MathHelper.func_76128_c((double)player.field_70163_u);
            z = MathHelper.func_76128_c((double)player.field_70161_v);
        }
        tag.func_74757_a("playing", shouldPlay);
        PacketBuffer out = new PacketBuffer(Unpooled.buffer());
        out.writeInt(30);
        out.writeInt(x);
        out.writeInt(y);
        out.writeInt(z);
        out.writeBoolean(shouldPlay);
        out.writeInt(player.field_71071_by.field_70461_c);
        if (shouldPlay) {
            out.writeInt(record.length());
            for (int i = 0; i < record.length(); ++i) {
                out.writeChar((int)record.charAt(i));
            }
        }
        CToSMessage packet = new CToSMessage((ByteBuf)out);
        DragonArtifacts.artifactNetworkWrapper.sendToServer((IMessage)packet);
        tag.func_74768_a("onItemRightClickDelay", 10);
        return itemStack;
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, String trigger, boolean advTooltip) {
        String play = StatCollector.func_74838_a((String)"effect.Play");
        if (play.equals("{Play}")) {
            play = "" + EnumChatFormatting.GREEN + '\u266a' + EnumChatFormatting.LIGHT_PURPLE + '\u266b' + EnumChatFormatting.GOLD + '\u266a';
        }
        String recordDescription = "Unknown";
        ItemRecord record = ItemRecord.func_150926_b((String)("records." + itemStack.func_77978_p().func_74779_i("record")));
        if (record != null) {
            recordDescription = record.func_150927_i();
        }
        list.add(StatCollector.func_74838_a((String)"effect.Plays the record") + " " + recordDescription + " " + StatCollector.func_74838_a((String)("tool." + trigger)) + " " + (itemStack.func_77978_p().func_74767_n("playing") ? play : ""));
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean advTooltip) {
        list.add(StatCollector.func_74838_a((String)"effect.Plays the record") + " " + StatCollector.func_74838_a((String)("item.record." + itemStack.func_77978_p().func_74779_i("record") + ".desc")) + ".");
    }

    @Override
    public String getPreAdj(Random rand) {
        String str = "";
        switch (rand.nextInt(2)) {
            case 0: {
                str = "Musical";
                break;
            }
            case 1: {
                str = "Harmonious";
            }
        }
        return str;
    }

    @Override
    public String getPostAdj(Random rand) {
        String str = "";
        switch (rand.nextInt(2)) {
            case 0: {
                str = "of Tunes";
                break;
            }
            case 1: {
                str = "of Music";
            }
        }
        return str;
    }

    @Override
    public int getTextureBitflags() {
        return 221;
    }

    @Override
    public int getNegTextureBitflags() {
        return 7936;
    }
}

