/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts.entity;

import com.draco18s.artifacts.entity.ArrowEffect;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntitySpecialArrow
extends EntityArrow {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile = null;
    private int inData = 0;
    private boolean inGround = false;
    private int ticksInGround = 0;
    private int ticksInAir = 0;
    private float knockbackStrength = 0.0f;
    public ArrowEffect effect = ArrowEffect.DEFAULT;

    public EntitySpecialArrow(World world) {
        super(world);
    }

    public EntitySpecialArrow(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntitySpecialArrow(World world, double x, double y, double z, double damage) {
        super(world, x, y, z);
        this.func_70239_b(damage);
    }

    public EntitySpecialArrow(World world, EntityLivingBase shooter, EntityLivingBase target, float power, float variance) {
        super(world, shooter, target, power, variance);
    }

    public EntitySpecialArrow(World world, EntityLivingBase shooter, EntityLivingBase target, float power, float variance, double damage) {
        super(world, shooter, target, power, variance);
        this.func_70239_b(damage);
    }

    public EntitySpecialArrow(World world, EntityLivingBase shooter, float power) {
        super(world, shooter, power);
    }

    public EntitySpecialArrow(World world, EntityLivingBase shooter, float power, double damage) {
        super(world, shooter, power);
        this.func_70239_b(damage);
    }

    public EntitySpecialArrow(World world, EntityLivingBase shooter, EntityLivingBase target, float power, float variance, ArrowEffect fx) {
        super(world, shooter, target, power, variance);
        this.effect = fx;
        this.setStatsByEffect();
    }

    public EntitySpecialArrow(World world, EntityLivingBase shooter, EntityLivingBase target, float power, float variance, double damage, ArrowEffect fx) {
        super(world, shooter, target, power, variance);
        this.func_70239_b(damage);
        this.effect = fx;
        this.setStatsByEffect();
    }

    public EntitySpecialArrow(World world, EntityLivingBase shooter, float power, ArrowEffect fx) {
        super(world, shooter, power);
        this.effect = fx;
        this.setStatsByEffect();
    }

    public EntitySpecialArrow(World world, EntityLivingBase shooter, float power, double damage, ArrowEffect fx) {
        super(world, shooter, power);
        this.func_70239_b(damage);
        this.effect = fx;
        this.setStatsByEffect();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)"");
    }

    public void func_70071_h_() {
        Block block;
        this.func_70030_z();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var1) * 180.0 / Math.PI);
        }
        if ((block = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile)) != Blocks.field_150350_a) {
            block.func_149719_a((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB var2 = block.func_149668_a(this.field_70170_p, this.xTile, this.yTile, this.zTile);
            if (var2 != null && var2.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.inGround = true;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.inGround) {
            Block blockInside = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
            int metaInside = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
            if (blockInside == this.inTile && metaInside == this.inData) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                }
            } else {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            int var9;
            ++this.ticksInAir;
            Vec3 posVector = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 newPosVector = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition moPos = this.field_70170_p.func_147447_a(posVector, newPosVector, false, true, false);
            posVector = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            newPosVector = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (moPos != null) {
                newPosVector = Vec3.func_72443_a((double)moPos.field_72307_f.field_72450_a, (double)moPos.field_72307_f.field_72448_b, (double)moPos.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List entityList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double var7 = 0.0;
            for (var9 = 0; var9 < entityList.size(); ++var9) {
                double var14;
                float var11;
                AxisAlignedBB var12;
                MovingObjectPosition var13;
                Entity var10 = (Entity)entityList.get(var9);
                if (!var10.func_70067_L() || var10 == this.field_70250_c && this.ticksInAir < 5 || (var13 = (var12 = var10.field_70121_D.func_72314_b((double)(var11 = 0.3f), (double)var11, (double)var11)).func_72327_a(posVector, newPosVector)) == null || !((var14 = posVector.func_72438_d(var13.field_72307_f)) < var7) && var7 != 0.0) continue;
                entity = var10;
                var7 = var14;
            }
            if (entity != null) {
                moPos = new MovingObjectPosition(entity);
            }
            if (moPos != null) {
                if (moPos.field_72308_g != null) {
                    float var20 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    int var23 = MathHelper.func_76143_f((double)((double)var20 * this.func_70242_d() * 1.5));
                    if (this.func_70241_g()) {
                        var23 += this.field_70146_Z.nextInt(var23 / 2 + 2);
                    }
                    DamageSource var21 = null;
                    var21 = this.field_70250_c == null ? DamageSource.func_76353_a((EntityArrow)this, (Entity)this) : DamageSource.func_76353_a((EntityArrow)this, (Entity)this.field_70250_c);
                    if (this.func_70027_ad() && !(moPos.field_72308_g instanceof EntityEnderman)) {
                        moPos.field_72308_g.func_70015_d(5);
                    }
                    if (this.shouldDamage(moPos.field_72308_g)) {
                        moPos.field_72308_g.field_70172_ad = 0;
                        if (moPos.field_72308_g.func_70097_a(var21, (float)var23)) {
                            this.hitEffect(moPos.field_72308_g);
                            if (moPos.field_72308_g instanceof EntityLivingBase) {
                                float var26;
                                EntityLivingBase entityLivingBase = (EntityLivingBase)moPos.field_72308_g;
                                if (!this.field_70170_p.field_72995_K) {
                                    entityLivingBase.func_85034_r(entityLivingBase.func_85035_bI() + 1);
                                }
                                if (this.knockbackStrength > 0.0f && (var26 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                                    moPos.field_72308_g.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * 0.6 / (double)var26, 0.1, this.field_70179_y * (double)this.knockbackStrength * 0.6 / (double)var26);
                                }
                                if (this.field_70250_c != null) {
                                    EnchantmentHelper.func_151384_a((EntityLivingBase)entityLivingBase, (Entity)this.field_70250_c);
                                    EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (Entity)entityLivingBase);
                                }
                                if (this.field_70250_c != null && moPos.field_72308_g != this.field_70250_c && moPos.field_72308_g instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                                    ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
                                }
                            }
                            this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                            if (!(moPos.field_72308_g instanceof EntityEnderman)) {
                                this.func_70106_y();
                            }
                        }
                    } else {
                        this.field_70159_w *= -0.1;
                        this.field_70181_x *= -0.1;
                        this.field_70179_y *= -0.1;
                        this.field_70177_z += 180.0f;
                        this.field_70126_B += 180.0f;
                        this.ticksInAir = 0;
                    }
                } else {
                    this.xTile = moPos.field_72311_b;
                    this.yTile = moPos.field_72312_c;
                    this.zTile = moPos.field_72309_d;
                    this.inTile = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
                    this.inData = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
                    this.missEffect(this.xTile, this.yTile, this.zTile);
                    this.field_70159_w = (float)(moPos.field_72307_f.field_72450_a - this.field_70165_t);
                    this.field_70181_x = (float)(moPos.field_72307_f.field_72448_b - this.field_70163_u);
                    this.field_70179_y = (float)(moPos.field_72307_f.field_72449_c - this.field_70161_v);
                    float var20 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    this.field_70165_t -= this.field_70159_w / (double)var20 * 0.05;
                    this.field_70163_u -= this.field_70181_x / (double)var20 * 0.05;
                    this.field_70161_v -= this.field_70179_y / (double)var20 * 0.05;
                    this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    this.inGround = true;
                    this.field_70249_b = 7;
                    this.func_70243_d(false);
                    if (this.inTile != Blocks.field_150350_a) {
                        this.inTile.func_149670_a(this.field_70170_p, this.xTile, this.yTile, this.zTile, (Entity)this);
                    }
                }
            }
            if (this.func_70241_g()) {
                for (var9 = 0; var9 < 4; ++var9) {
                    this.field_70170_p.func_72869_a("crit", this.field_70165_t + this.field_70159_w * (double)var9 / 4.0, this.field_70163_u + this.field_70181_x * (double)var9 / 4.0, this.field_70161_v + this.field_70179_y * (double)var9 / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float var20 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var20) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float var22 = 0.99f;
            float var11 = 0.05f;
            if (this.func_70090_H()) {
                for (int var25 = 0; var25 < 4; ++var25) {
                    float var26 = 0.25f;
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)var26, this.field_70163_u - this.field_70181_x * (double)var26, this.field_70161_v - this.field_70179_y * (double)var26, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                var22 = 0.8f;
            }
            this.field_70159_w *= (double)var22;
            this.field_70181_x *= (double)var22;
            this.field_70179_y *= (double)var22;
            this.field_70181_x -= (double)var11;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    public boolean shouldDamage(Entity entity) {
        return entity != this.field_70250_c;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74777_a("xTile", (short)this.xTile);
        tag.func_74777_a("yTile", (short)this.yTile);
        tag.func_74777_a("zTile", (short)this.zTile);
        tag.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inTile));
        tag.func_74774_a("inData", (byte)this.inData);
        tag.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        tag.func_74774_a("effect", this.effect.ID);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.xTile = tag.func_74765_d("xTile");
        this.yTile = tag.func_74765_d("yTile");
        this.zTile = tag.func_74765_d("zTile");
        this.inTile = Block.func_149729_e((int)(tag.func_74771_c("inTile") & 0xFF));
        this.inData = tag.func_74771_c("inData") & 0xFF;
        this.inGround = tag.func_74771_c("inGround") == 1;
        this.effect = ArrowEffect.get(tag.func_74771_c("effect"));
    }

    public void setKnockbackStrength(float strength) {
        this.knockbackStrength = strength;
    }

    public void setStatsByEffect() {
        switch (this.effect.ID) {
            case 0: {
                this.func_70240_a(1);
                break;
            }
            case 1: {
                this.func_70240_a(0);
            }
        }
    }

    public void hitEffect(Entity entityHit) {
        switch (this.effect.ID) {
            case 1: {
                Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f);
                explosion.func_77278_a();
                explosion.func_77279_a(true);
            }
        }
    }

    public void missEffect(int x, int y, int z) {
        switch (this.effect.ID) {
            case 1: {
                Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f);
                explosion.func_77278_a();
                explosion.func_77279_a(true);
                this.func_70106_y();
            }
        }
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.field_70170_p.field_72995_K && this.inGround && this.field_70249_b <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == 1 || this.field_70251_a == 2 && par1EntityPlayer.field_71075_bZ.field_75098_d;
            if (this.field_70251_a == 1 && !par1EntityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151032_g, 1))) {
                flag = false;
            }
            if (flag) {
                this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                par1EntityPlayer.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }
}

