/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.draco18s.artifacts.DragonArtifacts;
import com.draco18s.artifacts.api.ArtifactsAPI;
import com.draco18s.artifacts.api.IItemIconAPI;
import com.draco18s.artifacts.api.interfaces.IArtifactComponent;
import com.draco18s.artifacts.item.ItemOrichalcumDust;
import com.draco18s.artifacts.network.CToSMessage;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemArtifact
extends Item
implements IBauble {
    public static Item instance;
    private float weaponDamage;
    public static boolean doEnchName;
    public static boolean doMatName;
    public static boolean doAdjName;

    public ItemArtifact() {
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.weaponDamage = 0.0f;
        this.func_77656_e(128);
        this.func_77637_a(DragonArtifacts.tabArtifacts);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        list.add(new ItemStack(instance));
        for (int i = 0; i < 8; ++i) {
            list.add(ArtifactsAPI.artifacts.generateRandomArtifact());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        ItemStack itemStack = Minecraft.func_71410_x().field_71439_g.func_71045_bC();
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemArtifact && itemStack.field_77990_d != null) {
            String type = itemStack.func_77978_p().func_74779_i("iconName");
            return type.equals("Sword") || type.equals("Dagger") || type.equals("Staff") || type.equals("Wand");
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconReg) {
        this.field_77791_bV = ArtifactsAPI.itemicons.registerIcons(iconReg);
    }

    public boolean func_77623_v() {
        return true;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        IIcon i = this.field_77791_bV;
        if (pass == 0) {
            if (stack.field_77990_d == null) {
                return this.field_77791_bV;
            }
            i = (IIcon)IItemIconAPI.icons.get(stack.field_77990_d.func_74779_i("icon").toLowerCase());
            if (i == null) {
                i = this.field_77791_bV;
            }
        } else {
            if (stack.field_77990_d == null) {
                return (IIcon)IItemIconAPI.icons.get("overlay_artifact1");
            }
            i = (IIcon)IItemIconAPI.icons.get("overlay_" + stack.field_77990_d.func_74779_i("icon").toLowerCase());
            if (i == null) {
                i = (IIcon)IItemIconAPI.icons.get("overlay_artifact1");
            }
        }
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int pass) {
        if (pass == 0) {
            return 0xFFFFFF;
        }
        if (par1ItemStack.field_77990_d != null) {
            return (int)par1ItemStack.field_77990_d.func_74763_f("overlay_color");
        }
        return 255;
    }

    public int getMaxDamage(ItemStack stack) {
        float base = 1.0f;
        if (stack.field_77990_d != null) {
            base = stack.field_77990_d.func_74762_e("material") / 2;
            base = base == 2.0f ? (base += 5.0f) : (float)((double)base + 7.5);
        }
        return (int)(Math.pow(2.0, base) - 1.0);
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        IArtifactComponent c;
        NBTTagCompound data = item.func_77978_p();
        int effectID = 0;
        if (data != null && (effectID = data.func_74762_e("onDroppedByPlayer")) != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
            return c.onDroppedByPlayer(item, player);
        }
        return true;
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return armorType == stack.field_77990_d.func_74762_e("armorType");
    }

    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack) {
        this.func_77663_a(itemStack, world, (Entity)player, 0, false);
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        return false;
    }

    public float getDigSpeed(ItemStack itemStack, Block block, int meta) {
        NBTTagCompound data = itemStack.func_77978_p();
        boolean effectID = false;
        if (data != null) {
            int[] ca = data.func_74759_k("allComponents");
            float r = 0.0f;
            float y = 0.0f;
            for (int i = ca.length - 1; i >= 0; --i) {
                if (ca[i] == 0) continue;
                IArtifactComponent c = ArtifactsAPI.artifacts.getComponent(ca[i]);
                if (c != null) {
                    y = c.getDigSpeed(itemStack, block, meta);
                }
                if (!(y > r)) continue;
                r = y;
            }
            if (r > 0.0f) {
                return r;
            }
        }
        return 0.25f;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        int d;
        NBTTagCompound data = itemStack.func_77978_p();
        int effectID = 0;
        if (data != null && world.field_72995_K && (effectID = data.func_74762_e("onItemRightClick")) != 0 && (d = data.func_74762_e("onItemRightClickDelay")) <= 0) {
            IArtifactComponent c = ArtifactsAPI.artifacts.getComponent(effectID);
            if (c != null) {
                itemStack = c.onItemRightClick(itemStack, world, player);
            }
            d = itemStack.field_77990_d.func_74762_e("onItemRightClickDelay");
            PacketBuffer out = new PacketBuffer(Unpooled.buffer());
            out.writeInt(4096);
            out.writeInt(d);
            out.writeInt(player.field_71071_by.field_70461_c);
            CToSMessage packet = new CToSMessage((ByteBuf)out);
            DragonArtifacts.artifactNetworkWrapper.sendToServer((IMessage)packet);
        }
        return itemStack;
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase entityVictim, EntityLivingBase entityAttacker) {
        NBTTagCompound data = itemStack.func_77978_p();
        int effectID = 0;
        if (data != null) {
            effectID = data.func_74762_e("hitEntity");
            if (effectID != 0) {
                IArtifactComponent c = ArtifactsAPI.artifacts.getComponent(effectID);
                boolean r = false;
                if (c != null) {
                    r = c.hitEntity(itemStack, entityVictim, entityAttacker);
                }
                itemStack.func_77972_a(1, entityVictim);
                return r;
            }
            NBTTagList tagList = data.func_150295_c("AttributeModifiers", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                if (!tagList.func_150305_b(i).func_74779_i("AttributeName").equals("generic.attackDamage")) continue;
                itemStack.func_77972_a(1, entityVictim);
                break;
            }
        }
        return false;
    }

    public boolean func_150894_a(ItemStack itemStack, World world, Block block, int x, int y, int z, EntityLivingBase entityLivingBase) {
        NBTTagCompound data = itemStack.func_77978_p();
        int effectID = 0;
        if (data != null && !world.field_72995_K) {
            IArtifactComponent c;
            effectID = data.func_74762_e("onBlockDestroyed");
            if (effectID != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                return c.onBlockDestroyed(itemStack, world, block, x, y, z, entityLivingBase);
            }
            effectID = data.func_74762_e("onDig");
            if (effectID != 0) {
                c = ArtifactsAPI.artifacts.getComponent(effectID);
                if (c != null) {
                    return c.onBlockDestroyed(itemStack, world, block, x, y, z, entityLivingBase);
                }
            } else if (this.canHarvestBlock(block, itemStack)) {
                itemStack.func_77972_a(1, entityLivingBase);
            } else {
                itemStack.func_77972_a(2, entityLivingBase);
            }
        }
        return false;
    }

    public boolean canHarvestBlock(Block block, ItemStack itemStack) {
        NBTTagCompound data = itemStack.func_77978_p();
        boolean effectID = false;
        if (data != null) {
            int[] ca = data.func_74759_k("allComponents");
            boolean r = false;
            for (int i = ca.length - 1; i >= 0; --i) {
                IArtifactComponent c;
                if (ca[i] == 0 || (c = ArtifactsAPI.artifacts.getComponent(ca[i])) == null) continue;
                r = r || c.canHarvestBlock(block, itemStack);
            }
        }
        return false;
    }

    public boolean func_111207_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, EntityLivingBase par3EntityLivingBase) {
        IArtifactComponent c;
        NBTTagCompound data = par1ItemStack.func_77978_p();
        int effectID = 0;
        if (data != null && (effectID = data.func_74762_e("itemInteractionForEntity")) != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
            return c.itemInteractionForEntity(par1ItemStack, par2EntityPlayer, par3EntityLivingBase);
        }
        return false;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        ItemStack stack = entityItem.func_92059_d();
        NBTTagCompound data = stack.field_77990_d;
        World par2World = entityItem.field_70170_p;
        int effectID = 0;
        if (data != null && entityItem.field_70292_b % 15 == 0 && !par2World.field_72995_K) {
            IArtifactComponent c;
            int del;
            IArtifactComponent c2;
            effectID = data.func_74762_e("onUpdate");
            if (effectID != 0 && (c2 = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                c2.onEntityItemUpdate(entityItem, "onUpdate");
            }
            if ((effectID = data.func_74762_e("onEntityItemUpdate")) != 0 && (c2 = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                c2.onEntityItemUpdate(entityItem, "onEntityItemUpdate");
            }
            if ((effectID = data.func_74762_e("onDropped")) != 0 && (del = data.func_74762_e("droppedDelay")) <= entityItem.field_70292_b && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                c.onEntityItemUpdate(entityItem, "onDropped");
            }
            ArrayList<String> keys = ArtifactsAPI.artifacts.getNBTKeys();
            String kk = "";
            int n = 0;
            for (int k = keys.size() - 1; k >= 0; --k) {
                kk = keys.get(k) + "_dropped";
                if (!data.func_74764_b(kk)) continue;
                n = data.func_74762_e(kk);
                if (n > 0) {
                    --n;
                }
                data.func_74768_a(kk, n);
            }
        }
        return false;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int slot, boolean held) {
        NBTTagCompound data = itemStack.field_77990_d;
        int effectID = 0;
        if (data != null) {
            if (!world.field_72995_K) {
                int d;
                IArtifactComponent c;
                if (itemStack.field_77990_d.func_74779_i("matName").length() <= 0) {
                    itemStack.field_77990_d = null;
                    return;
                }
                effectID = data.func_74762_e("onUpdate");
                if (effectID != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                    c.onUpdate(itemStack, world, entity, slot, held);
                }
                if ((effectID = data.func_74762_e("onHeld")) != 0 && held && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                    c.onHeld(itemStack, world, entity, slot, held);
                }
                d = (d = data.func_74762_e("onItemRightClickDelay")) > 0 ? --d : 0;
                data.func_74768_a("onItemRightClickDelay", d);
                ArrayList<String> keys = ArtifactsAPI.artifacts.getNBTKeys();
                String kk = "";
                int n = 0;
                for (int k = keys.size() - 1; k >= 0; --k) {
                    kk = keys.get(k);
                    if (!data.func_74764_b(kk)) continue;
                    n = data.func_74762_e(kk);
                    if (n > 0) {
                        --n;
                    }
                    data.func_74768_a(kk, n);
                }
            }
        } else if (!world.field_72995_K) {
            itemStack = ArtifactsAPI.artifacts.applyRandomEffects(itemStack);
        }
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.none;
    }

    public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
    }

    public Multimap getAttributeModifiers(ItemStack itemStack) {
        Multimap multimap = super.getAttributeModifiers(itemStack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.weaponDamage, 0));
        return multimap;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean advTooltip) {
        NBTTagCompound data = par1ItemStack.func_77978_p();
        int effectID = 0;
        if (data != null) {
            IArtifactComponent c;
            effectID = data.func_74762_e("onItemRightClick");
            if (effectID != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                c.addInformation(par1ItemStack, par2EntityPlayer, par3List, "when used.", advTooltip);
            }
            if ((effectID = data.func_74762_e("hitEntity")) != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                c.addInformation(par1ItemStack, par2EntityPlayer, par3List, "when inflicting damage.", advTooltip);
            }
            if ((effectID = data.func_74762_e("onUpdate")) != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                c.addInformation(par1ItemStack, par2EntityPlayer, par3List, "passively.", advTooltip);
            }
            if ((effectID = data.func_74762_e("onEntityItemUpdate")) != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                c.addInformation(par1ItemStack, par2EntityPlayer, par3List, "passively.", advTooltip);
            }
            if ((effectID = data.func_74762_e("onBlockDestroyed")) != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                c.addInformation(par1ItemStack, par2EntityPlayer, par3List, "when destroying blocks.", advTooltip);
            }
            if ((effectID = data.func_74762_e("itemInteractionForEntity")) != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                c.addInformation(par1ItemStack, par2EntityPlayer, par3List, "when interacting with entities.", advTooltip);
            }
            if ((effectID = data.func_74762_e("onDig")) != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                c.addInformation(par1ItemStack, par2EntityPlayer, par3List, advTooltip);
            }
            if ((effectID = data.func_74762_e("onDroppedByPlayer")) != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                c.addInformation(par1ItemStack, par2EntityPlayer, par3List, "when dropped.", advTooltip);
            }
            if ((effectID = data.func_74762_e("onDropped")) != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                c.addInformation(par1ItemStack, par2EntityPlayer, par3List, "when dropped.", advTooltip);
            }
            if ((effectID = data.func_74762_e("onHeld")) != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                c.addInformation(par1ItemStack, par2EntityPlayer, par3List, "when held.", advTooltip);
            }
        } else {
            par3List.add(StatCollector.func_74838_a((String)"tool.All tools, swords, etc."));
        }
    }

    public String func_77653_i(ItemStack itemStack) {
        String n = "";
        if (itemStack.field_77990_d != null) {
            if (doEnchName && itemStack.field_77990_d.func_74779_i("enchName").length() > 0) {
                n = n + StatCollector.func_74838_a((String)itemStack.field_77990_d.func_74779_i("enchName")) + " ";
            }
            if (doAdjName && itemStack.field_77990_d.func_74779_i("preadj").length() > 0) {
                n = n + StatCollector.func_74838_a((String)("pre." + itemStack.field_77990_d.func_74779_i("preadj"))) + " ";
            }
            if (doMatName) {
                n = n + StatCollector.func_74838_a((String)("mat." + itemStack.field_77990_d.func_74779_i("matName"))) + " ";
            }
            if (!(doEnchName || doMatName || doAdjName)) {
                n = n + StatCollector.func_74838_a((String)"type.Artifact") + " ";
            }
            n = n + StatCollector.func_74838_a((String)("type." + itemStack.field_77990_d.func_74779_i("iconName")));
            if (doAdjName && itemStack.field_77990_d.func_74779_i("postadj").length() > 0) {
                n = n + " " + StatCollector.func_74838_a((String)("post." + itemStack.field_77990_d.func_74779_i("postadj")));
            }
        }
        if (n.length() < 1) {
            n = StatCollector.func_74838_a((String)"type.Artifact");
        }
        return n;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        if (par1ItemStack.func_77973_b() == par2ItemStack.func_77973_b()) {
            return false;
        }
        if (par2ItemStack.func_77973_b() instanceof ItemOrichalcumDust) {
            return par2ItemStack.func_77960_j() - 1 == par1ItemStack.field_77990_d.func_74762_e("material");
        }
        return false;
    }

    public int getHarvestLevel(ItemStack itemStack, String toolClass) {
        NBTTagCompound data = itemStack.func_77978_p();
        boolean effectID = false;
        int r = -1;
        if (data != null) {
            int[] ca = data.func_74759_k("allComponents");
            for (int i = ca.length - 1; i >= 0; --i) {
                if (ca[i] == 0) continue;
                int temp = 0;
                IArtifactComponent c = ArtifactsAPI.artifacts.getComponent(ca[i]);
                if (c != null) {
                    temp = c.getHarvestLevel(itemStack, toolClass);
                }
                if (temp <= r) continue;
                r = temp;
            }
        }
        return r;
    }

    @Override
    public BaubleType getBaubleType(ItemStack itemStack) {
        if (itemStack.field_77990_d != null) {
            String type = itemStack.field_77990_d.func_74779_i("iconName");
            if (type.equals("Ring")) {
                return BaubleType.RING;
            }
            if (type.equals("Amulet")) {
                return BaubleType.AMULET;
            }
            if (type.equals("Belt")) {
                return BaubleType.BELT;
            }
        }
        return null;
    }

    @Override
    public void onWornTick(ItemStack itemStack, EntityLivingBase player) {
        NBTTagCompound data = itemStack.field_77990_d;
        int effectID = 0;
        if (data != null) {
            if (!player.field_70170_p.field_72995_K) {
                int d;
                IArtifactComponent c;
                if (itemStack.field_77990_d.func_74779_i("matName").length() <= 0) {
                    itemStack.field_77990_d = null;
                    return;
                }
                effectID = data.func_74762_e("onUpdate");
                if (effectID != 0 && (c = ArtifactsAPI.artifacts.getComponent(effectID)) != null) {
                    c.onUpdate(itemStack, player.field_70170_p, (Entity)player, -1, false);
                }
                d = (d = data.func_74762_e("onItemRightClickDelay")) > 0 ? --d : 0;
                data.func_74768_a("onItemRightClickDelay", d);
                ArrayList<String> keys = ArtifactsAPI.artifacts.getNBTKeys();
                String kk = "";
                int n = 0;
                for (int k = keys.size() - 1; k >= 0; --k) {
                    kk = keys.get(k);
                    if (!data.func_74764_b(kk)) continue;
                    n = data.func_74762_e(kk);
                    if (n > 0) {
                        --n;
                    }
                    data.func_74768_a(kk, n);
                }
            }
        } else if (!player.field_70170_p.field_72995_K) {
            itemStack = ArtifactsAPI.artifacts.applyRandomEffects(itemStack);
        }
    }

    @Override
    public void onEquipped(ItemStack itemStack, EntityLivingBase player) {
    }

    @Override
    public void onUnequipped(ItemStack itemStack, EntityLivingBase player) {
    }

    @Override
    public boolean canEquip(ItemStack itemStack, EntityLivingBase player) {
        return true;
    }

    @Override
    public boolean canUnequip(ItemStack itemStack, EntityLivingBase player) {
        return true;
    }

    static {
        doEnchName = true;
        doMatName = true;
        doAdjName = true;
    }
}

