/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.nei.ClientHandler;
import codechicken.nei.ServerHandler;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.asm.NEICorePlugin;
import codechicken.nei.config.IMCHandler;
import codechicken.nei.recipe.GuiRecipeTab;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.util.EnumChatFormatting;

public class NEIModContainer
extends DummyModContainer {
    public static LinkedList<IConfigureNEI> plugins = new LinkedList();
    private String description;

    public NEIModContainer() {
        super(MetadataCollection.from((InputStream)MetadataCollection.class.getResourceAsStream("/neimod.info"), (String)"NotEnoughItems").getMetadataForId("NotEnoughItems", null));
        this.loadMetadata();
    }

    public Set<ArtifactVersion> getRequirements() {
        HashSet<ArtifactVersion> deps = new HashSet<ArtifactVersion>();
        deps.add(VersionParser.parseVersionReference((String)"CodeChickenCore@[1.0.7,)"));
        return deps;
    }

    public List<ArtifactVersion> getDependencies() {
        return new LinkedList<ArtifactVersion>(this.getRequirements());
    }

    private void loadMetadata() {
        this.description = super.getMetadata().description.replace("Supporters:", EnumChatFormatting.AQUA + "Supporters:");
    }

    public ModMetadata getMetadata() {
        StringBuilder s_plugins = new StringBuilder();
        if (plugins.size() == 0) {
            s_plugins.append(EnumChatFormatting.RED).append("No installed plugins.");
        } else {
            s_plugins.append(EnumChatFormatting.GREEN).append("Installed plugins: ");
            for (int i = 0; i < plugins.size(); ++i) {
                if (i > 0) {
                    s_plugins.append(", ");
                }
                IConfigureNEI plugin = plugins.get(i);
                s_plugins.append(plugin.getName()).append(" ").append(plugin.getVersion());
            }
            s_plugins.append(".");
        }
        ModMetadata meta = super.getMetadata();
        meta.description = this.description.replace("<plugins>", s_plugins.toString());
        return meta;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        if (CommonUtils.isClient()) {
            ClientHandler.preInit();
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        if (CommonUtils.isClient()) {
            ClientHandler.load();
        }
        ServerHandler.load();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        if (CommonUtils.isClient()) {
            GuiRecipeTab.loadHandlerInfo();
        }
    }

    @Subscribe
    public void handleIMCMessages(FMLInterModComms.IMCEvent event) {
        IMCHandler.processIMC((List<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    public VersionRange acceptableMinecraftVersionRange() {
        return VersionParser.parseRange((String)"[1.7.10]");
    }

    public File getSource() {
        return NEICorePlugin.location;
    }

    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }
}

