/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.core.CommonUtils;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.HandlerInfo;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class IMCHandler {
    private IMCHandler() {
    }

    public static void processIMC(List<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            String type = message.key;
            if (type == null || type.isEmpty() || !CommonUtils.isClient()) continue;
            if (type.equals("registerHandlerInfo")) {
                IMCHandler.handleRegisterHandlerInfo(message);
                continue;
            }
            if (!type.equals("removeHandlerInfo")) continue;
            IMCHandler.handleRemoveHandlerInfo(message);
        }
    }

    private static void handleRegisterHandlerInfo(FMLInterModComms.IMCMessage message) {
        String itemName;
        String imageResource;
        String excludedModId;
        if (!message.isNBTMessage()) {
            IMCHandler.logInvalidMessage(message, "NBT");
            return;
        }
        NBTTagCompound tag = message.getNBTValue();
        String handler = tag.func_74779_i("handler");
        NEIClientConfig.logger.info("Processing registerHandlerInfo `" + handler + "` from " + message.getSender());
        String modName = tag.func_74779_i("modName");
        String modId = tag.func_74779_i("modId");
        boolean requiresMod = tag.func_74767_n("modRequired");
        String string = excludedModId = tag.func_74764_b("excludedModId") ? tag.func_74779_i("excludedModId") : null;
        if (handler.equals("") || modName.equals("") || modId.equals("")) {
            NEIClientConfig.logger.warn("Missing relevant information to registerHandlerInfo!");
            return;
        }
        if (requiresMod && !Loader.isModLoaded((String)modId)) {
            return;
        }
        if (excludedModId != null && Loader.isModLoaded((String)excludedModId)) {
            return;
        }
        HandlerInfo info = new HandlerInfo(handler, modName, modId, requiresMod, excludedModId);
        String string2 = imageResource = tag.func_74764_b("imageResource") ? tag.func_74779_i("imageResource") : null;
        if (imageResource != null && !imageResource.equals("")) {
            info.setImage(imageResource, tag.func_74762_e("imageX"), tag.func_74762_e("imageY"), tag.func_74762_e("imageWidth"), tag.func_74762_e("imageHeight"));
        }
        if (!info.hasImageOrItem() && (itemName = tag.func_74779_i("itemName")) != null && !itemName.equals("")) {
            info.setItem(itemName, tag.func_74764_b("nbtInfo") ? tag.func_74779_i("nbtInfo") : null);
        }
        int yShift = tag.func_74764_b("yShift") ? tag.func_74762_e("yShift") : 0;
        info.setYShift(yShift);
        try {
            int imageHeight = tag.func_74764_b("handlerHeight") ? tag.func_74762_e("handlerHeight") : HandlerInfo.DEFAULT_HEIGHT;
            int imageWidth = tag.func_74764_b("handlerWidth") ? tag.func_74762_e("handlerWidth") : HandlerInfo.DEFAULT_WIDTH;
            int maxRecipesPerPage = tag.func_74764_b("maxRecipesPerPage") ? tag.func_74762_e("maxRecipesPerPage") : HandlerInfo.DEFAULT_MAX_PER_PAGE;
            info.setHandlerDimensions(imageHeight, imageWidth, maxRecipesPerPage);
        }
        catch (NumberFormatException ignored) {
            NEIClientConfig.logger.info("Error setting handler dimensions for " + handler);
        }
        GuiRecipeTab.handlerAdderFromIMC.remove(handler);
        GuiRecipeTab.handlerAdderFromIMC.put(handler, info);
    }

    private static void handleRemoveHandlerInfo(FMLInterModComms.IMCMessage message) {
        if (!message.isNBTMessage()) {
            IMCHandler.logInvalidMessage(message, "NBT");
            return;
        }
        NBTTagCompound tag = message.getNBTValue();
        String handler = tag.func_74779_i("handler");
        NEIClientConfig.logger.info("Processing removeHandlerInfo `" + handler + "` from " + message.getSender());
        GuiRecipeTab.handlerRemoverFromIMC.add(handler);
    }

    private static void logInvalidMessage(FMLInterModComms.IMCMessage message, String type) {
        FMLLog.bigWarning((String)String.format("Received invalid IMC '%s' from %s. Not a %s Message.", message.key, message.getSender(), type), (Object[])new Object[0]);
    }
}

