@ECHO OFF
SETLOCAL
CLS

:SANITYCHECK
:: Prompts the user if they don't have a server file, in case they ran the batch by mistake
IF EXIST forge-1.7.10-10.13.4.1614-1.7.10-universal.jar (
    GOTO BEGIN
)

:PROMPTUSER
set /p CONFIRMSERVER="Do you want to convert this Galaxy Odyssey installation into a server (Y/N)? "
If /I "%CONFIRMSERVER%"=="y" GOTO SCRUBCLIENTFILES
If /I "%CONFIRMSERVER%"=="n" GOTO EXIT /B
ECHO.
ECHO Use [Y or y]/[N or n] for Yes/No
ECHO.
GOTO PROMPTUSER

:SCRUBCLIENTFILES
:: This part deletes all client-only files from the pack, printing out each deletion.
for /f "skip=4 delims=" %%f in (server_prep_files_to_remove.txt) do (
    IF EXIST "%%f" (
        ECHO Deleting client file: %%f
        DEL /f "%%f"
    )
)
ECHO.
ECHO Server prep finished!
ECHO.


:: From here on, the script downloads, installs, and runs the server.

:BEGIN
COLOR 3F >nul 2>&1
SET MC_SYS32=%SYSTEMROOT%\SYSTEM32
:: Make batch directory the same as the directory it's being called from
:: For example, if "run as admin" the batch starting dir could be system32
CD "%~dp0" >nul 2>&1

:CHECK
REM Check if serverstarter JAR is already downloaded
IF NOT EXIST "%cd%\serverstarter-2.0.1.jar" (
    ECHO serverstarter binary not found, downloading serverstarter...
    %SYSTEMROOT%\SYSTEM32\bitsadmin.exe /rawreturn /nowrap /transfer starter /dynamic /download /priority foreground https://github.com/Yoosk/ServerStarter/releases/download/v2.0.1/serverstarter-2.0.1.jar "%cd%\serverstarter-2.0.1.jar"
   GOTO MAIN
) ELSE (
   GOTO MAIN
)

:MAIN
java -jar serverstarter-2.0.1.jar
GOTO EOF

:EOF
PAUSE