#!/bin/bash
clear

# Prompts the user if they don't have a server file, in case they ran the batch by mistake
if [ ! -f  "forge-1.7.10-10.13.4.1614-1.7.10-universal.jar" ]; then
    while :
    do
        read -p "Do you want to convert this Galaxy Odyssey installation into a server (Y/N)? " -r
        if [[ $REPLY =~ ^[Yy]$ ]]
        then
            # This part deletes all client-only files from the pack, printing out each deletion.
            for f in $(tail -n +5 server_prep_files_to_remove.txt)
            do
                filepath=${f//\\//}
                
                if [ -f $filepath ]; then
                    echo Deleting client file: $filepath
                    rm $filepath
                fi
                
            done
            echo
            echo Server prep finished!
            echo
            break
        
        elif [[ $REPLY =~ ^[Nn]$ ]]
        then
            exit 1
        else
            echo
            tput setaf 3
            echo "Use [Y or y]/[N or n] for Yes/No"
            tput sgr0
            echo
        fi
    done
fi


# From here on, the script downloads, installs, and runs the server.

DO_RAMDISK=0
if [[ $(cat server-setup-config.yaml | grep 'ramDisk:' | awk 'BEGIN {FS=":"}{print $2}') =~ "yes" ]]; then
    SAVE_DIR=$(cat server.properties | grep 'level-name' | awk 'BEGIN {FS="="}{print $2}')
    mv "$SAVE_DIR" "${SAVE_DIR}_backup"
    mkdir "$SAVE_DIR"
    sudo mount -t tmpfs -o size=2G tmpfs "$SAVE_DIR"
    DO_RAMDISK=1
fi
    if [ -f serverstarter-2.2.0.jar ]; then
        echo "Skipping download. Using existing serverstarter-2.2.0.jar"
        java -jar serverstarter-2.2.0.jar
        if [[ $DO_RAMDISK -eq 1 ]]; then
            sudo umount "$SAVE_DIR"
            rm -rf "$SAVE_DIR"
            mv "${SAVE_DIR}_backup" "$SAVE_DIR"
        fi
        exit 0
    else
        export URL="https://github.com/BloodyMods/ServerStarter/releases/download/v2.2.0/serverstarter-2.2.0.jar"
    fi
    echo $URL
    if ! command - v wget >> /dev/null; then
        echo "DEBUG: (wget) Downloading ${URL}"
        wget -O serverstarter-2.2.0.jar "${URL}"
    else
        if ! command - v curl >> /dev/null; then
            echo "DEBUG: (curl) Downloading ${URL}"
            curl -o serverstarter-2.2.0.jar "${URL}"
        else
        echo "Neither wget or curl were found on your system. Please install one and try again"
        fi
    fi
java -jar serverstarter-2.2.0.jar
if [[ $DO_RAMDISK -eq 1 ]]; then
    sudo umount "$SAVE_DIR"
    rm -rf "$SAVE_DIR"
    mv "${SAVE_DIR}_backup" "$SAVE_DIR"
fi
