import mods.nei.NEI;
import minetweaker.item.IItemStack;



###########################
### Add things into NEI ###
###########################

NEI.addEntry(<minecraft:fence>.withTag({display: {Name: "Oak Fence"}}));




#############################
### Add tooltips to items ###
#############################

### This file adds some tooltips to certain items ###

# Some formatting options:

#format.black
#format.darkBlue
#format.darkGreen
#format.darkAqua
#format.darkRed
#format.darkPurple
#format.gold
#format.gray
#format.darkGray
#format.blue
#format.green
#format.aqua
#format.red
#format.lightPurple
#format.yellow
#format.white

#format.obfuscated
#format.bold
#format.strikethrough
#format.underline
#format.italic

# Example:
#<minecraft:stick>.addTooltip(format.green(format.italic("This is a stick") + " with " + format.strikethrough("text")) + " in multiple styles");

# Add my commentary to JAFFA foods
<jaffa:BaconIceCream>.addTooltip(format.yellow("Why"));

# Palette is off-limits because of UUID change
#<statues:statues.item.palette>.addTooltip(format.lightPurple("Recipe removed because of issues pinging skin server"));

# Add tooltip about asphalt
<chisel:concrete:10>.addTooltip(format.darkGray("AKA: Asphalt, Tarmac"));
<Metallurgy:utility.block:4>.addTooltip(format.darkGray("Watch the pitch drop in real time!"));

# Ancient Staff doesn't do anything anymore.
<BiomesOPlenty:ancientStaff:0>.addTooltip(format.lightPurple("Decorative only!"));





##################################
### Hide certain things in NEI ###
##################################

# Currently using config/INpureProjects/custom_nei_filters/_master_hide_list.js to hide things.
# This loop will be used to hide objects with meta values because I don't know how to do it in INpureCore

val masterHideList = [
	
    # Unused Wooden Doors entries
	<woodendoors:ancientdoor.acemus>,
	<woodendoors:ancientdoor.cedrum>,
	<woodendoors:ancientdoor.cerasu>,
	<woodendoors:ancientdoor.delnas>,
	<woodendoors:ancientdoor.ewcaly>,
	<woodendoors:ancientdoor.hekur>,
	<woodendoors:ancientdoor.kiparis>,
	<woodendoors:ancientdoor.kulist>,
	<woodendoors:ancientdoor.lata>,
	<woodendoors:ancientdoor.nucis>,
	<woodendoors:ancientdoor.porffor>,
	<woodendoors:ancientdoor.salyx>,
	<woodendoors:ancientdoor.tuopa>,
	<woodendoors:forestrydoor_acacia>,
	<woodendoors:forestrydoor_balsa>,
	<woodendoors:forestrydoor_baobab>,
	<woodendoors:forestrydoor_cherry>,
	<woodendoors:forestrydoor_chestnut>,
	<woodendoors:forestrydoor_citrus>,
	<woodendoors:forestrydoor_cocobolo>,
	<woodendoors:forestrydoor_ebony>,
	<woodendoors:forestrydoor_giganteum>,
	<woodendoors:forestrydoor_greenheart>,
	<woodendoors:forestrydoor_ipe>,
	<woodendoors:forestrydoor_kapok>,
	<woodendoors:forestrydoor_larch>,
	<woodendoors:forestrydoor_lime>,
	<woodendoors:forestrydoor_mahoe>,
	<woodendoors:forestrydoor_mahogany>,
	<woodendoors:forestrydoor_maple>,
	<woodendoors:forestrydoor_padauk>,
	<woodendoors:forestrydoor_palm>,
	<woodendoors:forestrydoor_papaya>,
	<woodendoors:forestrydoor_pine>,
	<woodendoors:forestrydoor_plum>,
	<woodendoors:forestrydoor_poplar>,
	<woodendoors:forestrydoor_sequoia>,
	<woodendoors:forestrydoor_teak>,
	<woodendoors:forestrydoor_walnut>,
	<woodendoors:forestrydoor_wenge>,
	<woodendoors:forestrydoor_willow>,
	<woodendoors:forestrydoor_zebrawood>,
	<woodendoors:forestrydoor.acacia>,
	<woodendoors:forestrydoor.balsa>,
	<woodendoors:forestrydoor.baobab>,
	<woodendoors:forestrydoor.cherry>,
	<woodendoors:forestrydoor.chestnut>,
	<woodendoors:forestrydoor.citrus>,
	<woodendoors:forestrydoor.cocobolo>,
	<woodendoors:forestrydoor.ebony>,
	<woodendoors:forestrydoor.giganteum>,
	<woodendoors:forestrydoor.greenheart>,
	<woodendoors:forestrydoor.ipe>,
	<woodendoors:forestrydoor.kapok>,
	<woodendoors:forestrydoor.larch>,
	<woodendoors:forestrydoor.lime>,
	<woodendoors:forestrydoor.mahoe>,
	<woodendoors:forestrydoor.mahogany>,
	<woodendoors:forestrydoor.maple>,
	<woodendoors:forestrydoor.padauk>,
	<woodendoors:forestrydoor.palm>,
	<woodendoors:forestrydoor.papaya>,
	<woodendoors:forestrydoor.pine>,
	<woodendoors:forestrydoor.plum>,
	<woodendoors:forestrydoor.poplar>,
	<woodendoors:forestrydoor.sequoia>,
	<woodendoors:forestrydoor.teak>,
	<woodendoors:forestrydoor.walnut>,
	<woodendoors:forestrydoor.wenge>,
	<woodendoors:forestrydoor.willow>,
	<woodendoors:forestrydoor.zebrawood>,
	<woodendoors:naturadoor.darkwood>,
	<woodendoors:naturadoor.fusewood>,
	<woodendoors:naturadoor.maple>,
	<woodendoors:naturadoor.silverbell>,
	<woodendoors:naturadoor.tiger>,

    
    # BoP Limestone
    <BiomesOPlenty:rocks:0>,
    <BiomesOPlenty:rocks:1>,
    
	# Gany's colorized quartz has a "white" variant that is not identical to default quartz.
	<ganysnether:colouredQuartzBlock:15>,
	<ganysnether:colouredChiselledQuartzBlock:15>,
	<ganysnether:whiteQuartzStairs:15>,
	<ganysnether:colouredQuartzPillar3:3>,
	
	# Hide Growthcraft fish trap
	<Growthcraft|Fishtrap:grc.fishTrap>,
	
	# Hide Dark Steel components (but not tools).
	# If you can't cast it into an ingot, it's not useful.
	<ExtraTiC:moltenDarkSteel>,
	<ExtraTiC:arrowhead:171>,
	<ExtraTiC:axeHead:171>,
	<ExtraTiC:battelSign:171>,
	<ExtraTiC:binding:171>,
	<ExtraTiC:chiselHead:171>,
	<ExtraTiC:chunk:171>,
	<ExtraTiC:crossbar:171>,
	<ExtraTiC:excavatorHead:171>,
	<ExtraTiC:frypanHead:171>,
	<ExtraTiC:fullGuard:171>,
	<ExtraTiC:hammerHead:171>,
	<ExtraTiC:knifeBlade:171>,
	<ExtraTiC:largeGuard:171>,
	<ExtraTiC:largeSwordBlade:171>,
	<ExtraTiC:largeplate:171>,
	<ExtraTiC:lumberaxeHead:171>,
	<ExtraTiC:mediumGuard:171>,
	<ExtraTiC:pickaxeHead:171>,
	<ExtraTiC:scytheHead:171>,
	<ExtraTiC:shovelHead:171>,
	<ExtraTiC:swordBlade:171>,
	<ExtraTiC:toolrod:171>,
	<ExtraTiC:toughbind:171>,
	<ExtraTiC:toughrod:171>,
	<ExtraTiC:shuriken:171>,
	<ExtraTiC:BowLimb:171>,
	<ExtraTiC:CrossbowLimb:171>,
	<ExtraTiC:CrossbowBody:171>,
	<ExtraTiC:Blot:171>,
	<ExtraTiC:extra.bucket:9>,
	
	# Remove Chisel's purpur
	<chisel:purpur:0>,
	<chisel:purpur:1>,
	
	# Gotta remove Cyanite Reprocessor because it crashes with AsieLib
	<BigReactors:BRDevice:0>,
	
	# More Planets uranium bomb and waste
	<MorePlanet:uranium_waste:0>,
	<MorePlanet:uranium_waste:1>,
	<MorePlanet:kapteyn-b_block:13>,
	<MorePlanet:kapteyn-b_item:1>,
	<MorePlanet:kapteyn-b_item:3>,
	
	# Space metals
	<GalacticraftMars:item.itemBasicAsteroids:5>, # Remove blue titanium
	<GalaxySpace:item.Ingots:5>, # Remove pink mithril
	<GalaxySpace:item.Ingots:8>, # Remove snot platinum
	
	# Installers (upgrade each machine to a "factory")
	<Mekanism:FactoryInstaller:0>,
	<Mekanism:FactoryInstaller:1>,
	<Mekanism:FactoryInstaller:2>,
	<Mekanism:FactoryInstaller:3>,
	
	# Hide Jetpacks and portable teleporter and flamethrower
	<GalaxySpace:item.JetPack:*>,
	
	# Remove auto-dictionary
	<Mariculture:machines_single:1>,
	
	# Hide Vanilla tools
	#<minecraft:iron_shovel>,
	#<minecraft:diamond_shovel>,
	#<minecraft:golden_shovel>,
	
	# Wood-looking obsidian chisel variation
	<chisel:obsidian:15>,
	
	# Change BoP bamboo to behave like growthcraft bamboo
	#<BiomesOPlenty:planks:10>,
	
	# TConstruct Moss Ball
	<TConstruct:materials:6>,
	
	# Spawners
	<minecraft:mob_spawner:*>,
	<TwilightForest:tile.TFBossSpawner:*>,
	
	# Free Runners
	<Mekanism:FreeRunners:1>,
	<Mekanism:FreeRunners:100>,
	
	# Atomic Disassembler
	<Mekanism:AtomicDisassembler:1>,
	<Mekanism:AtomicDisassembler:100>,
	
	# Electric Bow
	<Mekanism:ElectricBow:1>,
	<Mekanism:ElectricBow:100>,
	
	# Digital Miner
	#<Mekanism:MachineBlock:4>,
	
	# Wind Turbine
	<MekanismGenerators:Generator:6>,
	
	# Glider wing
	<OpenBlocks:generic:0>,
	
	# Zoocraft Discoveries particle blocks
	<ZoocraftDiscoveries:particle_block:*>,
	
] as IItemStack[];


for entry in masterHideList {
	NEI.hide(entry);
}


