#######################
### ALLOY ADDITIONS ###
#######################

# Liquids
val redAurum_liq = <liquid:red.aurum.molten>;
val ingotRedAurum_etic = <ExtraTiC:funStuffIngot:2>;
val blockRedAurum_etic = <ExtraTiC:blockFunStuff:2>;

//Red Aurum Implementation from Durpady at Feed The Beast forums
//https://forum.feed-the-beast.com/threads/minetweaker-modtweaker-a-help-and-suggestions-thread.52499/page-17#post-1314434

#Stats
#mods.tconstruct.ToolStats.set("Red Aurum", 4, 250, 7.5, 1, 1.2, 0, 0, "Red Aurum", "");
#mods.tconstruct.ToolStats.setBowStats("Red Aurum", 250, 40, 1.2);
#mods.tconstruct.ToolStats.setArrowStats("Red Aurum", 3.6F, 25F, 100F);

# Melting
mods.tconstruct.Smeltery.addMelting(blockRedAurum_etic, redAurum_liq * 1296, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(ingotRedAurum_etic, redAurum_liq * 144, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:toolrod:173>, redAurum_liq * 72, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:pickaxeHead:173>, redAurum_liq * 144, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:shovelHead:173>, redAurum_liq * 144, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:axeHead:173>, redAurum_liq * 144, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:swordBlade:173>, redAurum_liq * 144, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:largeGuard:173>, redAurum_liq * 72, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:mediumGuard:173>, redAurum_liq * 72, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:crossbar:173>, redAurum_liq * 72, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:binding:173>, redAurum_liq * 72, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:frypanHead:173>, redAurum_liq * 144, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:battelSign:173>, redAurum_liq * 144, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:knifeBlade:173>, redAurum_liq * 72, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:chiselHead:173>, redAurum_liq * 72, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:toughrod:173>, redAurum_liq * 432, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:toughbind:173>, redAurum_liq * 432, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:largeplate:173>, redAurum_liq * 1152, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:lumberaxeHead:173>, redAurum_liq * 1152, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:scytheHead:173>, redAurum_liq * 1152, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:excavatorHead:173>, redAurum_liq * 1152, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:largeSwordBlade:173>, redAurum_liq * 1152, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:hammerHead:173>, redAurum_liq * 1152, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:fullGuard:173>, redAurum_liq * 432, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:arrowhead:173>, redAurum_liq * 432, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:shuriken:173>, redAurum_liq * 72, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:CrossbowLimb:173>, redAurum_liq * 576, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:CrossbowBody:173>, redAurum_liq * 720, 80, blockRedAurum_etic);
mods.tconstruct.Smeltery.addMelting(<ExtraTiC:BowLimb:173>, redAurum_liq * 216, 80, blockRedAurum_etic);

# Alloying
mods.tconstruct.Smeltery.addAlloy(redAurum_liq * 144, [<liquid:redstone> * 144, <liquid:midasium.molten> * 144]);

# Block and item recipes
recipes.addShapeless(blockRedAurum_etic, [ingotRedAurum_etic * 9]);
recipes.addShapeless(ingotRedAurum_etic * 9, [blockRedAurum_etic]);

# Casting
mods.tconstruct.Casting.addBasinRecipe(blockRedAurum_etic, redAurum_liq * 1296, null, false, 100);
mods.tconstruct.Casting.addTableRecipe(ingotRedAurum_etic, redAurum_liq * 144, <TConstruct:metalPattern:0>, false, 100);
mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:toolrod:173>, redAurum_liq * 72, <TConstruct:metalPattern:1>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:pickaxeHead:173>, redAurum_liq * 144, <TConstruct:metalPattern:2>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:shovelHead:173>, redAurum_liq * 144, <TConstruct:metalPattern:3>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:axeHead:173>, redAurum_liq * 144, <TConstruct:metalPattern:4>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:swordBlade:173>, redAurum_liq * 144, <TConstruct:metalPattern:5>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:largeGuard:173>, redAurum_liq * 72, <TConstruct:metalPattern:6>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:mediumGuard:173>, redAurum_liq * 72, <TConstruct:metalPattern:7>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:crossbar:173>, redAurum_liq * 72, <TConstruct:metalPattern:8>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:binding:173>, redAurum_liq * 72, <TConstruct:metalPattern:9>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:frypanHead:173>, redAurum_liq * 144, <TConstruct:metalPattern:10>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:battelSign:173>, redAurum_liq * 144, <TConstruct:metalPattern:11>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:knifeBlade:173>, redAurum_liq * 72, <TConstruct:metalPattern:12>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:chiselHead:173>, redAurum_liq * 72, <TConstruct:metalPattern:13>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:toughrod:173>, redAurum_liq * 432, <TConstruct:metalPattern:14>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:toughbind:173>, redAurum_liq * 432, <TConstruct:metalPattern:15>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:largeplate:173>, redAurum_liq * 1152, <TConstruct:metalPattern:16>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:lumberaxeHead:173>, redAurum_liq * 1152, <TConstruct:metalPattern:17>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:scytheHead:173>, redAurum_liq * 1152, <TConstruct:metalPattern:18>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:excavatorHead:173>, redAurum_liq * 1152, <TConstruct:metalPattern:19>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:largeSwordBlade:173>, redAurum_liq * 1152, <TConstruct:metalPattern:20>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:hammerHead:173>, redAurum_liq * 1152, <TConstruct:metalPattern:21>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:fullGuard:173>, redAurum_liq * 432, <TConstruct:metalPattern:22>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:arrowhead:173>, redAurum_liq * 432, <TConstruct:metalPattern:25>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:shuriken:173>, redAurum_liq * 72, <TConstruct:Cast:0>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:CrossbowLimb:173>, redAurum_liq * 576, <TConstruct:Cast:1>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:CrossbowBody:173>, redAurum_liq * 720, <TConstruct:Cast:2>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<ExtraTiC:BowLimb:173>, redAurum_liq * 216, <TConstruct:Cast:3>, false, 80);
#mods.tconstruct.Casting.addTableRecipe(<TConstruct:BoltPart:*>.withTag({DualMat: {Material2: 173}}), redAurum_liq * 144, <TConstruct:toolRod:*>, true, 80);

# Repairing - Does not work
#mods.tconstruct.Tweaks.addRepairMaterial(ingotRedAurum_etic, "Red Aurum", 1);
#mods.tconstruct.Tweaks.addRepairMaterial(blockRedAurum_etic, "Red Aurum", 9);

### Have to add manual recipes because casting recipes don't work God damn it ###
recipes.addShapeless(<ExtraTiC:toolrod:173>*2, [<TConstruct:metalPattern:1>, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:pickaxeHead:173>, [<TConstruct:metalPattern:2>, ingotRedAurum_etic]);
recipes.addShapeless(<ExtraTiC:shovelHead:173>, [<TConstruct:metalPattern:3>, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:axeHead:173>, [<TConstruct:metalPattern:4>, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:swordBlade:173>, [<TConstruct:metalPattern:5>, ingotRedAurum_etic]);
recipes.addShapeless(<ExtraTiC:largeGuard:173>*2, [<TConstruct:metalPattern:6>, ingotRedAurum_etic]);
recipes.addShapeless(<ExtraTiC:mediumGuard:173>*2, [<TConstruct:metalPattern:7>, ingotRedAurum_etic]);
recipes.addShapeless(<ExtraTiC:crossbar:173>*2, [<TConstruct:metalPattern:8>, ingotRedAurum_etic]);
recipes.addShapeless(<ExtraTiC:binding:173>*2, [<TConstruct:metalPattern:9>, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:frypanHead:173>, [<TConstruct:metalPattern:10>, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:battelSign:173>, [<TConstruct:metalPattern:11>, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:knifeBlade:173>*2, [<TConstruct:metalPattern:12>, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:chiselHead:173>*2, [<TConstruct:metalPattern:13>, ingotRedAurum_etic]);
recipes.addShapeless(<ExtraTiC:toughrod:173>, [<TConstruct:metalPattern:14>, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic]);
recipes.addShapeless(<ExtraTiC:toughbind:173>, [<TConstruct:metalPattern:15>, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic]);
recipes.addShapeless(<ExtraTiC:largeplate:173>, [<TConstruct:metalPattern:16>, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:lumberaxeHead:173>, [<TConstruct:metalPattern:17>, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:scytheHead:173>, [<TConstruct:metalPattern:18>, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:excavatorHead:173>, [<TConstruct:metalPattern:19>, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:largeSwordBlade:173>, [<TConstruct:metalPattern:20>, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:hammerHead:173>, [<TConstruct:metalPattern:21>, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic]);
recipes.addShapeless(<ExtraTiC:fullGuard:173>, [<TConstruct:metalPattern:22>, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:arrowhead:173>, [<TConstruct:metalPattern:25>, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic]);
#recipes.addShapeless(<ExtraTiC:shuriken:173>*2, [<TConstruct:Cast:0>, ingotRedAurum_etic]);
recipes.addShapeless(<ExtraTiC:CrossbowLimb:173>, [<TConstruct:Cast:1>, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic]);
recipes.addShapeless(<ExtraTiC:CrossbowBody:173>, [<TConstruct:Cast:2>, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic]);
recipes.addShapeless(<ExtraTiC:BowLimb:173>*2, [<TConstruct:Cast:3>, ingotRedAurum_etic, ingotRedAurum_etic, ingotRedAurum_etic]);


#####################
### ALLOY CHANGES ###
#####################

# Remove easy-to-make Steel dust
mods.mekanism.Infuser.removeRecipe(<Mekanism:OtherDust:1>);
mods.mekanism.Infuser.removeRecipe(<Mekanism:EnrichedIron>);

# Change Bronze to require 3 copper, 1 tin
recipes.remove(<Metallurgy:base.dust:3>);
recipes.addShapeless(<Metallurgy:base.dust:3>*4, [<ore:dustCopper>, <ore:dustCopper>, <ore:dustCopper>, <ore:dustTin>]);

# Change Celenegil to make 1 per alloy
mods.metallurgy.Alloyer.removeRecipe(<Metallurgy:celenegil.ingot>);
mods.metallurgy.Alloyer.addRecipe(<Metallurgy:fantasy.dust:11>, <Metallurgy:precious.dust:2>, <Metallurgy:celenegil.ingot>);

# Change Quicksilver to make 1 per alloy
mods.metallurgy.Alloyer.removeRecipe(<Metallurgy:quicksilver.ingot>);
mods.metallurgy.Alloyer.addRecipe(<Metallurgy:fantasy.dust:7>, <Metallurgy:precious.dust:1>, <Metallurgy:quicksilver.ingot>);

# Change Amordrine to make 1 per alloy
mods.metallurgy.Alloyer.removeRecipe(<Metallurgy:amordrine.ingot>);
mods.metallurgy.Alloyer.addRecipe(<Metallurgy:nether.dust:7>, <Metallurgy:precious.dust:2>, <Metallurgy:amordrine.ingot>);

# Add Manyullyn alloyer recipe
recipes.remove(<TConstruct:materials:41>);
mods.metallurgy.Alloyer.addRecipe(<TConstruct:materials:38>, <TConstruct:materials:39>, <TConstruct:materials:5>);

# Change Tartarite to make 1 per alloy
mods.metallurgy.Alloyer.removeRecipe(<Metallurgy:tartarite.ingot>);
mods.metallurgy.Alloyer.addRecipe(<Metallurgy:fantasy.dust:13>, <Metallurgy:fantasy.dust:14>, <Metallurgy:tartarite.ingot>);


# Change Invar to produce one ingot from two iron, one nickel
mods.tconstruct.Smeltery.removeAlloy(<liquid:invar.molten>);
mods.tconstruct.Smeltery.addAlloy(<liquid:invar.molten> * 16, [<liquid:iron.molten> * 32, <liquid:nickel.molten> * 16]);

# Test
#mods.tconstruct.ToolStats.setStats("Stone", "Modtweaker Stone", 47, 108, 112, 83, 0.5, 102, 0.5, "gold", 484848);
